/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.web.analytics;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.annotation.HttpConstraint;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.eclipse.packagedrone.repo.MetaKeys;
import org.eclipse.packagedrone.repo.manage.core.CoreService;
import org.eclipse.packagedrone.repo.web.analytics.Configuration;
import org.eclipse.packagedrone.sec.web.controller.HttpContraintControllerInterceptor;
import org.eclipse.packagedrone.sec.web.controller.Secured;
import org.eclipse.packagedrone.sec.web.controller.SecuredControllerInterceptor;
import org.eclipse.packagedrone.web.Controller;
import org.eclipse.packagedrone.web.LinkTarget;
import org.eclipse.packagedrone.web.ModelAndView;
import org.eclipse.packagedrone.web.RequestMapping;
import org.eclipse.packagedrone.web.RequestMethod;
import org.eclipse.packagedrone.web.ViewResolver;
import org.eclipse.packagedrone.web.common.CommonController;
import org.eclipse.packagedrone.web.common.InterfaceExtender;
import org.eclipse.packagedrone.web.common.menu.MenuEntry;
import org.eclipse.packagedrone.web.controller.ControllerInterceptor;
import org.eclipse.packagedrone.web.controller.ControllerInterceptors;
import org.eclipse.packagedrone.web.controller.binding.BindingResult;
import org.eclipse.packagedrone.web.controller.form.FormData;

@Controller
@ViewResolver(value="/WEB-INF/views/%s.jsp")
@RequestMapping(value={"/system/extend/analytics"})
@Secured
@ControllerInterceptors(value={@ControllerInterceptor(value=SecuredControllerInterceptor.class), @ControllerInterceptor(value=HttpContraintControllerInterceptor.class)})
@HttpConstraint(rolesAllowed={"ADMIN"})
public class ConfigController
implements InterfaceExtender {
    private CoreService service;

    public void setService(CoreService service) {
        this.service = service;
    }

    @RequestMapping
    public ModelAndView edit() {
        HashMap<String, Configuration> model = new HashMap<String, Configuration>();
        model.put("command", this.load());
        return new ModelAndView("edit", model);
    }

    @RequestMapping(method={RequestMethod.POST})
    public ModelAndView editPost(@Valid @FormData(value="command") Configuration data, BindingResult result) {
        if (!result.hasErrors()) {
            try {
                Map md = MetaKeys.unbind((Object)data);
                this.service.setCoreProperties(md);
            }
            catch (Exception e) {
                return CommonController.createError((String)"Error", (String)"Failed to update configuration", (Throwable)e);
            }
        }
        HashMap<String, Configuration> model = new HashMap<String, Configuration>(1);
        model.put("command", this.load());
        return new ModelAndView("edit", model);
    }

    private Configuration load() {
        Map md = this.service.getCoreNamespaceProperties("ga", new String[]{"trackingId", "anonymizeIp", "forceSSL"});
        Configuration data = new Configuration();
        try {
            MetaKeys.bind((Object)data, (Map)md);
        }
        catch (Exception exception) {}
        return data;
    }

    public List<MenuEntry> getMainMenuEntries(HttpServletRequest request) {
        if (!request.isUserInRole("ADMIN")) {
            return null;
        }
        return Collections.singletonList(new MenuEntry("System", Integer.MAX_VALUE, "Analytics", 5000, LinkTarget.createFromController(ConfigController.class, (String)"edit"), null, "stats"));
    }
}

