/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scada.utils.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger logger = LoggerFactory.getLogger(NamedThreadFactory.class);
    private final AtomicLong counter;
    private final String name;
    private final boolean daemon;
    private final boolean logExceptions;

    public NamedThreadFactory(String name) {
        this(name, false);
    }

    public NamedThreadFactory(String name, boolean daemon) {
        this(name, daemon, true);
    }

    public NamedThreadFactory(String name, boolean daemon, boolean logExceptions) {
        this(name, daemon, true, new AtomicLong());
    }

    public NamedThreadFactory(String name, boolean daemon, boolean logExceptions, AtomicLong counter) {
        this.logExceptions = logExceptions;
        this.counter = counter;
        this.name = name;
        this.daemon = daemon;
        if (name == null) {
            throw new IllegalArgumentException(String.format("'name' must not be null", new Object[0]));
        }
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(r, this.createName());
        t.setDaemon(this.daemon);
        if (this.logExceptions && !Boolean.getBoolean("org.eclipse.scada.utils.concurrent.noDefaultLogger")) {
            t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    logger.warn(String.format("Thread %s failed and nobody cared", t), e);
                }
            });
        }
        return t;
    }

    protected String createName() {
        return String.format("%s/%s", this.name, this.counter.incrementAndGet());
    }
}

