/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.utils.converter.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.AnnotatedElement;
import org.eclipse.packagedrone.utils.converter.ConversionContext;
import org.eclipse.packagedrone.utils.converter.Converter;
import org.eclipse.packagedrone.utils.converter.JSON;

public class StringToJsonConverter
implements Converter {
    public static final StringToJsonConverter INSTANCE = new StringToJsonConverter();

    @Override
    public boolean canConvert(Class<?> from, Class<?> to) {
        return this.canConvert(from, to, null);
    }

    @Override
    public boolean canConvert(Class<?> from, Class<?> to, AnnotatedElement annotatedElement) {
        if (!from.equals(String.class)) {
            return false;
        }
        if (to.isAnnotationPresent(JSON.class)) {
            return true;
        }
        return annotatedElement != null && annotatedElement.isAnnotationPresent(JSON.class);
    }

    @Override
    public Object convertTo(Object value, Class<?> clazz, ConversionContext context) {
        if (value == null) {
            return null;
        }
        String val = (String)value;
        Gson gson = new GsonBuilder().create();
        return gson.fromJson(val, clazz);
    }
}

