/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.channel.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.packagedrone.repo.MetaKey;
import org.eclipse.packagedrone.repo.aspect.ChannelAspectProcessor;
import org.eclipse.packagedrone.repo.channel.AddingContext;
import org.eclipse.packagedrone.repo.channel.AspectableChannel;
import org.eclipse.packagedrone.repo.channel.ChannelId;
import org.eclipse.packagedrone.repo.channel.ChannelService;
import org.eclipse.packagedrone.repo.channel.ModifiableChannel;
import org.eclipse.packagedrone.repo.channel.PreAddContext;
import org.eclipse.packagedrone.repo.channel.ReadableChannel;
import org.eclipse.packagedrone.repo.channel.impl.ChannelFeature;
import org.eclipse.packagedrone.repo.channel.impl.ChannelInstanceModelProvider;
import org.eclipse.packagedrone.repo.channel.impl.ChannelProviderTracker;
import org.eclipse.packagedrone.repo.channel.impl.Disposing;
import org.eclipse.packagedrone.repo.channel.impl.ErrorChannel;
import org.eclipse.packagedrone.repo.channel.impl.ModifiableChannelAdapter;
import org.eclipse.packagedrone.repo.channel.impl.ProviderListener;
import org.eclipse.packagedrone.repo.channel.impl.ReadableChannelAdapter;
import org.eclipse.packagedrone.repo.channel.impl.trigger.TriggerDescriptorImpl;
import org.eclipse.packagedrone.repo.channel.impl.trigger.TriggeredChannelFeature;
import org.eclipse.packagedrone.repo.channel.provider.AccessContext;
import org.eclipse.packagedrone.repo.channel.provider.Channel;
import org.eclipse.packagedrone.repo.channel.provider.ChannelOperationContext;
import org.eclipse.packagedrone.repo.channel.provider.ChannelProvider;
import org.eclipse.packagedrone.repo.channel.provider.ModifyContext;
import org.eclipse.packagedrone.repo.trigger.ConfiguredTriggerFactoryTracker;
import org.eclipse.packagedrone.repo.trigger.ProcessorFactoryTracker;
import org.eclipse.packagedrone.repo.trigger.TriggerDescriptor;
import org.eclipse.packagedrone.repo.trigger.TriggerRunner;
import org.eclipse.packagedrone.storage.apm.StorageManager;
import org.eclipse.packagedrone.storage.apm.StorageModelProvider;
import org.eclipse.packagedrone.storage.apm.StorageRegistration;
import org.eclipse.packagedrone.utils.Locks;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelInstance
implements ProviderListener {
    private static final Logger logger = LoggerFactory.getLogger(ChannelInstance.class);
    private static final String TRIGGER_ID_PRE_ADD = "pre-add";
    private static final String TRIGGER_ID_ADDING = "adding";
    private static final String TRIGGER_ID_POST = "post";
    private Channel channel;
    private final String channelId;
    private final String providerId;
    private final Map<MetaKey, String> configuration;
    private final ChannelProviderTracker providerTracker;
    private boolean disposed;
    private final Lock readLock;
    private final Lock writeLock;
    private final ChannelAspectProcessor aspectProcessor;
    private final EventAdmin eventAdmin;
    private final Set<ChannelFeature> features = new HashSet<ChannelFeature>();
    private final StorageManager storage;
    private final StorageRegistration handle;
    private final TriggeredChannelFeature triggered;
    private final ProcessorFactoryTracker processorFactoryTracker;

    public ChannelInstance(String channelId, String providerId, Map<MetaKey, String> configuration, ChannelProviderTracker providerTracker, ChannelAspectProcessor aspectProcessor, EventAdmin eventAdmin, StorageManager storage, ProcessorFactoryTracker processorFactoryTracker, ConfiguredTriggerFactoryTracker triggerFactory) {
        this.channelId = channelId;
        this.providerId = providerId;
        this.configuration = configuration;
        this.providerTracker = providerTracker;
        this.aspectProcessor = aspectProcessor;
        this.eventAdmin = eventAdmin;
        this.storage = storage;
        this.processorFactoryTracker = processorFactoryTracker;
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock(false);
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        MetaKey channelKey = new MetaKey("channelInstance", channelId);
        this.handle = this.storage.registerModel(15000L, channelKey, (StorageModelProvider)new ChannelInstanceModelProvider(channelId));
        try {
            this.triggered = new TriggeredChannelFeature(channelId, storage, channelKey, processorFactoryTracker, triggerFactory, ChannelInstance.makePredefinedTriggers());
            this.addFeature(this.triggered);
            this.providerTracker.addListener(this.providerId, this);
        }
        catch (Exception e) {
            logger.warn("Failed to create channel instance: " + channelId, (Throwable)e);
            this.handle.unregister();
            throw e;
        }
    }

    private static Map<String, TriggerDescriptor> makePredefinedTriggers() {
        LinkedHashMap<String, TriggerDescriptor> result = new LinkedHashMap<String, TriggerDescriptor>();
        result.put(TRIGGER_ID_PRE_ADD, new TriggerDescriptorImpl("Before addition", "This trigger is fired before an artifact is being added.", PreAddContext.class));
        result.put(TRIGGER_ID_ADDING, new TriggerDescriptorImpl("During addition", "This trigger is fired during the addition of the artifact.", AddingContext.class));
        result.put(TRIGGER_ID_POST, new TriggerDescriptorImpl("Post operation", "This trigger is fired after each channel operation.", ModifiableChannel.class));
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose() {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            Locks.Locked l = Locks.lock((Lock)this.writeLock);
            try {
                if (this.disposed) {
                    return;
                }
                this.disposed = true;
                if (this.handle != null) {
                    this.handle.unregister();
                }
                this.providerTracker.removeListener(this.providerId, this);
                this.unbind();
                return;
            }
            finally {
                if (l == null) return;
                l.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public void addFeature(ChannelFeature feature) {
        this.features.add(feature);
    }

    public void removeFeature(ChannelFeature feature) {
        this.features.remove(feature);
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getProviderId() {
        return this.providerId;
    }

    public Map<MetaKey, String> getConfiguration() {
        return this.configuration;
    }

    @Deprecated
    public Optional<Channel> getChannel() {
        return (Optional)Locks.call((Lock)this.readLock, () -> Optional.ofNullable(this.channel));
    }

    @Override
    public void bind(ChannelProvider provider) {
        logger.debug("Binding to provider: {}", (Object)provider);
        Throwable throwable = null;
        Object var3_4 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
            this.channel = provider.load(this.channelId, this.configuration);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void unbind() {
        logger.debug("Unbinding from provider");
        Throwable throwable = null;
        Object var2_3 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.writeLock);){
            if (this.channel != null) {
                this.channel.dispose();
                this.channel = null;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <R, T> R access(ChannelId id, Class<T> clazz, ChannelService.ChannelOperation<R, T> operation) {
        if (ReadableChannel.class.equals(clazz)) {
            return this.access(id, operation);
        }
        if (ModifiableChannel.class.equals(clazz)) {
            return this.modify(id, this.makeChannelOperationContext(), this.aspectProcessor, operation);
        }
        if (AspectableChannel.class.equals(clazz)) {
            return this.modify(id, this.makeChannelOperationContext(), this.aspectProcessor, operation);
        }
        for (ChannelFeature feature : this.features) {
            if (!feature.supportsAccess(clazz)) continue;
            try {
                return feature.access(id, clazz, operation);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        throw new IllegalArgumentException(String.format("Unknown channel adapter: %s", clazz.getName()));
    }

    public <R> R access(ChannelId id, ChannelService.ChannelOperation<R, ReadableChannel> operation) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.readLock);){
            Channel channel = this.channel != null ? this.channel : new ErrorChannel(this.unboundMessage());
            return (R)channel.accessCall(ctx -> {
                Throwable throwable = null;
                Object var4_5 = null;
                try {
                    Object object;
                    Disposing<AccessContext> wrappedCtx = Disposing.proxy(AccessContext.class, ctx);
                    try {
                        block14: {
                            Disposing<ReadableChannelAdapter> channelInterface = Disposing.proxy(ReadableChannel.class, new ReadableChannelAdapter(id, wrappedCtx.getTarget()));
                            try {
                                object = operation.process((Object)channelInterface.getTarget());
                                return object;
                            }
                            finally {
                                if (channelInterface == null) break block14;
                                channelInterface.close();
                            }
                        }
                        if (wrappedCtx != null) {
                            wrappedCtx.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (wrappedCtx == null) throw throwable;
                        wrappedCtx.close();
                        throw throwable;
                    }
                    {
                        return object;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            });
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public <R> R modify(ChannelId id, ChannelOperationContext context, ChannelAspectProcessor aspectProcessor, ChannelService.ChannelOperation<R, ModifiableChannel> operation) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (Locks.Locked l = Locks.lock((Lock)this.readLock);){
            if (this.channel == null) {
                throw new IllegalStateException(this.unboundMessage());
            }
            return (R)this.channel.modifyCall(ctx -> {
                Throwable throwable = null;
                Object var6_7 = null;
                try {
                    Object object;
                    Disposing<ModifyContext> wrappedCtx = Disposing.proxy(ModifyContext.class, ctx);
                    try {
                        block14: {
                            Disposing<ModifiableChannelAdapter> channelInterface = Disposing.proxy(ModifiableChannel.class, new ModifiableChannelAdapter(id, wrappedCtx.getTarget(), aspectProcessor));
                            try {
                                Object result = operation.process((Object)channelInterface.getTarget());
                                this.runPostTrigger(channelInterface.getTarget());
                                object = result;
                                return object;
                            }
                            finally {
                                if (channelInterface == null) break block14;
                                channelInterface.close();
                            }
                        }
                        if (wrappedCtx != null) {
                            wrappedCtx.close();
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        if (wrappedCtx == null) throw throwable;
                        wrappedCtx.close();
                        throw throwable;
                    }
                    {
                        return object;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                        throw throwable;
                    }
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                    throw throwable;
                }
            }, context);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void runPreAddTrigger(PreAddContext ctx) {
        this.runTrigger(TRIGGER_ID_PRE_ADD, ctx);
    }

    private void runAddingTrigger(AddingContext ctx) {
        this.runTrigger(TRIGGER_ID_ADDING, ctx);
    }

    private void runPostTrigger(ModifiableChannel ctx) {
        this.runTrigger(TRIGGER_ID_POST, ctx);
    }

    private void runTrigger(String triggerId, Object ctx) {
        new TriggerRunner(this.processorFactoryTracker, this.triggered.getProcessors(triggerId), ctx).run();
    }

    private String unboundMessage() {
        return String.format("Channel '%s' is not bound to provider '%s'", this.channelId, this.providerId);
    }

    private ChannelOperationContext makeChannelOperationContext() {
        return new ChannelOperationContext(){

            public void artifactPreAdd(PreAddContext ctx) {
                ChannelInstance.this.runPreAddTrigger(ctx);
            }

            public void artifactAdding(AddingContext ctx) {
                ChannelInstance.this.runAddingTrigger(ctx);
            }

            public void postAspectOperation(String aspectId, String operation) {
                HashMap<String, String> data = new HashMap<String, String>(2);
                data.put("operation", operation);
                data.put("aspectFactoryId", aspectId);
                ChannelInstance.this.eventAdmin.postEvent(new Event(String.format("drone/channel/%s/aspect", this.makeSafeTopic(ChannelInstance.this.channelId)), data));
            }

            private String makeSafeTopic(String aspectId) {
                return aspectId.replaceAll("[^a-zA-Z0-9_\\-]", "_");
            }
        };
    }
}

