/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.web.interceptor;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.packagedrone.web.interceptor.Interceptor;
import org.eclipse.packagedrone.web.interceptor.InterceptorLocator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class InterceptorTracker
implements InterceptorLocator {
    private final ServiceTracker<Interceptor, Interceptor> tracker;
    private final ServiceTrackerCustomizer<Interceptor, Interceptor> customizer = new ServiceTrackerCustomizer<Interceptor, Interceptor>(){

        public void removedService(ServiceReference<Interceptor> reference, Interceptor service) {
            InterceptorTracker.this.removeInterceptor(reference);
            InterceptorTracker.this.context.ungetService(reference);
        }

        public void modifiedService(ServiceReference<Interceptor> reference, Interceptor service) {
            InterceptorTracker.this.removeInterceptor(reference);
            InterceptorTracker.this.addInterceptor(service, reference);
        }

        public Interceptor addingService(ServiceReference<Interceptor> reference) {
            Interceptor service = (Interceptor)InterceptorTracker.this.context.getService(reference);
            InterceptorTracker.this.addInterceptor(service, reference);
            return service;
        }
    };
    private final BundleContext context;
    private final SortedMap<ServiceReference<?>, Interceptor> cacheMap = new TreeMap(new Comparator<ServiceReference<?>>(){

        @Override
        public int compare(ServiceReference<?> o1, ServiceReference<?> o2) {
            return o2.compareTo(o1);
        }
    });
    private volatile Interceptor[] cache = new Interceptor[0];

    public InterceptorTracker(BundleContext context) {
        this.context = context;
        this.tracker = new ServiceTracker(context, Interceptor.class, this.customizer);
        this.tracker.open();
    }

    protected synchronized void addInterceptor(Interceptor service, ServiceReference<Interceptor> reference) {
        this.cacheMap.put(reference, service);
        this.updateCache();
    }

    protected synchronized void removeInterceptor(ServiceReference<Interceptor> reference) {
        this.cacheMap.remove(reference);
        this.updateCache();
    }

    private void updateCache() {
        this.cache = this.cacheMap.values().toArray(new Interceptor[this.cacheMap.size()]);
    }

    @Override
    public void close() {
        this.tracker.close();
        this.cache = new Interceptor[0];
    }

    @Override
    public Interceptor[] getInterceptors() {
        return this.cache;
    }
}

