/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packagedrone.repo.trigger;

import java.util.List;
import java.util.Objects;
import org.eclipse.packagedrone.repo.trigger.Processor;
import org.eclipse.packagedrone.repo.trigger.ProcessorFactory;
import org.eclipse.packagedrone.repo.trigger.ProcessorFactoryTracker;
import org.eclipse.packagedrone.repo.trigger.TriggerProcessorConfiguration;

public class TriggerRunner {
    private final List<TriggerProcessorConfiguration> processors;
    private final ProcessorFactoryTracker factoryTracker;
    private final Object context;

    public TriggerRunner(ProcessorFactoryTracker factoryTracker, List<TriggerProcessorConfiguration> processors, Object context) {
        this.factoryTracker = Objects.requireNonNull(factoryTracker);
        this.processors = Objects.requireNonNull(processors);
        this.context = Objects.requireNonNull(context);
    }

    public void run() {
        this.processors.stream().forEachOrdered(this::runProcessor);
    }

    private void runProcessor(TriggerProcessorConfiguration cfg) {
        String factoryId = cfg.getFactoryId();
        this.factoryTracker.process(factoryId, factory -> this.runProcessor((ProcessorFactory)factory, factoryId, cfg.getConfiguration()));
    }

    private void runProcessor(ProcessorFactory factory, String factoryId, String configuration) {
        if (!factory.supportsContext(this.context.getClass())) {
            throw new IllegalStateException(String.format("Trying to call processor '%s' with context class '%s', which is not supported by the processor", factoryId, this.context.getClass().getName()));
        }
        Processor processor = factory.create(configuration);
        processor.process(this.context);
    }
}

