/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.conditions;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.passage.lic.base.LicensingResults;
import org.eclipse.passage.lic.base.conditions.BaseLicensingCondition;
import org.eclipse.passage.lic.runtime.LicensingResult;
import org.eclipse.passage.lic.runtime.conditions.LicensingCondition;

public class LicensingConditions {
    private static final String SEGMENT_SEPARATOR = ";";
    private static final String VALUE_SEPARATOR = "=";

    private LicensingConditions() {
    }

    public static Map<String, String> parseExpression(String expression) {
        String[] segments;
        HashMap<String, String> map = new HashMap<String, String>();
        if (expression == null) {
            return map;
        }
        String[] stringArray = segments = expression.split(SEGMENT_SEPARATOR);
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            String[] split = segment.split(VALUE_SEPARATOR);
            if (split.length == 2) {
                map.put(split[0], split[1]);
            }
            ++n2;
        }
        return map;
    }

    public static boolean evaluateSegmentValue(String expected, String actual) {
        if (actual == null) {
            return false;
        }
        String regexp = expected.replaceAll("\\*", ".*");
        return actual.matches(regexp);
    }

    public static LicensingCondition create(String identifier, String version, String rule, Date from, Date until, String type, String expression) {
        return new BaseLicensingCondition(identifier, version, rule, from, until, type, expression);
    }

    public static LicensingResult validate(LicensingCondition condition, String source) {
        Date validFrom = condition.getValidFrom();
        if (validFrom == null) {
            String format = "Valid from not specified for condition %s";
            String message = String.format(format, condition);
            return LicensingResults.createError(message, source);
        }
        Date now = new Date();
        if (validFrom.after(now)) {
            String format = "Valid from starts in the future for condition %s";
            String message = String.format(format, condition);
            return LicensingResults.createError(message, source);
        }
        Date validUntil = condition.getValidUntil();
        if (validUntil == null) {
            String format = "Valid until not specified for condition %s";
            String message = String.format(format, condition);
            return LicensingResults.createError(message, source);
        }
        if (validUntil.before(now)) {
            String format = "Valid until ends in the past for condition %s";
            String message = String.format(format, condition);
            return LicensingResults.createError(message, source);
        }
        return LicensingResults.createOK("", source);
    }
}

