/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.base.permission;

import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.StreamSupport;
import org.eclipse.passage.lic.api.access.FeaturePermission;
import org.eclipse.passage.lic.internal.base.permission.LimitedPermission;
import org.eclipse.passage.lic.internal.base.permission.PermissionObservatory;
import org.eclipse.passage.lic.internal.base.permission.observatory.GuardedObservatory;

public final class BasePermissionObservatory
implements PermissionObservatory {
    private final GuardedObservatory<LimitedPermission> observatory;

    public BasePermissionObservatory(int seconds, Consumer<Set<LimitedPermission>> farewell) {
        this.observatory = new GuardedObservatory(seconds, farewell);
    }

    public void watch(Iterable<FeaturePermission> permissions) {
        this.onEachPermission(permissions, limited -> this.observatory.watch((LimitedPermission)limited));
    }

    public void forget(Iterable<FeaturePermission> permissions) {
        this.onEachPermission(permissions, limited -> this.observatory.forget((LimitedPermission)limited));
    }

    public void open() {
        this.observatory.open();
    }

    private void onEachPermission(Iterable<FeaturePermission> permissions, Consumer<LimitedPermission> action) {
        StreamSupport.stream(permissions.spliterator(), false).map(LimitedPermission::new).forEach(limited -> action.accept((LimitedPermission)limited));
    }
}

