/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.access;

import java.util.Collections;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.Framework;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.access.GrantLockAttempt;
import org.eclipse.passage.lic.api.acquire.GrantAcquisition;
import org.eclipse.passage.lic.api.acquire.LicenseAcquisitionService;
import org.eclipse.passage.lic.api.acquire.LicenseAcquisitionServicesRegistry;
import org.eclipse.passage.lic.api.conditions.ConditionMiningTarget;
import org.eclipse.passage.lic.api.conditions.evaluation.Permission;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.api.registry.ServiceId;
import org.eclipse.passage.lic.api.requirements.Requirement;
import org.eclipse.passage.lic.api.restrictions.ExaminationCertificate;
import org.eclipse.passage.lic.api.restrictions.Restriction;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.access.BaseGrantLockAttempt;
import org.eclipse.passage.lic.base.access.TentativeFeatureAccess;
import org.eclipse.passage.lic.base.diagnostic.BaseDiagnostic;
import org.eclipse.passage.lic.base.diagnostic.code.NoServicesOfType;
import org.eclipse.passage.lic.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.base.diagnostic.code.TentativeAccess;
import org.eclipse.passage.lic.base.restrictions.RequirementDemandsExecutionStop;
import org.eclipse.passage.lic.internal.base.i18n.AccessCycleMessages;

final class Lock {
    private final LicenseAcquisitionServicesRegistry acquirers;

    Lock(LicenseAcquisitionServicesRegistry acquirers) {
        this.acquirers = acquirers;
    }

    Lock(Framework framework) {
        this(framework.accessCycleConfiguration().acquirers());
    }

    ServiceInvocationResult<GrantLockAttempt> lock(ExaminationCertificate certificate) {
        if (this.notPermissive(certificate)) {
            return this.tentativeGrant(certificate);
        }
        Permission permission = this.permission(certificate);
        ConditionMiningTarget target = permission.conditionOrigin().miner();
        if (!((Registry)this.acquirers.get()).hasService((ServiceId)target)) {
            return this.noService(new BaseGrantLockAttempt.Failed(certificate), target);
        }
        ServiceInvocationResult grant = ((LicenseAcquisitionService)((Registry)this.acquirers.get()).service((ServiceId)target)).acquire(permission.product(), permission.condition().feature());
        if (!grant.data().isPresent()) {
            return this.canIssueTentativeGrant(certificate) ? this.tentativeGrant(certificate) : this.noGrant(certificate, (ServiceInvocationResult<GrantAcquisition>)grant);
        }
        return this.grant(certificate, (GrantAcquisition)grant.data().get(), grant.diagnostic());
    }

    ServiceInvocationResult<Boolean> unlock(GrantLockAttempt lock) {
        if (!lock.successful()) {
            return this.wrongLockWarning();
        }
        if (new TentativeFeatureAccess().test(lock.grant())) {
            return new BaseServiceInvocationResult<Boolean>(Boolean.TRUE);
        }
        Permission permission = this.permission(lock.certificate());
        ConditionMiningTarget target = permission.conditionOrigin().miner();
        if (!((Registry)this.acquirers.get()).hasService((ServiceId)target)) {
            return this.noService(Boolean.FALSE, target);
        }
        return ((LicenseAcquisitionService)((Registry)this.acquirers.get()).service((ServiceId)target)).release(permission.product(), lock.grant());
    }

    private BaseServiceInvocationResult<GrantLockAttempt> noGrant(ExaminationCertificate certificate, ServiceInvocationResult<GrantAcquisition> grant) {
        return new BaseServiceInvocationResult<GrantLockAttempt>(grant.diagnostic(), new BaseGrantLockAttempt.Failed(certificate));
    }

    private ServiceInvocationResult<GrantLockAttempt> grant(ExaminationCertificate certificate, GrantAcquisition grant, Diagnostic diagnostic) {
        return new BaseServiceInvocationResult<GrantLockAttempt>(diagnostic, new BaseGrantLockAttempt.Successful(certificate, grant));
    }

    private ServiceInvocationResult<Boolean> wrongLockWarning() {
        return new BaseServiceInvocationResult<Boolean>(this.fail("Lock.wrong_release"));
    }

    private BaseDiagnostic fail(String details) {
        return new BaseDiagnostic(Collections.emptyList(), Collections.singletonList(new Trouble((TroubleCode)new ServiceFailedOnMorsel(), AccessCycleMessages.getString(details))));
    }

    private <T> ServiceInvocationResult<T> noService(T data, ConditionMiningTarget target) {
        return new BaseServiceInvocationResult<T>((Diagnostic)new BaseDiagnostic(new Trouble((TroubleCode)new NoServicesOfType(AccessCycleMessages.getString("Lock.no_service")), String.format(AccessCycleMessages.getString("Lock.no_service_for_target"), target.toString()))), data);
    }

    private boolean notPermissive(ExaminationCertificate certificate) {
        return certificate.satisfied().isEmpty();
    }

    private Permission permission(ExaminationCertificate certificate) {
        Requirement any = (Requirement)certificate.satisfied().iterator().next();
        return certificate.satisfaction(any);
    }

    private ServiceInvocationResult<GrantLockAttempt> tentativeGrant(ExaminationCertificate certificate) {
        return this.grant(certificate, new TentativeFeatureAccess(this.feature(certificate)).get(), this.tentativeReport(certificate));
    }

    private Diagnostic tentativeReport(ExaminationCertificate certificate) {
        return new BaseDiagnostic(Collections.emptyList(), certificate.restrictions().stream().map(this::explained).collect(Collectors.toList()));
    }

    private Trouble explained(Restriction restriction) {
        return new Trouble((TroubleCode)new TentativeAccess(), String.format(AccessCycleMessages.getString("Lock.temp_access"), this.feature(restriction.unsatisfiedRequirement())));
    }

    private String feature(ExaminationCertificate certificate) {
        return this.feature(certificate.restrictions().isEmpty() ? (Requirement)certificate.satisfied().iterator().next() : ((Restriction)certificate.restrictions().iterator().next()).unsatisfiedRequirement());
    }

    private String feature(Requirement requirement) {
        return requirement.feature().identifier();
    }

    private boolean canIssueTentativeGrant(ExaminationCertificate certificate) {
        return certificate.satisfied().stream().noneMatch(new RequirementDemandsExecutionStop());
    }
}

