/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.di.ObjectDescriptor;
import org.eclipse.e4.core.internal.di.Requestor;

public class ConstructorRequestor
extends Requestor<Constructor<?>> {
    public ConstructorRequestor(Constructor<?> constructor, IInjector injector, PrimaryObjectSupplier primarySupplier, PrimaryObjectSupplier tempSupplier) {
        super(constructor, injector, primarySupplier, tempSupplier, null, false);
    }

    @Override
    public Object execute() throws InjectionException {
        Object result = null;
        if (!((Constructor)this.location).isAccessible()) {
            ((Constructor)this.location).setAccessible(true);
        }
        boolean pausedRecording = false;
        if (this.primarySupplier != null) {
            this.primarySupplier.pauseRecording();
            pausedRecording = true;
        }
        try {
            try {
                result = ((Constructor)this.location).newInstance(this.actualArgs);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new InjectionException(e);
            }
            catch (InstantiationException e) {
                throw new InjectionException("Unable to instantiate " + this.location, e);
            }
            catch (InvocationTargetException e) {
                Throwable originalException = e.getCause();
                if (originalException instanceof Error) {
                    throw (Error)originalException;
                }
                throw new InjectionException(originalException != null ? originalException : e);
            }
        }
        finally {
            if (pausedRecording) {
                this.primarySupplier.resumeRecording();
            }
            this.clearResolvedArgs();
        }
        return result;
    }

    @Override
    public IObjectDescriptor[] calcDependentObjects() {
        Annotation[][] annotations = ((Constructor)this.location).getParameterAnnotations();
        Type[] logicalParams = ((Constructor)this.location).getGenericParameterTypes();
        Class<?>[] compilerParams = ((Constructor)this.location).getParameterTypes();
        if (compilerParams.length > logicalParams.length) {
            Type[] tmp = new Type[compilerParams.length];
            System.arraycopy(compilerParams, 0, tmp, 0, compilerParams.length - logicalParams.length);
            System.arraycopy(logicalParams, 0, tmp, compilerParams.length - logicalParams.length, logicalParams.length);
            logicalParams = tmp;
        }
        if (logicalParams.length == 0) {
            return EMPTY_DESCRIPTORS;
        }
        IObjectDescriptor[] descriptors = new IObjectDescriptor[logicalParams.length];
        int i = 0;
        while (i < logicalParams.length) {
            descriptors[i] = new ObjectDescriptor(logicalParams[i], annotations[i]);
            ++i;
        }
        return descriptors;
    }

    @Override
    public Class<?> getRequestingObjectClass() {
        return ((Constructor)this.location).getDeclaringClass();
    }

    public String toString() {
        StringBuilder tmp = new StringBuilder();
        Object object = this.getRequestingObject();
        if (object != null) {
            tmp.append(object.getClass().getSimpleName());
        } else {
            tmp.append(((Constructor)this.location).getDeclaringClass().getSimpleName());
        }
        tmp.append('(');
        tmp.append(')');
        return tmp.toString();
    }
}

