/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.rwt.internal.theme;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.protocol.JsonUtil;
import org.eclipse.rap.rwt.internal.theme.CssAnimation;
import org.eclipse.rap.rwt.internal.theme.CssBorder;
import org.eclipse.rap.rwt.internal.theme.CssBoxDimensions;
import org.eclipse.rap.rwt.internal.theme.CssColor;
import org.eclipse.rap.rwt.internal.theme.CssCursor;
import org.eclipse.rap.rwt.internal.theme.CssDimension;
import org.eclipse.rap.rwt.internal.theme.CssFloat;
import org.eclipse.rap.rwt.internal.theme.CssFont;
import org.eclipse.rap.rwt.internal.theme.CssIdentifier;
import org.eclipse.rap.rwt.internal.theme.CssImage;
import org.eclipse.rap.rwt.internal.theme.CssShadow;
import org.eclipse.rap.rwt.internal.theme.CssValue;
import org.eclipse.rap.rwt.internal.theme.Size;
import org.eclipse.rap.rwt.service.ApplicationContext;
import org.eclipse.rap.rwt.theme.BoxDimensions;

public final class ThemePropertyAdapterRegistry {
    private static final Object LOCK = new Object();
    private static final String ATTR_NAME = ThemePropertyAdapterRegistry.class.getName() + "#instance";
    private final Map<Class<? extends CssValue>, ThemePropertyAdapter> map = new HashMap<Class<? extends CssValue>, ThemePropertyAdapter>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThemePropertyAdapterRegistry getInstance(ApplicationContext applicationContext) {
        ThemePropertyAdapterRegistry result;
        Object object = LOCK;
        synchronized (object) {
            result = (ThemePropertyAdapterRegistry)applicationContext.getAttribute(ATTR_NAME);
            if (result == null) {
                result = new ThemePropertyAdapterRegistry();
                applicationContext.setAttribute(ATTR_NAME, result);
            }
        }
        return result;
    }

    private ThemePropertyAdapterRegistry() {
        this.map.put(CssAnimation.class, new AnimationPropertyAdapter());
        this.map.put(CssBorder.class, new BorderPropertyAdapter());
        this.map.put(CssBoxDimensions.class, new BoxDimensionsPropertyAdapter());
        this.map.put(CssColor.class, new ColorPropertyAdapter());
        this.map.put(CssCursor.class, new CursorPropertyAdapter());
        this.map.put(CssDimension.class, new DimensionPropertyAdapter());
        this.map.put(CssFloat.class, new DirectPropertyAdapter());
        this.map.put(CssFont.class, new FontPropertyAdapter());
        this.map.put(CssIdentifier.class, new DirectPropertyAdapter());
        this.map.put(CssImage.class, new ImagePropertyAdapter());
        this.map.put(CssShadow.class, new ShadowPropertyAdapter());
    }

    ThemePropertyAdapter getPropertyAdapter(Class<?> key) {
        return this.map.get(key);
    }

    static class AnimationPropertyAdapter
    implements ThemePropertyAdapter {
        AnimationPropertyAdapter() {
        }

        @Override
        public String getKey(CssValue value) {
            return Integer.toHexString(value.hashCode());
        }

        @Override
        public String getSlot(CssValue value) {
            return "animations";
        }

        @Override
        public JsonValue getValue(CssValue value) {
            CssAnimation animation = (CssAnimation)value;
            JsonObject result = new JsonObject();
            int j = 0;
            while (j < animation.animations.length) {
                CssAnimation.Animation currentAnimation = animation.animations[j];
                JsonArray currentAnimationArray = new JsonArray();
                currentAnimationArray.add(currentAnimation.duration);
                String timingFunction = CssAnimation.toCamelCaseString(currentAnimation.timingFunction);
                currentAnimationArray.add(timingFunction);
                result.add(currentAnimation.name, currentAnimationArray);
                ++j;
            }
            return result;
        }
    }

    static class BorderPropertyAdapter
    implements ThemePropertyAdapter {
        BorderPropertyAdapter() {
        }

        @Override
        public String getKey(CssValue value) {
            return Integer.toHexString(value.hashCode());
        }

        @Override
        public String getSlot(CssValue value) {
            return "borders";
        }

        @Override
        public JsonValue getValue(CssValue value) {
            CssBorder border = (CssBorder)value;
            JsonObject result = new JsonObject();
            result.add("width", border.width);
            result.add("style", border.style);
            result.add("color", border.color == null ? null : border.color.toDefaultString());
            return result;
        }
    }

    static class BoxDimensionsPropertyAdapter
    implements ThemePropertyAdapter {
        BoxDimensionsPropertyAdapter() {
        }

        @Override
        public String getKey(CssValue value) {
            return Integer.toHexString(value.hashCode());
        }

        @Override
        public String getSlot(CssValue value) {
            return "boxdims";
        }

        @Override
        public JsonValue getValue(CssValue value) {
            BoxDimensions boxdim = ((CssBoxDimensions)value).dimensions;
            JsonArray result = new JsonArray();
            result.add(boxdim.top);
            result.add(boxdim.right);
            result.add(boxdim.bottom);
            result.add(boxdim.left);
            return result;
        }
    }

    static class ColorPropertyAdapter
    implements ThemePropertyAdapter {
        ColorPropertyAdapter() {
        }

        @Override
        public String getKey(CssValue value) {
            return Integer.toHexString(value.hashCode());
        }

        @Override
        public String getSlot(CssValue value) {
            return "colors";
        }

        @Override
        public JsonValue getValue(CssValue value) {
            JsonValue result;
            CssColor color = (CssColor)value;
            if (color.isTransparent()) {
                result = JsonValue.valueOf("undefined");
            } else {
                JsonArray colorArray = new JsonArray();
                colorArray.add(color.red);
                colorArray.add(color.green);
                colorArray.add(color.blue);
                colorArray.add(color.alpha);
                result = colorArray;
            }
            return result;
        }
    }

    static class CursorPropertyAdapter
    implements ThemePropertyAdapter {
        CursorPropertyAdapter() {
        }

        @Override
        public String getKey(CssValue value) {
            return CursorPropertyAdapter.createKey(value);
        }

        @Override
        public String getSlot(CssValue value) {
            return "cursors";
        }

        @Override
        public JsonValue getValue(CssValue value) {
            CssCursor cursor = (CssCursor)value;
            JsonValue result = cursor.isCustomCursor() ? JsonValue.NULL : JsonValue.valueOf(cursor.value);
            return result;
        }

        private static String createKey(CssValue value) {
            int index;
            Object result = Integer.toHexString(value.hashCode());
            CssCursor cursor = (CssCursor)value;
            if (cursor.isCustomCursor() && (index = cursor.value.lastIndexOf(46)) >= 0) {
                result = (String)result + cursor.value.substring(index);
            }
            return result;
        }
    }

    static class DimensionPropertyAdapter
    implements ThemePropertyAdapter {
        DimensionPropertyAdapter() {
        }

        @Override
        public String getKey(CssValue value) {
            return Integer.toHexString(value.hashCode());
        }

        @Override
        public String getSlot(CssValue value) {
            return "dimensions";
        }

        @Override
        public JsonValue getValue(CssValue value) {
            if (CssDimension.AUTO.equals(value)) {
                return JsonValue.valueOf("auto");
            }
            return JsonValue.valueOf(((CssDimension)value).value);
        }
    }

    static class DirectPropertyAdapter
    implements ThemePropertyAdapter {
        DirectPropertyAdapter() {
        }

        @Override
        public String getKey(CssValue value) {
            return value.toDefaultString();
        }

        @Override
        public String getSlot(CssValue value) {
            return null;
        }

        @Override
        public JsonValue getValue(CssValue value) {
            return null;
        }
    }

    static class FontPropertyAdapter
    implements ThemePropertyAdapter {
        FontPropertyAdapter() {
        }

        @Override
        public String getKey(CssValue value) {
            return Integer.toHexString(value.hashCode());
        }

        @Override
        public String getSlot(CssValue value) {
            return "fonts";
        }

        @Override
        public JsonValue getValue(CssValue value) {
            CssFont font = (CssFont)value;
            JsonObject result = new JsonObject();
            result.add("family", JsonUtil.createJsonArray(font.family));
            result.add("size", font.size);
            result.add("bold", font.bold);
            result.add("italic", font.italic);
            return result;
        }
    }

    static class ImagePropertyAdapter
    implements ThemePropertyAdapter {
        ImagePropertyAdapter() {
        }

        @Override
        public String getKey(CssValue value) {
            return ImagePropertyAdapter.createKey(value);
        }

        @Override
        public String getSlot(CssValue value) {
            CssImage image = (CssImage)value;
            String result = image.isGradient() ? "gradients" : "images";
            return result;
        }

        @Override
        public JsonValue getValue(CssValue value) {
            CssImage image = (CssImage)value;
            JsonValue result = null;
            if (image.isGradient()) {
                JsonObject gradientObject = null;
                gradientObject = new JsonObject();
                JsonArray percents = JsonUtil.createJsonArray(image.gradientPercents);
                gradientObject.add("percents", percents);
                JsonArray colors = JsonUtil.createJsonArray(image.gradientColors);
                gradientObject.add("colors", colors);
                gradientObject.add("vertical", image.vertical);
                result = gradientObject;
            } else if (!image.none) {
                Size imageSize = image.getSize();
                result = new JsonArray().add(imageSize.width).add(imageSize.height);
            }
            return result;
        }

        private static String createKey(CssValue value) {
            int index;
            Object result = Integer.toHexString(value.hashCode());
            CssImage image = (CssImage)value;
            if (image.path != null && (index = image.path.lastIndexOf(46)) >= 0) {
                result = (String)result + image.path.substring(index);
            }
            return result;
        }
    }

    static class ShadowPropertyAdapter
    implements ThemePropertyAdapter {
        ShadowPropertyAdapter() {
        }

        @Override
        public String getKey(CssValue value) {
            return Integer.toHexString(value.hashCode());
        }

        @Override
        public String getSlot(CssValue value) {
            return "shadows";
        }

        @Override
        public JsonValue getValue(CssValue value) {
            JsonValue result;
            CssShadow shadow = (CssShadow)value;
            if (shadow.equals(CssShadow.NONE)) {
                result = JsonValue.NULL;
            } else {
                JsonArray array = new JsonArray();
                array.add(shadow.inset);
                array.add(shadow.offsetX);
                array.add(shadow.offsetY);
                array.add(shadow.blur);
                array.add(shadow.spread);
                array.add(shadow.color);
                array.add(shadow.opacity);
                result = array;
            }
            return result;
        }
    }

    static interface ThemePropertyAdapter {
        public String getSlot(CssValue var1);

        public String getKey(CssValue var1);

        public JsonValue getValue(CssValue var1);
    }
}

