/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import org.eclipse.scout.commons.ConfigurationUtility;
import org.eclipse.scout.commons.HTMLUtility;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.commons.TypeCastUtility;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBigDecimalColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDateColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDoubleColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IIntegerColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ILongColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ISmartColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.ITimeColumn;
import org.eclipse.scout.rt.shared.services.common.exceptionhandler.IExceptionHandlerService;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;
import org.eclipse.scout.service.SERVICES;

public final class TableUtility {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(TableUtility.class);

    private TableUtility() {
    }

    public static void resolveLookupCall(Map<LookupCall, LookupRow[]> lookupCache, ITableRow row, ISmartColumn<?> col, boolean multilineText) {
        block6: {
            try {
                LookupCall call = col.prepareLookupCall(row);
                if (call != null) {
                    LookupRow[] result = null;
                    boolean verifiedQuality = TableUtility.verifyLookupCallBeanQuality(call);
                    if (verifiedQuality) {
                        result = lookupCache.get(call);
                    }
                    if (result == null) {
                        result = call.getDataByKey();
                        if (verifiedQuality) {
                            lookupCache.put(call, result);
                        }
                    }
                    TableUtility.applyLookupResult(row, col, result, multilineText);
                }
            }
            catch (ProcessingException e) {
                if (e.isInterruption()) break block6;
                ((IExceptionHandlerService)SERVICES.getService(IExceptionHandlerService.class)).handleException(e);
            }
        }
    }

    public static boolean verifyLookupCallBeanQuality(LookupCall call) {
        Class<?> clazz = call.getClass();
        if (LocalLookupCall.class == clazz) {
            return true;
        }
        if (LookupCall.class == clazz) {
            return true;
        }
        if (LocalLookupCall.class.isAssignableFrom(clazz)) {
            Class<?> tmp = clazz;
            while (tmp != LocalLookupCall.class) {
                if (ConfigurationUtility.isMethodOverwrite(LocalLookupCall.class, (String)"equals", (Class[])new Class[]{Object.class}, tmp)) {
                    return true;
                }
                Field[] fields = tmp.getDeclaredFields();
                if (fields != null && fields.length > 0) {
                    int i = 0;
                    while (i < fields.length) {
                        if ((fields[i].getModifiers() & 0x18) == 0) {
                            LOG.warn(clazz + " subclasses LocalLookupCall with additional member " + fields[i].getName() + " and should therefore override the 'equals' and 'hashCode' methods");
                            return false;
                        }
                        ++i;
                    }
                }
                tmp = tmp.getSuperclass();
            }
            return true;
        }
        if (LookupCall.class.isAssignableFrom(clazz)) {
            Class<?> tmp = clazz;
            while (tmp != LookupCall.class) {
                if (ConfigurationUtility.isMethodOverwrite(LookupCall.class, (String)"equals", (Class[])new Class[]{Object.class}, tmp)) {
                    return true;
                }
                Field[] fields = tmp.getDeclaredFields();
                if (fields != null && fields.length > 0) {
                    int i = 0;
                    while (i < fields.length) {
                        if ((fields[i].getModifiers() & 0x18) == 0) {
                            LOG.warn(clazz + " subclasses LookupCall with additional member " + fields[i].getName() + " and should therefore override the 'equals' and 'hashCode' methods");
                            return false;
                        }
                        ++i;
                    }
                }
                tmp = tmp.getSuperclass();
            }
            return true;
        }
        return false;
    }

    public static void applyLookupResult(ITableRow row, IColumn<?> col, LookupRow[] result, boolean multilineText) {
        try {
            row.setRowChanging(true);
            Cell cell = (Cell)row.getCell(col.getColumnIndex());
            if (result.length == 1) {
                cell.setText(result[0].getText());
            } else if (result.length > 1) {
                StringBuffer buf = new StringBuffer();
                int i = 0;
                while (i < result.length) {
                    if (i > 0) {
                        if (multilineText) {
                            buf.append("\n");
                        } else {
                            buf.append(", ");
                        }
                    }
                    buf.append(result[i].getText());
                    ++i;
                }
                cell.setText(buf.toString());
            } else {
                cell.setText("");
            }
        }
        finally {
            row.setRowPropertiesChanged(false);
            row.setRowChanging(false);
        }
    }

    public static Object[][] exportRowsAsCSV(ITableRow[] rows, IColumn<?>[] columns, boolean includeLineForColumnNames, boolean includeLineForColumnTypes, boolean includeLineForColumnFormats) {
        int nr = rows.length;
        Object[][] a = new Object[nr + (includeLineForColumnNames ? 1 : 0) + (includeLineForColumnTypes ? 1 : 0) + (includeLineForColumnFormats ? 1 : 0)][columns.length];
        int c = 0;
        while (c < columns.length) {
            String format;
            boolean byValue;
            Class type;
            IColumn<?> col = columns[c];
            if (col instanceof IDateColumn) {
                if (((IDateColumn)col).isHasTime()) {
                    type = Timestamp.class;
                    byValue = true;
                    format = ((IDateColumn)col).getFormat();
                } else {
                    type = Date.class;
                    byValue = true;
                    format = ((IDateColumn)col).getFormat();
                }
            } else if (col instanceof IDoubleColumn) {
                type = Double.class;
                byValue = true;
                format = ((IDoubleColumn)col).getFormat();
            } else if (col instanceof IIntegerColumn) {
                type = Integer.class;
                byValue = true;
                format = ((IIntegerColumn)col).getFormat();
            } else if (col instanceof ILongColumn) {
                type = Long.class;
                byValue = true;
                format = ((ILongColumn)col).getFormat();
            } else if (col instanceof IBigDecimalColumn) {
                type = Long.class;
                byValue = true;
                format = ((IBigDecimalColumn)col).getFormat();
            } else if (col instanceof ISmartColumn) {
                type = String.class;
                byValue = false;
                format = null;
            } else if (col instanceof ITimeColumn) {
                type = Date.class;
                byValue = true;
                format = ((ITimeColumn)col).getFormat();
            } else if (col instanceof IBooleanColumn) {
                type = Boolean.class;
                byValue = false;
                format = null;
            } else {
                type = String.class;
                byValue = false;
                format = null;
            }
            int csvRowIndex = 0;
            if (includeLineForColumnNames) {
                a[csvRowIndex][c] = columns[c].getHeaderCell().getText();
                ++csvRowIndex;
            }
            if (includeLineForColumnTypes) {
                a[csvRowIndex][c] = type;
                ++csvRowIndex;
            }
            if (includeLineForColumnFormats) {
                a[csvRowIndex][c] = format;
                ++csvRowIndex;
            }
            int r = 0;
            while (r < nr) {
                if (byValue) {
                    a[csvRowIndex][c] = type == Timestamp.class ? TypeCastUtility.castValue(columns[c].getValue(rows[r]), Timestamp.class) : columns[c].getValue(rows[r]);
                } else {
                    Boolean b;
                    String text = columns[c].getDisplayText(rows[r]);
                    if (type == Boolean.class && (b = (Boolean)TypeCastUtility.castValue(columns[c].getValue(rows[r]), Boolean.class)) != null && b.booleanValue() && !StringUtility.hasText((String)text)) {
                        text = "X";
                    }
                    if (type == String.class && text != null && text.startsWith("<html")) {
                        text = HTMLUtility.getPlainText((String)text);
                    }
                    a[csvRowIndex][c] = text;
                }
                ++csvRowIndex;
                ++r;
            }
            ++c;
        }
        return a;
    }
}

