/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.numberfield;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.scout.commons.CompareUtility;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.exception.VetoException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.INumberField;
import org.eclipse.scout.rt.client.ui.form.fields.numberfield.INumberFieldUIFacade;
import org.eclipse.scout.rt.shared.ScoutTexts;

public abstract class AbstractNumberField<T extends Number>
extends AbstractValueField<T>
implements INumberField<T> {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractNumberField.class);
    private INumberFieldUIFacade m_uiFacade;
    private String m_format;
    private boolean m_groupingUsed;
    private T m_minValue;
    private T m_maxValue;

    @ConfigProperty(value="STRING")
    @Order(value=230.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=240.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredGroupingUsed() {
        return true;
    }

    @Override
    @ConfigPropertyValue(value="1")
    protected int getConfiguredHorizontalAlignment() {
        return 1;
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.setFormat(this.getConfiguredFormat());
        this.setGroupingUsed(this.getConfiguredGroupingUsed());
    }

    @Override
    public void setFormat(String s) {
        this.m_format = s;
        if (this.isInitialized() && this.isAutoDisplayText()) {
            this.setDisplayText(this.execFormatValue((Number)this.getValue()));
        }
    }

    @Override
    public String getFormat() {
        return this.m_format;
    }

    @Override
    public void setGroupingUsed(boolean b) {
        this.m_groupingUsed = b;
        if (this.isInitialized() && this.isAutoDisplayText()) {
            this.setDisplayText(this.execFormatValue((Number)this.getValue()));
        }
    }

    @Override
    public boolean isGroupingUsed() {
        return this.m_groupingUsed;
    }

    @Override
    public void setMinValue(T n) {
        try {
            this.setFieldChanging(true);
            T max = this.getMaxValue();
            if (n != null && max != null && this.compareInternal(n, max) > 0) {
                this.m_maxValue = n;
            }
            this.m_minValue = n;
            if (this.isInitialized()) {
                this.setValue((Number)this.getValue());
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public T getMinValue() {
        return this.m_minValue;
    }

    @Override
    public void setMaxValue(T n) {
        try {
            this.setFieldChanging(true);
            T min = this.getMinValue();
            if (n != null && min != null && this.compareInternal(n, min) < 0) {
                this.m_minValue = n;
            }
            this.m_maxValue = n;
            if (this.isInitialized()) {
                this.setValue((Number)this.getValue());
            }
        }
        finally {
            this.setFieldChanging(false);
        }
    }

    @Override
    public T getMaxValue() {
        return this.m_maxValue;
    }

    private int compareInternal(T a, T b) {
        return CompareUtility.compareTo((Comparable)((Comparable)a), (Comparable)((Comparable)b));
    }

    @Override
    protected T validateValueInternal(T rawValue) throws ProcessingException {
        T validValue = null;
        if ((rawValue = (Number)super.validateValueInternal(rawValue)) == null) {
            validValue = null;
        } else {
            if (this.getMaxValue() != null && this.compareInternal(rawValue, this.getMaxValue()) > 0) {
                throw new VetoException(ScoutTexts.get((String)"NumberTooLargeMessageXY", (String[])new String[]{"" + this.getMinValue(), "" + this.getMaxValue()}));
            }
            if (this.getMinValue() != null && this.compareInternal(rawValue, this.getMinValue()) < 0) {
                throw new VetoException(ScoutTexts.get((String)"NumberTooSmallMessageXY", (String[])new String[]{"" + this.getMinValue(), "" + this.getMaxValue()}));
            }
            validValue = rawValue;
        }
        return validValue;
    }

    @Override
    protected String formatValueInternal(T validValue) {
        if (validValue == null) {
            return "";
        }
        String displayValue = this.createNumberFormat().format(validValue);
        return displayValue;
    }

    protected NumberFormat createNumberFormat() {
        NumberFormat fmt = null;
        if (this.getFormat() != null) {
            DecimalFormat x = (DecimalFormat)DecimalFormat.getNumberInstance();
            x.applyPattern(this.getFormat());
            x.setMinimumFractionDigits(0);
            x.setMaximumFractionDigits(0);
            fmt = x;
        } else {
            fmt = NumberFormat.getNumberInstance();
            fmt.setMinimumFractionDigits(0);
            fmt.setMaximumFractionDigits(0);
            fmt.setGroupingUsed(this.isGroupingUsed());
        }
        return fmt;
    }

    @Override
    public INumberFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    private class P_UIFacade
    implements INumberFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public boolean setTextFromUI(String newText) {
            if (newText != null && newText.length() == 0) {
                newText = null;
            }
            return AbstractNumberField.this.parseValue(newText);
        }
    }
}

