/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.stringfield;

import java.net.URL;
import org.eclipse.scout.commons.IOUtility;
import org.eclipse.scout.commons.annotations.ConfigOperation;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.dnd.TransferObject;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.logger.IScoutLogger;
import org.eclipse.scout.commons.logger.ScoutLogManager;
import org.eclipse.scout.rt.client.ui.desktop.outline.pages.ISearchForm;
import org.eclipse.scout.rt.client.ui.form.fields.AbstractValueField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringField;
import org.eclipse.scout.rt.client.ui.form.fields.stringfield.IStringFieldUIFacade;
import org.eclipse.scout.rt.shared.data.form.ValidationRule;

public abstract class AbstractStringField
extends AbstractValueField<String>
implements IStringField {
    private static final IScoutLogger LOG = ScoutLogManager.getLogger(AbstractStringField.class);
    private IStringFieldUIFacade m_uiFacade;
    private Boolean m_monitorSpelling = null;

    @ConfigProperty(value="BOOLEAN")
    @Order(value=260.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredDecorationLink() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=240.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=250.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredInputMasked() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=280.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredFormatLower() {
        return false;
    }

    @ConfigProperty(value="INTEGER")
    @Order(value=290.0)
    @ConfigPropertyValue(value="4000")
    @ValidationRule(value="maxLength")
    protected int getConfiguredMaxLength() {
        return 4000;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=230.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredMultilineText() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=300.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredFormatUpper() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=310.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredValidateOnAnyKey() {
        return false;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=320.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredWrapText() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @Order(value=330.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredValueFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=340.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredSelectAllOnFocus() {
        return true;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=400.0)
    @ConfigPropertyValue(value="0")
    protected int getConfiguredDropType() {
        return 0;
    }

    @ConfigProperty(value="DRAG_AND_DROP_TYPE")
    @Order(value=410.0)
    @ConfigPropertyValue(value="0")
    protected int getConfiguredDragType() {
        return 0;
    }

    @ConfigOperation
    @Order(value=500.0)
    protected TransferObject execDragRequest() {
        return null;
    }

    @ConfigOperation
    @Order(value=510.0)
    protected void execDropRequest(TransferObject transferObject) {
    }

    @ConfigOperation
    @Order(value=240.0)
    protected void execLinkAction(URL url) throws ProcessingException {
    }

    @Override
    protected void initConfig() {
        this.m_uiFacade = new P_UIFacade();
        super.initConfig();
        this.setMaxLength(this.getConfiguredMaxLength());
        this.setInputMasked(this.getConfiguredInputMasked());
        if (this.getConfiguredFormatLower()) {
            this.setFormatLower();
        } else if (this.getConfiguredFormatUpper()) {
            this.setFormatUpper();
        } else {
            this.setFormat(this.getConfiguredFormat());
        }
        this.setDecorationLink(this.getConfiguredDecorationLink());
        this.setWrapText(this.getConfiguredWrapText());
        this.setMultilineText(this.getConfiguredMultilineText());
        this.setSelectAllOnFocus(this.getConfiguredSelectAllOnFocus() && !this.getConfiguredMultilineText());
        this.setValidateOnAnyKey(this.getConfiguredValidateOnAnyKey());
        int configuredDragType = this.getConfiguredDragType();
        if (4 == configuredDragType) {
            LOG.warn("Drag and drop TextTransfer is default behaviour (Configuration will not be considered).");
            configuredDragType = 0;
        }
        this.setDragType(configuredDragType);
        int configuredDropType = this.getConfiguredDropType();
        if (4 == configuredDropType) {
            LOG.warn("Drag and drop TextTransfer is default behaviour (Configuration will not be considered).");
            configuredDropType = 0;
        }
        this.setDropType(configuredDropType);
    }

    @Override
    public void setMaxLength(int len) {
        if (len > 0) {
            this.propertySupport.setPropertyInt("maxLength", len);
        }
        if (this.isInitialized()) {
            this.setValue((String)this.getValue());
        }
    }

    @Override
    public int getMaxLength() {
        int len = this.propertySupport.getPropertyInt("maxLength");
        if (len <= 0) {
            len = 200;
        }
        return len;
    }

    @Override
    protected String validateValueInternal(String rawValue) throws ProcessingException {
        String validValue = null;
        validValue = rawValue = super.validateValueInternal(rawValue);
        if (validValue != null && validValue.length() == 0) {
            validValue = null;
        }
        if (validValue != null) {
            if (validValue.length() > this.getMaxLength()) {
                validValue = validValue.substring(0, this.getMaxLength());
            }
            if (this.isFormatUpper()) {
                validValue = validValue.toUpperCase();
            } else if (this.isFormatLower()) {
                validValue = validValue.toLowerCase();
            }
        }
        if (validValue != null && !this.isMultilineText()) {
            validValue = validValue.replaceAll("[\\n\\r]", " ");
        }
        return validValue;
    }

    @Override
    public void setInputMasked(boolean b) {
        this.propertySupport.setPropertyBool("inputMasked", b);
    }

    @Override
    public boolean isInputMasked() {
        return this.propertySupport.getPropertyBool("inputMasked");
    }

    @Override
    public void setFormatUpper() {
        this.setFormat("A");
    }

    @Override
    public boolean isFormatUpper() {
        return "A".equals(this.getFormat());
    }

    @Override
    public void setFormatLower() {
        this.setFormat("a");
    }

    @Override
    public boolean isFormatLower() {
        return "a".equals(this.getFormat());
    }

    @Override
    public void setDecorationLink(boolean b) {
        this.propertySupport.setPropertyBool("decorationLink", b);
    }

    @Override
    public boolean isDecorationLink() {
        return this.propertySupport.getPropertyBool("decorationLink");
    }

    @Override
    public void setWrapText(boolean b) {
        this.propertySupport.setPropertyBool("wrapText", b);
    }

    @Override
    public boolean isWrapText() {
        return this.propertySupport.getPropertyBool("wrapText");
    }

    @Override
    public void setMultilineText(boolean b) {
        this.propertySupport.setPropertyBool("multilineText", b);
    }

    @Override
    public boolean isMultilineText() {
        return this.propertySupport.getPropertyBool("multilineText");
    }

    @Override
    public void insertText(String s) {
        this.propertySupport.setPropertyAlwaysFire("insertText", (Object)s);
    }

    @Override
    public boolean isSelectAllOnFocus() {
        return this.propertySupport.getPropertyBool("selectAllOnFocus");
    }

    @Override
    public void setSelectAllOnFocus(boolean b) {
        this.propertySupport.setPropertyBool("selectAllOnFocus", b);
    }

    @Override
    public void setValidateOnAnyKey(boolean b) {
        this.propertySupport.setPropertyBool("validateOnAnyKey", b);
    }

    @Override
    public boolean isValidateOnAnyKey() {
        return this.propertySupport.getPropertyBool("validateOnAnyKey");
    }

    @Override
    public void select(int startIndex, int endIndex) {
        try {
            this.propertySupport.setPropertiesChanging(true);
            this.propertySupport.setPropertyInt("selectionStart", startIndex);
            this.propertySupport.setPropertyInt("selectionEnd", endIndex);
        }
        finally {
            this.propertySupport.setPropertiesChanging(false);
        }
    }

    @Override
    public int getSelectionStart() {
        return this.propertySupport.getPropertyInt("selectionStart");
    }

    @Override
    public int getSelectionEnd() {
        return this.propertySupport.getPropertyInt("selectionEnd");
    }

    @Override
    public IStringFieldUIFacade getUIFacade() {
        return this.m_uiFacade;
    }

    @Override
    public void setFormat(String s) {
        this.propertySupport.setPropertyString("format", s);
        if (this.isInitialized() && this.isAutoDisplayText()) {
            String t = this.execFormatValue((String)this.getValue());
            this.setDisplayText(t);
        }
    }

    @Override
    public String getFormat() {
        return this.propertySupport.getPropertyString("format");
    }

    @Override
    protected String parseValueInternal(String text) throws ProcessingException {
        String fmt;
        if (text != null && text.length() == 0) {
            text = null;
        }
        if ((fmt = this.getFormat()) != null && text != null) {
            if ("a".equals(fmt)) {
                text = text.toLowerCase();
            } else if ("A".equals(fmt)) {
                text = text.toUpperCase();
            }
        }
        return text;
    }

    @Override
    public void setDragType(int dragType) {
        this.propertySupport.setPropertyInt("dragType", dragType);
    }

    @Override
    public int getDragType() {
        return this.propertySupport.getPropertyInt("dragType");
    }

    @Override
    public void setDropType(int dropType) {
        this.propertySupport.setPropertyInt("dropType", dropType);
    }

    @Override
    public int getDropType() {
        return this.propertySupport.getPropertyInt("dropType");
    }

    @Override
    public boolean isSpellCheckEnabled() {
        return !this.isDecorationLink() && !this.isFormatUpper() && !this.isFormatLower() && this.isEnabled() && this.isEnabledGranted() && !(this.getForm() instanceof ISearchForm);
    }

    @Override
    public Boolean isSpellCheckAsYouTypeEnabled() {
        return this.m_monitorSpelling;
    }

    @Override
    public void setSpellCheckAsYouTypeEnabled(boolean monitorSpelling) {
        this.m_monitorSpelling = new Boolean(monitorSpelling);
    }

    private class P_UIFacade
    implements IStringFieldUIFacade {
        private P_UIFacade() {
        }

        @Override
        public boolean setTextFromUI(String newText) {
            if (newText != null && newText.length() == 0) {
                newText = null;
            }
            return AbstractStringField.this.parseValue(newText);
        }

        @Override
        public void fireLinkActionFromUI(String text) {
            URL url = IOUtility.urlTextToUrl((String)text);
            try {
                AbstractStringField.this.execLinkAction(url);
            }
            catch (ProcessingException e) {
                LOG.warn("execLinkAction failed", (Throwable)e);
            }
        }

        @Override
        public void fireKeyTypedFromUI(String newText) {
            String oldText = AbstractStringField.this.getDisplayText();
            if (oldText != null && oldText.length() == 0) {
                oldText = null;
            }
            if (newText != null && newText.length() == 0) {
                newText = null;
            }
            if (oldText == newText || oldText != null && oldText.equals(newText)) {
                return;
            }
            AbstractStringField.this.parseValue(newText);
        }

        @Override
        public void setSelectionFromUI(int startOfSelection, int endOfSelection) {
            AbstractStringField.this.select(startOfSelection, endOfSelection);
        }

        @Override
        public TransferObject fireDragRequestFromUI() {
            return AbstractStringField.this.execDragRequest();
        }

        @Override
        public void fireDropActionFromUi(TransferObject scoutTransferable) {
            AbstractStringField.this.execDropRequest(scoutTransferable);
        }
    }
}

