/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device;

import java.util.Collection;
import java.util.List;
import org.eclipse.tml.framework.device.factory.DeviceTypeRegistry;
import org.eclipse.tml.framework.device.factory.InstanceRegistry;
import org.eclipse.tml.framework.device.manager.InstanceManager;
import org.eclipse.tml.framework.device.model.IDeviceType;
import org.eclipse.tml.framework.device.model.IInstance;
import org.eclipse.tml.framework.device.model.IService;

public abstract class DeviceUtils {
    public static String[] getAllDeviceNames() {
        DeviceTypeRegistry deviceTypeRegistry = DeviceTypeRegistry.getInstance();
        Collection<IDeviceType> deviceTypeList = deviceTypeRegistry.getDeviceTypes();
        String[] deviceNames = new String[deviceTypeList.size()];
        int i = 0;
        for (IDeviceType device : deviceTypeList) {
            deviceNames[i++] = device.getBundleName();
        }
        return deviceNames;
    }

    public static String[] getAllInstanceNames() {
        InstanceRegistry instanceRegistry = InstanceRegistry.getInstance();
        List<IInstance> instanceList = instanceRegistry.getInstances();
        String[] instanceNames = new String[instanceList.size()];
        int i = 0;
        for (IInstance instance : instanceList) {
            instanceNames[i++] = instance.getName();
        }
        return instanceNames;
    }

    public static IInstance getInstance(String instanceName) {
        IInstance deviceInstanceToReturn = null;
        List<IInstance> deviceInstances = InstanceManager.getInstance().getInstancesByname(instanceName);
        if (!deviceInstances.isEmpty()) {
            deviceInstanceToReturn = deviceInstances.get(0);
        }
        return deviceInstanceToReturn;
    }

    public static IService getServiceById(IDeviceType deviceType, String serviceId) {
        IService serviceToReturn = null;
        if (deviceType != null && serviceId != null) {
            for (IService aService : deviceType.getServices()) {
                if (!serviceId.equals(aService.getId())) continue;
                serviceToReturn = aService;
                break;
            }
        }
        return serviceToReturn;
    }

    public static IDeviceType getDeviceType(IInstance instance) {
        return DeviceUtils.getDeviceTypeById(instance.getDeviceTypeId());
    }

    public static IDeviceType getDeviceTypeById(String deviceTypeId) {
        return DeviceTypeRegistry.getInstance().getDeviceTypeById(deviceTypeId);
    }
}

