/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.common.utilities.logger;

import org.eclipse.tml.common.utilities.logger.ILogger;
import org.eclipse.tml.common.utilities.logger.SimpleLogger;

public abstract class LoggerFactory {
    private static final String DEFAULT_LOG_FILE_NAME = "default.log";

    public static final ILogger getLogger(int log) {
        SimpleLogger logger = null;
        switch (log) {
            case -1: {
                logger = SimpleLogger.getInstance();
            }
        }
        return logger;
    }

    public static final ILogger getLogger(int log, Class _class) {
        LoggerFactory.getLogger(log).configureLogger(_class);
        return LoggerFactory.getLogger(log);
    }

    public static final ILogger getLogger(int log, Class _class, int logOutput, String logMinLevel, String logFileName) {
        if (logFileName == null) {
            logFileName = DEFAULT_LOG_FILE_NAME;
        }
        switch (logOutput) {
            case 1: {
                LoggerFactory.getLogger(log).setLogToConsole();
                break;
            }
            case 2: {
                LoggerFactory.getLogger(log).setLogToFile(logFileName);
                break;
            }
            case 3: {
                LoggerFactory.getLogger(log).setLogToHTMLFile(logFileName);
                break;
            }
            default: {
                LoggerFactory.getLogger(log).setLogToConsole();
            }
        }
        LoggerFactory.getLogger(log).configureLogger(_class);
        if (logMinLevel != null) {
            LoggerFactory.getLogger(log).setLevel(logMinLevel);
        }
        return LoggerFactory.getLogger(log);
    }
}

