/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.ui.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sequoyah.device.framework.DeviceUtils;
import org.eclipse.sequoyah.device.framework.events.IInstanceListener;
import org.eclipse.sequoyah.device.framework.events.InstanceAdapter;
import org.eclipse.sequoyah.device.framework.events.InstanceEvent;
import org.eclipse.sequoyah.device.framework.events.InstanceEventManager;
import org.eclipse.sequoyah.device.framework.factory.DeviceTypeRegistry;
import org.eclipse.sequoyah.device.framework.manager.InstanceManager;
import org.eclipse.sequoyah.device.framework.model.AbstractMobileInstance;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.model.IInstance;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.model.handler.ServiceHandlerAction;
import org.eclipse.sequoyah.device.framework.status.IStatus;
import org.eclipse.sequoyah.device.framework.status.StatusRegistry;
import org.eclipse.sequoyah.device.framework.ui.view.InstanceMgtView;
import org.eclipse.sequoyah.device.framework.ui.view.InstanceServicesComposite;
import org.eclipse.sequoyah.device.framework.ui.view.Messages;
import org.eclipse.sequoyah.device.framework.ui.view.model.InstanceMgtViewComparator;
import org.eclipse.sequoyah.device.framework.ui.view.model.InstanceSelectionChangeListener;
import org.eclipse.sequoyah.device.framework.ui.view.model.ViewerAbstractNode;
import org.eclipse.sequoyah.device.framework.ui.view.model.ViewerDeviceNode;
import org.eclipse.sequoyah.device.framework.ui.view.model.ViewerInstanceNode;
import org.eclipse.sequoyah.device.framework.ui.view.provider.InstanceMgtViewContentProvider;
import org.eclipse.sequoyah.device.framework.ui.view.provider.InstanceMgtViewLabelProvider;
import org.eclipse.sequoyah.device.framework.ui.wizard.DeviceWizardExtensionManager;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.plugin.AbstractUIPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstanceStatusComposite
extends Composite {
    private static final String MENU_DELETE = Messages.InstanceStatusComposite_3;
    private static final String MENU_PROPERTIES = Messages.InstanceStatusComposite_4;
    private static final String MENU_NEW = Messages.InstanceStatusComposite_5;
    private static final String TOOLBAR_NEW_TOOLTIP = Messages.InstanceStatusComposite_6;
    private static final String TOOLBAR_DIALOG_MESSAGE = Messages.InstanceStatusComposite_7;
    private static final String ERROR_DIALOG_TITLE = Messages.InstanceStatusComposite_8;
    private static final String ERROR_NO_WIZARD_MESSAGE = Messages.InstanceStatusComposite_9;
    private static final int DEFAULT_MENU_IMAGE_SIZE = 16;
    private TreeViewer viewer;
    private IViewSite viewSite;
    protected Map<String, Action> wizardActions = new TreeMap<String, Action>();
    private IInstanceListener listener = new InstanceAdapter(){

        public void instanceLoaded(InstanceEvent instanceEvent) {
            InstanceStatusComposite.this.instanceLoaded(instanceEvent.getInstance());
        }

        public void instanceUnloaded(InstanceEvent instanceEvent) {
            InstanceStatusComposite.this.instanceUnloaded(instanceEvent.getInstance());
        }

        public void instanceUpdated(InstanceEvent instanceEvent) {
            InstanceStatusComposite.this.instanceTransitioned(instanceEvent.getInstance());
        }

        public void instanceTransitioned(InstanceEvent instanceEvent) {
            InstanceStatusComposite.this.instanceTransitioned(instanceEvent.getInstance());
        }
    };
    private boolean useDropDown;

    public InstanceStatusComposite(Composite composite, IViewSite iViewSite, boolean bl) {
        super(composite, 0);
        this.viewSite = iViewSite;
        this.useDropDown = bl;
        this.createContents();
        InstanceEventManager instanceEventManager = InstanceEventManager.getInstance();
        instanceEventManager.addInstanceListener(this.listener);
    }

    protected void addInstanceSelectionChangeListener(InstanceSelectionChangeListener instanceSelectionChangeListener) {
        InstanceMgtView.addInstanceSelectionChangeListener(instanceSelectionChangeListener);
    }

    protected void removeInstanceSelectionChangeListener(InstanceSelectionChangeListener instanceSelectionChangeListener) {
        InstanceMgtView.removeInstanceSelectionChangeListener(instanceSelectionChangeListener);
    }

    private void notifyInstanceSelectionChangeListeners(IInstance iInstance) {
        InstanceMgtView.notifyInstanceSelectionChangeListeners(iInstance);
    }

    protected IInstance getSelectedInstance() {
        IInstance iInstance = null;
        Object object = this.getLastSelection();
        if (object instanceof IInstance) {
            iInstance = (IInstance)object;
        }
        return iInstance;
    }

    protected IDeviceType getSelectedDevice() {
        IDeviceType iDeviceType = null;
        Object object = this.getLastSelection();
        if (object instanceof IDeviceType) {
            iDeviceType = (IDeviceType)object;
        }
        return iDeviceType;
    }

    private void createContents() {
        this.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(this, 66304){

            protected void createTreeItem(Widget widget, Object object, int n) {
                ViewerInstanceNode viewerInstanceNode;
                super.createTreeItem(widget, object, n);
                if (InstanceStatusComposite.this.useDropDown && object instanceof ViewerInstanceNode && (viewerInstanceNode = (ViewerInstanceNode)object).getInstance() != null) {
                    InstanceStatusComposite.this.configureButtons(viewerInstanceNode);
                }
            }
        };
        Tree tree = this.viewer.getTree();
        TableLayout tableLayout = new TableLayout();
        tree.setLayout((Layout)tableLayout);
        tree.setHeaderVisible(true);
        this.createColumn(Messages.InstanceStatusComposite_10, 10);
        this.createColumn(Messages.InstanceStatusComposite_11, 9);
        InstanceMgtViewLabelProvider instanceMgtViewLabelProvider = new InstanceMgtViewLabelProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)instanceMgtViewLabelProvider);
        this.viewer.setContentProvider((IContentProvider)new InstanceMgtViewContentProvider());
        this.viewer.getTree().setLinesVisible(true);
        this.viewer.setComparator((ViewerComparator)new InstanceMgtViewComparator(instanceMgtViewLabelProvider));
        this.viewer.setInput((Object)this.viewSite);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                InstanceStatusComposite.this.notifyInstanceSelectionChangeListeners(InstanceStatusComposite.this.getSelectedInstance());
            }
        });
        this.createActions();
        this.fillMenuContext();
        this.fillViewMenu();
        this.fillViewToolbar();
        this.refreshViewer(null);
        this.viewer.expandAll();
    }

    private void createActions() {
        for (final IDeviceType iDeviceType : DeviceTypeRegistry.getInstance().getDeviceTypes()) {
            if (iDeviceType.isAbstract() || !iDeviceType.supportsUserInstances()) continue;
            this.wizardActions.put(iDeviceType.getLabel(), new Action(iDeviceType.getLabel()){

                public void run() {
                    IWizard iWizard = DeviceWizardExtensionManager.getInstance().getDeviceWizard(iDeviceType.getId());
                    if (iWizard != null) {
                        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        WizardDialog wizardDialog = new WizardDialog(iWorkbenchWindow.getShell(), iWizard);
                        wizardDialog.create();
                        wizardDialog.open();
                    } else {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                MessageDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)ERROR_DIALOG_TITLE, (String)(String.valueOf(ERROR_NO_WIZARD_MESSAGE) + iDeviceType.getLabel()));
                            }
                        });
                    }
                }

                public String toString() {
                    return this.getText();
                }
            });
        }
    }

    protected void clearContextMenu(Menu menu) {
        MenuItem[] menuItemArray = menu.getItems();
        int n = 0;
        while (n < menuItemArray.length) {
            menuItemArray[n].dispose();
            ++n;
        }
    }

    private void fillMenuContext() {
        final Menu menu = new Menu((Control)this.viewer.getTree());
        this.viewer.getTree().setMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                InstanceStatusComposite.this.clearContextMenu(menu);
                InstanceStatusComposite.this.fillMenuContext(menu, false);
            }
        });
    }

    private void fillMenuContext(Menu menu, boolean bl) {
        MenuItem menuItem = null;
        ISelection iSelection = this.viewer.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            IDeviceType iDeviceType;
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof ViewerInstanceNode) {
                ViewerInstanceNode viewerInstanceNode = (ViewerInstanceNode)object;
                if (viewerInstanceNode.containsInstance()) {
                    IInstance iInstance = this.getSelectedInstance();
                    this.fillMenuContext(menu, iInstance, bl);
                }
            } else if (object instanceof ViewerDeviceNode && (iDeviceType = this.getSelectedDevice()).supportsUserInstances()) {
                menuItem = new MenuItem(menu, 8);
                menuItem.setText(MENU_NEW);
                String string = ((ViewerDeviceNode)object).getDeviceName();
                menuItem.addListener(13, (Listener)new WizardSelectionListener(string));
            }
        }
    }

    private void fillMenuContext(Menu menu, IInstance iInstance, boolean bl) {
        MenuItem menuItem = null;
        String string = iInstance.getStatus();
        IStatus iStatus = StatusRegistry.getInstance().getStatus(string);
        IDeviceType iDeviceType = DeviceUtils.getDeviceType((IInstance)iInstance);
        String string2 = iDeviceType.getLabel();
        if (iDeviceType.supportsUserInstances()) {
            if (!bl) {
                menuItem = new MenuItem(menu, 8);
                menuItem.setText(MENU_NEW);
                menuItem.addListener(13, (Listener)new WizardSelectionListener(string2));
                menuItem = new MenuItem(menu, 2);
            }
            menuItem = new MenuItem(menu, 8);
            menuItem.setText(MENU_DELETE);
            menuItem.addListener(13, (Listener)new MenuDeleteListener(iInstance));
            menuItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
            menuItem.setEnabled(iStatus.canDeleteInstance());
            menuItem = new MenuItem(menu, 2);
        }
        menuItem = new MenuItem(menu, 8);
        menuItem.setText(MENU_PROPERTIES);
        menuItem.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("ICON_PROPERTY"));
        menuItem.addListener(13, (Listener)new MenuPropertiesListener(iInstance));
        menuItem.setEnabled(iStatus.canEditProperties());
        menuItem = new MenuItem(menu, 2);
        for (IService iService : iDeviceType.getServices()) {
            if (!iService.isVisible()) continue;
            boolean bl2 = ((AbstractMobileInstance)iInstance).getStateMachineHandler().isTransitioning();
            boolean bl3 = iService.getStatusTransitions(iInstance.getStatus()) != null;
            bl3 = bl3 && !bl2;
            menuItem = new MenuItem(menu, 8);
            ImageData imageData = iService.getImage().getImageData().scaledTo(16, 16);
            Image image = new Image((Device)this.getDisplay(), imageData);
            menuItem.setImage(image);
            menuItem.setEnabled(bl3);
            menuItem.setText(iService.getName());
            menuItem.addListener(13, (Listener)new ServiceHandlerAction(iInstance, iService.getHandler()));
            final IInstance iInstance2 = iInstance;
            menuItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    InstanceServicesComposite instanceServicesComposite = InstanceMgtView.getInstanceServicesComposite();
                    if (instanceServicesComposite != null) {
                        instanceServicesComposite.setSelectedInstance(iInstance2);
                    }
                }
            });
        }
    }

    private void fillViewMenu() {
        IMenuManager iMenuManager = this.viewSite.getActionBars().getMenuManager();
        MenuManager menuManager = new MenuManager(MENU_NEW);
        iMenuManager.add((IContributionItem)menuManager);
        for (Action action : this.wizardActions.values()) {
            menuManager.add((IAction)action);
        }
    }

    private void fillViewToolbar() {
        IToolBarManager iToolBarManager = this.viewSite.getActionBars().getToolBarManager();
        WizardDropDownAction wizardDropDownAction = new WizardDropDownAction();
        wizardDropDownAction.setToolTipText(TOOLBAR_NEW_TOOLTIP);
        if (this.wizardActions.size() <= 0) {
            wizardDropDownAction.setEnabled(false);
        }
        iToolBarManager.add((IAction)wizardDropDownAction);
    }

    private void createColumn(String string, int n) {
        Tree tree = this.viewer.getTree();
        TableLayout tableLayout = (TableLayout)tree.getLayout();
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(n));
        TreeColumn treeColumn = new TreeColumn(tree, 0);
        treeColumn.setMoveable(true);
        treeColumn.setText(string);
        treeColumn.setResizable(true);
        treeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InstanceStatusComposite.this.columnSelected(selectionEvent);
            }
        });
        treeColumn.addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent controlEvent) {
                InstanceStatusComposite.this.columnMoved(controlEvent);
            }
        });
    }

    protected void refreshViewer(IInstance iInstance) {
        Collection<String> collection = this.getExpandedDevices();
        this.viewer.refresh();
        this.expandToNodeValues(collection, iInstance);
        this.notifyInstanceSelectionChangeListeners(this.getSelectedInstance());
    }

    private void configureButtons(final ViewerInstanceNode viewerInstanceNode) {
        TreeItem[] treeItemArray = this.viewer.getTree().getItems();
        TreeItem treeItem = this.getInstanceItem(viewerInstanceNode, treeItemArray);
        if (treeItem != null && !treeItem.isDisposed()) {
            final Tree tree = this.viewer.getTree();
            final TreeEditor treeEditor = new TreeEditor(tree);
            final Button button = new Button((Composite)tree, 1028);
            button.setSize(15, 15);
            final Menu menu = new Menu((Control)this);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    InstanceStatusComposite.this.clearContextMenu(menu);
                    InstanceStatusComposite.this.fillMenuContext(menu, viewerInstanceNode.getInstance(), true);
                    Rectangle rectangle = button.getBounds();
                    Point point = new Point(0, rectangle.height);
                    point = button.toDisplay(point);
                    TreeItem treeItem = tree.getItem(new Point(rectangle.x, rectangle.y));
                    tree.setSelection(treeItem);
                    menu.setLocation(point.x, point.y);
                    menu.setVisible(true);
                }
            });
            treeEditor.horizontalAlignment = 131072;
            treeEditor.minimumHeight = 15;
            treeEditor.minimumWidth = 15;
            treeEditor.setEditor((Control)button, treeItem, 0);
            treeItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent disposeEvent) {
                    treeEditor.dispose();
                    button.dispose();
                }
            });
        }
    }

    private Collection<String> getExpandedDevices() {
        Object[] objectArray = this.viewer.getVisibleExpandedElements();
        HashSet<String> hashSet = new HashSet<String>();
        Object[] objectArray2 = objectArray;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray2[n2];
            if (object instanceof ViewerDeviceNode) {
                ViewerDeviceNode viewerDeviceNode = (ViewerDeviceNode)object;
                hashSet.add(viewerDeviceNode.getDevice().getId());
            }
            ++n2;
        }
        return hashSet;
    }

    private void expandToNodeValues(Collection<String> collection, IInstance iInstance) {
        TreeItem[] treeItemArray = this.viewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            ViewerDeviceNode viewerDeviceNode;
            TreeItem treeItem = treeItemArray[n2];
            Object object = treeItem.getData();
            if (object instanceof ViewerDeviceNode && collection.contains((viewerDeviceNode = (ViewerDeviceNode)object).getDevice().getId())) {
                treeItem.setExpanded(true);
                this.viewer.reveal((Object)treeItem);
                for (ViewerAbstractNode viewerAbstractNode : viewerDeviceNode.getChildren()) {
                    this.viewer.reveal((Object)viewerAbstractNode);
                    if (iInstance == null || !iInstance.equals(((ViewerInstanceNode)viewerAbstractNode).getInstance())) continue;
                    treeItem.setExpanded(true);
                    this.viewer.reveal((Object)treeItem);
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)viewerAbstractNode));
                }
            }
            ++n2;
        }
    }

    private Object getLastSelection() {
        IStructuredSelection iStructuredSelection;
        IInstance iInstance = null;
        ISelection iSelection = this.viewer.getSelection();
        if (iSelection instanceof IStructuredSelection && (iStructuredSelection = (IStructuredSelection)iSelection).size() == 1) {
            Object object = iStructuredSelection.getFirstElement();
            if (object instanceof ViewerInstanceNode) {
                ViewerInstanceNode viewerInstanceNode = (ViewerInstanceNode)object;
                iInstance = viewerInstanceNode.getInstance();
            } else if (object instanceof ViewerDeviceNode) {
                ViewerDeviceNode viewerDeviceNode = (ViewerDeviceNode)object;
                iInstance = viewerDeviceNode.getDevice();
            }
        }
        return iInstance;
    }

    private void columnSelected(SelectionEvent selectionEvent) {
        TreeColumn treeColumn = (TreeColumn)selectionEvent.widget;
        Tree tree = treeColumn.getParent();
        int n = tree.indexOf(treeColumn);
        InstanceMgtViewComparator instanceMgtViewComparator = (InstanceMgtViewComparator)this.viewer.getComparator();
        instanceMgtViewComparator.setColumnToSort(n);
        if (tree.getSortColumn() == treeColumn) {
            instanceMgtViewComparator.toggleAscending();
        }
        tree.setSortColumn(treeColumn);
        if (instanceMgtViewComparator.isAscending()) {
            tree.setSortDirection(128);
        } else {
            tree.setSortDirection(1024);
        }
        this.refreshViewer(this.getSelectedInstance());
    }

    private void columnMoved(ControlEvent controlEvent) {
        InstanceMgtViewLabelProvider instanceMgtViewLabelProvider;
        int n;
        TreeColumn treeColumn = (TreeColumn)controlEvent.getSource();
        Tree tree = treeColumn.getParent();
        int[] nArray = tree.getColumnOrder();
        if (nArray[0] != (n = (instanceMgtViewLabelProvider = (InstanceMgtViewLabelProvider)this.viewer.getLabelProvider()).getFirstColumnIndex())) {
            instanceMgtViewLabelProvider.setFirstColumnIndex(nArray[0]);
            this.refreshViewer(this.getSelectedInstance());
        }
    }

    protected void removeSelected() {
        if (this.viewer.getSelection().isEmpty()) {
            return;
        }
        IInstance iInstance = this.getSelectedInstance();
        if (iInstance != null) {
            InstanceManager.deleteInstance((IInstance)iInstance);
        }
    }

    private void instanceLoaded(final IInstance iInstance) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Collection collection = InstanceStatusComposite.this.getExpandedDevices();
                InstanceStatusComposite.this.viewer.refresh();
                collection.add(iInstance.getDeviceTypeId());
                InstanceStatusComposite.this.expandToNodeValues(collection, iInstance);
                InstanceStatusComposite.this.notifyInstanceSelectionChangeListeners(iInstance);
            }
        });
    }

    private void instanceUnloaded(IInstance iInstance) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                Collection collection = InstanceStatusComposite.this.getExpandedDevices();
                InstanceStatusComposite.this.viewer.refresh();
                InstanceStatusComposite.this.expandToNodeValues(collection, null);
            }
        });
    }

    private void instanceTransitioned(final IInstance iInstance) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ViewerInstanceNode viewerInstanceNode = InstanceStatusComposite.this.getInstanceNode(iInstance);
                if (viewerInstanceNode != null) {
                    Collection collection = InstanceStatusComposite.this.getExpandedDevices();
                    IInstance iInstance2 = InstanceStatusComposite.this.getSelectedInstance();
                    InstanceStatusComposite.this.viewer.update((Object)viewerInstanceNode, null);
                    InstanceStatusComposite.this.expandToNodeValues(collection, iInstance2);
                    if (iInstance.equals(iInstance2)) {
                        InstanceStatusComposite.this.notifyInstanceSelectionChangeListeners(iInstance2);
                    }
                }
            }
        });
    }

    private ViewerInstanceNode getInstanceNode(IInstance iInstance) {
        TreeItem[] treeItemArray;
        ViewerInstanceNode viewerInstanceNode = null;
        TreeItem[] treeItemArray2 = treeItemArray = this.viewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray2[n2];
            Object object = treeItem.getData();
            if (object instanceof ViewerDeviceNode) {
                Set<ViewerAbstractNode> set = ((ViewerDeviceNode)object).getChildren();
                for (ViewerAbstractNode viewerAbstractNode : set) {
                    IInstance iInstance2;
                    if (!(viewerAbstractNode instanceof ViewerInstanceNode) || (iInstance2 = ((ViewerInstanceNode)viewerAbstractNode).getInstance()) == null || !iInstance2.equals(iInstance)) continue;
                    viewerInstanceNode = (ViewerInstanceNode)viewerAbstractNode;
                    break;
                }
                if (viewerInstanceNode != null) break;
            }
            ++n2;
        }
        return viewerInstanceNode;
    }

    public void selectInstance(IInstance iInstance) {
        ViewerInstanceNode viewerInstanceNode = this.getInstanceNode(iInstance);
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)viewerInstanceNode));
    }

    protected void removeListener() {
        InstanceEventManager instanceEventManager = InstanceEventManager.getInstance();
        instanceEventManager.removeInstanceListener(this.listener);
    }

    TreeItem getInstanceItem(ViewerInstanceNode viewerInstanceNode, TreeItem[] treeItemArray) {
        TreeItem treeItem = null;
        TreeItem[] treeItemArray2 = treeItemArray;
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem2 = treeItemArray2[n2];
            Object object = treeItem2.getData();
            if (object instanceof ViewerInstanceNode) {
                ViewerInstanceNode viewerInstanceNode2 = (ViewerInstanceNode)object;
                if (viewerInstanceNode.getInstanceName().equals(viewerInstanceNode2.getInstanceName())) {
                    return treeItem2;
                }
            }
            if ((treeItem = this.getInstanceItem(viewerInstanceNode, treeItem2.getItems())) != null) break;
            ++n2;
        }
        return treeItem;
    }

    List getInstanceItems(TreeItem[] treeItemArray) {
        ArrayList<TreeItem> arrayList = new ArrayList<TreeItem>();
        TreeItem[] treeItemArray2 = treeItemArray;
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray2[n2];
            Object object = treeItem.getData();
            if (object instanceof ViewerInstanceNode) {
                arrayList.add(treeItem);
            }
            arrayList.addAll(this.getInstanceItems(treeItem.getItems()));
            ++n2;
        }
        return arrayList;
    }

    private class MenuDeleteListener
    implements Listener {
        private IInstance instance;

        public MenuDeleteListener(IInstance iInstance) {
            this.instance = iInstance;
        }

        public void handleEvent(Event event) {
            final boolean[] blArray = new boolean[1];
            if (this.instance != null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        blArray[0] = MessageDialog.openQuestion((Shell)iWorkbenchWindow.getShell(), (String)Messages.InstanceStatusComposite_0, (String)(String.valueOf(Messages.InstanceStatusComposite_1) + MenuDeleteListener.this.instance.getName() + Messages.InstanceStatusComposite_2));
                    }
                });
                if (blArray[0]) {
                    InstanceStatusComposite.this.removeSelected();
                }
            }
        }
    }

    private class MenuPropertiesListener
    implements Listener {
        private IInstance instance;

        public MenuPropertiesListener(IInstance iInstance) {
            this.instance = iInstance;
        }

        public void handleEvent(Event event) {
            Shell shell = new Shell();
            PreferenceDialog preferenceDialog = PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)this.instance, null, null, null);
            preferenceDialog.open();
        }
    }

    private class WizardDropDownAction
    extends Action
    implements IMenuCreator {
        private Menu fMenu;

        public WizardDropDownAction() {
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.sequoyah.device.framework.ui", (String)"icons/full/obj16/new_instance.gif");
            this.setHoverImageDescriptor(imageDescriptor);
            this.setImageDescriptor(imageDescriptor);
            this.setMenuCreator(this);
        }

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Control control) {
            if (this.fMenu != null) {
                this.fMenu.dispose();
            }
            this.fMenu = new Menu(control);
            for (Action action : InstanceStatusComposite.this.wizardActions.values()) {
                ActionContributionItem actionContributionItem = new ActionContributionItem((IAction)action);
                actionContributionItem.fill(this.fMenu, -1);
            }
            return this.fMenu;
        }

        public Menu getMenu(Menu menu) {
            return null;
        }

        public void run() {
            if (InstanceStatusComposite.this.wizardActions.size() > 1) {
                ListDialog listDialog = new ListDialog(InstanceStatusComposite.this.viewSite.getShell());
                listDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                listDialog.setLabelProvider((ILabelProvider)new LabelProvider());
                listDialog.setTitle(TOOLBAR_NEW_TOOLTIP);
                listDialog.setMessage(TOOLBAR_DIALOG_MESSAGE);
                Action[] actionArray = new Action[InstanceStatusComposite.this.wizardActions.size()];
                actionArray = InstanceStatusComposite.this.wizardActions.values().toArray(actionArray);
                listDialog.setInput((Object)actionArray);
                if (listDialog.open() == 0) {
                    ((Action)listDialog.getResult()[0]).run();
                }
            } else if (InstanceStatusComposite.this.wizardActions.size() == 1) {
                ((Action)InstanceStatusComposite.this.wizardActions.values().toArray()[0]).run();
            }
        }
    }

    private class WizardSelectionListener
    implements Listener {
        private String deviceName;

        public WizardSelectionListener(String string) {
            this.deviceName = string;
        }

        public void handleEvent(Event event) {
            Action action = InstanceStatusComposite.this.wizardActions.get(this.deviceName);
            if (action != null) {
                action.run();
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        MessageDialog.openError((Shell)iWorkbenchWindow.getShell(), (String)ERROR_DIALOG_TITLE, (String)(String.valueOf(ERROR_NO_WIZARD_MESSAGE) + WizardSelectionListener.this.deviceName));
                    }
                });
            }
        }
    }
}

