/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.status;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.sequoyah.device.common.utilities.BasePlugin;
import org.eclipse.sequoyah.device.common.utilities.PluginUtils;
import org.eclipse.sequoyah.device.framework.DeviceResources;
import org.eclipse.sequoyah.device.framework.manager.ServiceManager;
import org.eclipse.sequoyah.device.framework.model.IService;
import org.eclipse.sequoyah.device.framework.status.IStatus;
import org.eclipse.sequoyah.device.framework.status.StatusFactory;
import org.eclipse.sequoyah.device.framework.status.StatusRegistry;

public class StatusManager {
    private static StatusManager _instance;

    private StatusManager() {
        this.loadStatus();
    }

    public static StatusManager getInstance() {
        if (_instance == null) {
            _instance = new StatusManager();
        }
        return _instance;
    }

    public void loadStatus() {
        Collection collection = PluginUtils.getInstalledPlugins((String)"org.eclipse.sequoyah.device.framework.status");
        StatusRegistry.getInstance().clear();
        ServiceManager serviceManager = ServiceManager.getInstance();
        serviceManager.loadServices();
        List<IService> list = serviceManager.getInstalledServices();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (IService object2 : list) {
            if (object2 == null) continue;
            hashMap.put(object2.getId(), object2.getName());
        }
        StatusRegistry statusRegistry = StatusRegistry.getInstance();
        for (Object object3 : collection) {
            IStatus iStatus = StatusFactory.createStatus((String)object3);
            statusRegistry.addStatus(iStatus);
            String string = (String)hashMap.get(iStatus.getDefaultServiceId());
            String string2 = null;
            if (string != null) {
                string2 = DeviceResources.bind((String)DeviceResources.StatusManager_TooltipTextMessage, (Object)string);
            }
            statusRegistry.addStatusTooltip(iStatus.getId(), string2);
        }
    }

    public void listStatus() {
        for (IStatus iStatus : StatusRegistry.getInstance().getStatus()) {
            BasePlugin.logInfo((String)iStatus.toString());
        }
    }
}

