/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.rulesupport.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.RuleRegistry;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.Visibility;
import org.eclipse.smarthome.automation.module.script.ScriptExtensionProvider;
import org.eclipse.smarthome.automation.module.script.rulesupport.internal.ScriptedCustomModuleHandlerFactory;
import org.eclipse.smarthome.automation.module.script.rulesupport.internal.ScriptedCustomModuleTypeProvider;
import org.eclipse.smarthome.automation.module.script.rulesupport.internal.ScriptedPrivateModuleHandlerFactory;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.RuleSupportRuleRegistryDelegate;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.ScriptedAutomationManager;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.ScriptedRuleProvider;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.factories.ScriptedActionHandlerFactory;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.factories.ScriptedConditionHandlerFactory;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.factories.ScriptedTriggerHandlerFactory;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.simple.SimpleActionHandler;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.simple.SimpleConditionHandler;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.simple.SimpleRule;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.simple.SimpleTriggerHandler;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.TriggerType;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.eclipse.smarthome.config.core.Configuration;

public class RuleSupportScriptExtension
implements ScriptExtensionProvider {
    private static final String RULE_SUPPORT = "RuleSupport";
    private static final String RULE_REGISTRY = "ruleRegistry";
    private static final String AUTOMATION_MANAGER = "automationManager";
    private static HashMap<String, Collection<String>> presets = new HashMap();
    private static HashMap<String, Object> staticTypes = new HashMap();
    private static HashSet<String> types = new HashSet();
    private ConcurrentHashMap<String, HashMap<String, Object>> objectCache = new ConcurrentHashMap();
    private RuleRegistry ruleRegistry;
    private ScriptedRuleProvider ruleProvider;
    private ScriptedCustomModuleHandlerFactory scriptedCustomModuleHandlerFactory;
    private ScriptedCustomModuleTypeProvider scriptedCustomModuleTypeProvider;
    private ScriptedPrivateModuleHandlerFactory scriptedPrivateModuleHandlerFactory;

    static {
        staticTypes.put("SimpleActionHandler", SimpleActionHandler.class);
        staticTypes.put("SimpleConditionHandler", SimpleConditionHandler.class);
        staticTypes.put("SimpleTriggerHandler", SimpleTriggerHandler.class);
        staticTypes.put("SimpleRule", SimpleRule.class);
        staticTypes.put("ActionHandlerFactory", ScriptedActionHandlerFactory.class);
        staticTypes.put("ConditionHandlerFactory", ScriptedConditionHandlerFactory.class);
        staticTypes.put("TriggerHandlerFactory", ScriptedTriggerHandlerFactory.class);
        staticTypes.put("Configuration", Configuration.class);
        staticTypes.put("Action", Action.class);
        staticTypes.put("Condition", Condition.class);
        staticTypes.put("Trigger", Trigger.class);
        staticTypes.put("Rule", Rule.class);
        staticTypes.put("ModuleType", ModuleType.class);
        staticTypes.put("ActionType", ActionType.class);
        staticTypes.put("TriggerType", TriggerType.class);
        staticTypes.put("Visibility", Visibility.class);
        staticTypes.put("ConfigDescriptionParameter", ConfigDescriptionParameter.class);
        types.addAll(staticTypes.keySet());
        types.add(AUTOMATION_MANAGER);
        types.add(RULE_REGISTRY);
        presets.put(RULE_SUPPORT, Arrays.asList("Configuration", "Action", "Condition", "Trigger", "Rule"));
        presets.put("RuleSimple", Arrays.asList("SimpleActionHandler", "SimpleConditionHandler", "SimpleTriggerHandler", "SimpleRule", "TriggerType", "ConfigDescriptionParameter", "ModuleType", "ActionType", "Visibility"));
        presets.put("RuleFactories", Arrays.asList("ActionHandlerFactory", "ConditionHandlerFactory", "TriggerHandlerFactory", "TriggerType", "ConfigDescriptionParameter", "ModuleType", "ActionType", "Visibility"));
    }

    public void setRuleRegistry(RuleRegistry ruleRegistry) {
        this.ruleRegistry = ruleRegistry;
    }

    public void setRuleProvider(ScriptedRuleProvider ruleProvider) {
        this.ruleProvider = ruleProvider;
    }

    public void setScriptedCustomModuleHandlerFactory(ScriptedCustomModuleHandlerFactory factory) {
        this.scriptedCustomModuleHandlerFactory = factory;
    }

    public void setScriptedCustomModuleTypeProvider(ScriptedCustomModuleTypeProvider scriptedCustomModuleTypeProvider) {
        this.scriptedCustomModuleTypeProvider = scriptedCustomModuleTypeProvider;
    }

    public void setScriptedPrivateModuleHandlerFactory(ScriptedPrivateModuleHandlerFactory factory) {
        this.scriptedPrivateModuleHandlerFactory = factory;
    }

    public Collection<String> getDefaultPresets() {
        return Collections.emptyList();
    }

    public Collection<String> getPresets() {
        return presets.keySet();
    }

    public Collection<String> getTypes() {
        return types;
    }

    public Object get(String scriptIdentifier, String type) {
        Object obj = staticTypes.get(type);
        if (obj != null) {
            return obj;
        }
        HashMap<String, Object> objects = this.objectCache.get(scriptIdentifier);
        if (objects == null) {
            objects = new HashMap();
            this.objectCache.put(scriptIdentifier, objects);
        }
        if ((obj = objects.get(type)) != null) {
            return obj;
        }
        if (type.equals(AUTOMATION_MANAGER) || type.equals(RULE_REGISTRY)) {
            RuleSupportRuleRegistryDelegate ruleRegistryDelegate = new RuleSupportRuleRegistryDelegate(this.ruleRegistry, this.ruleProvider);
            ScriptedAutomationManager automationManager = new ScriptedAutomationManager(ruleRegistryDelegate, this.scriptedCustomModuleHandlerFactory, this.scriptedCustomModuleTypeProvider, this.scriptedPrivateModuleHandlerFactory);
            objects.put(AUTOMATION_MANAGER, automationManager);
            objects.put(RULE_REGISTRY, ruleRegistryDelegate);
            obj = objects.get(type);
        }
        return obj;
    }

    public Map<String, Object> importPreset(String scriptIdentifier, String preset) {
        HashMap<String, Object> scopeValues = new HashMap<String, Object>();
        Collection<String> values = presets.get(preset);
        for (String value : values) {
            scopeValues.put(value, staticTypes.get(value));
        }
        if (preset.equals(RULE_SUPPORT)) {
            scopeValues.put(AUTOMATION_MANAGER, this.get(scriptIdentifier, AUTOMATION_MANAGER));
            Object ruleRegistry = this.get(scriptIdentifier, RULE_REGISTRY);
            scopeValues.put(RULE_REGISTRY, ruleRegistry);
        }
        return scopeValues;
    }

    public void unload(String scriptIdentifier) {
        Object hr;
        HashMap<String, Object> objects = this.objectCache.remove(scriptIdentifier);
        if (objects != null && (hr = objects.get(AUTOMATION_MANAGER)) != null) {
            ScriptedAutomationManager automationManager = (ScriptedAutomationManager)hr;
            automationManager.removeAll();
        }
    }
}

