/**
 * Copyright (c) 2014,2018 Contributors to the Eclipse Foundation
 *
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.binding.lirc.internal.messages;

/**
 * Represents a response received from the LIRC server
 *
 * @author Andrew Nagle - Initial contribution
 */
public class LIRCResponse {

    private final String command;
    private final boolean success;
    private final String[] data;

    public LIRCResponse(String command, boolean success, String[] data) {
        super();
        this.command = command;
        this.success = success;
        this.data = data;
    }

    public String getCommand() {
        return command;
    }

    public boolean isSuccess() {
        return success;
    }

    public String[] getData() {
        return data;
    }

}
