/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.basic.internal.render;

import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.library.items.NumberItem;
import org.eclipse.smarthome.core.library.items.RollershutterItem;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateOption;
import org.eclipse.smarthome.model.sitemap.Mapping;
import org.eclipse.smarthome.model.sitemap.Switch;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.basic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.basic.render.RenderException;
import org.eclipse.smarthome.ui.basic.render.WidgetRenderer;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={WidgetRenderer.class})
public class SwitchRenderer
extends AbstractWidgetRenderer {
    private final Logger logger = LoggerFactory.getLogger(SwitchRenderer.class);
    private static final int MAX_BUTTONS = 4;
    private static final int MAX_LABEL_SIZE = 9;
    private static final String ELLIPSIS = "\u2026";

    @Override
    @Activate
    protected void activate(BundleContext bundleContext) {
        super.activate(bundleContext);
    }

    @Override
    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        super.deactivate(bundleContext);
    }

    @Override
    public boolean canRender(Widget w) {
        return w instanceof Switch;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        Switch s = (Switch)w;
        String snippetName = null;
        Item item = null;
        int nbButtons = 0;
        try {
            item = this.itemUIRegistry.getItem(w.getItem());
            if (s.getMappings().size() == 0) {
                if (item instanceof RollershutterItem) {
                    snippetName = "rollerblind";
                } else if (item instanceof GroupItem && ((GroupItem)item).getBaseItem() instanceof RollershutterItem) {
                    snippetName = "rollerblind";
                } else {
                    int optsSize;
                    StateDescription stateDescription = item.getStateDescription();
                    int n = optsSize = stateDescription == null ? -1 : stateDescription.getOptions().size();
                    if (optsSize > 0 && optsSize <= 4) {
                        snippetName = "buttons";
                        nbButtons = optsSize;
                    } else {
                        snippetName = "switch";
                    }
                }
            } else {
                snippetName = "buttons";
                nbButtons = s.getMappings().size();
            }
        }
        catch (ItemNotFoundException e) {
            this.logger.warn("Cannot determine item type of '{}'", (Object)w.getItem(), (Object)e);
            snippetName = "switch";
        }
        String snippet = this.getSnippet(snippetName);
        State state = this.itemUIRegistry.getState(w);
        snippet = this.preprocessSnippet(snippet, w);
        if (nbButtons == 0) {
            snippet = state.equals(OnOffType.ON) ? snippet.replaceAll("%checked%", "checked=true") : snippet.replaceAll("%checked%", "");
        } else {
            StateDescription stateDescription;
            StringBuilder buttons = new StringBuilder();
            if (s.getMappings().size() > 0) {
                for (Mapping mapping : s.getMappings()) {
                    this.buildButton(s, mapping.getLabel(), mapping.getCmd(), -1, nbButtons > 1, item, state, buttons);
                }
            } else if (item != null && (stateDescription = item.getStateDescription()) != null) {
                for (StateOption option : stateDescription.getOptions()) {
                    this.buildButton(s, option.getLabel(), option.getValue(), 9, nbButtons > 1, item, state, buttons);
                }
            }
            snippet = StringUtils.replace((String)snippet, (String)"%buttons%", (String)buttons.toString());
            snippet = StringUtils.replace((String)snippet, (String)"%count%", (String)Integer.toString(nbButtons));
        }
        snippet = this.processColor(w, snippet);
        sb.append(snippet);
        return null;
    }

    private void buildButton(Switch w, String lab, String cmd, int maxLabelSize, boolean severalButtons, Item item, State state, StringBuilder buttons) throws RenderException {
        String button = this.getSnippet("button");
        String command = cmd;
        String label = lab;
        if (item instanceof NumberItem && ((NumberItem)item).getDimension() != null) {
            String unit = this.getUnitForWidget((Widget)w);
            command = StringUtils.replace((String)command, (String)"%unit%", (String)unit);
            label = StringUtils.replace((String)label, (String)"%unit%", (String)unit);
        }
        if (label != null && maxLabelSize >= 1 && label.length() > maxLabelSize) {
            label = String.valueOf(label.substring(0, maxLabelSize - 1)) + ELLIPSIS;
        }
        button = StringUtils.replace((String)button, (String)"%item%", (String)w.getItem());
        button = StringUtils.replace((String)button, (String)"%cmd%", (String)this.escapeHtml(command));
        button = StringUtils.replace((String)button, (String)"%label%", (String)(label != null ? this.escapeHtml(label) : ""));
        State compareMappingState = state;
        if (state instanceof QuantityType) {
            compareMappingState = this.convertStateToLabelUnit((QuantityType)state, command);
        }
        String buttonClass = severalButtons && compareMappingState.toString().equals(command) ? "mdl-button--accent" : "mdl-button";
        button = StringUtils.replace((String)button, (String)"%class%", (String)buttonClass);
        buttons.append(button);
    }

    @Override
    @Reference
    protected void setItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.setItemUIRegistry(ItemUIRegistry2);
    }

    @Override
    protected void unsetItemUIRegistry(ItemUIRegistry ItemUIRegistry2) {
        super.unsetItemUIRegistry(ItemUIRegistry2);
    }
}

