package org.eclipse.smarthome.model.script.internal.engine;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Singleton;
import java.util.List;
import org.eclipse.smarthome.core.scriptengine.action.ActionService;
import org.eclipse.smarthome.model.script.engine.IActionServiceProvider;
import org.eclipse.smarthome.model.script.internal.ScriptActivator;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@Singleton
@SuppressWarnings("all")
public class ServiceTrackerActionServiceProvider implements IActionServiceProvider {
  private List<ActionService> cache = null;
  
  private int trackingCount = (-1);
  
  public List<ActionService> get() {
    List<ActionService> _xblockexpression = null;
    {
      final int currentTrackingCount = ScriptActivator.actionServiceTracker.getTrackingCount();
      if ((this.trackingCount != currentTrackingCount)) {
        final Object[] services = ScriptActivator.actionServiceTracker.getServices();
        List<ActionService> _xifexpression = null;
        boolean _notEquals = (!Objects.equal(services, null));
        if (_notEquals) {
          Iterable<ActionService> _filter = Iterables.<ActionService>filter(((Iterable<?>)Conversions.doWrapArray(services)), ActionService.class);
          _xifexpression = IterableExtensions.<ActionService>toList(_filter);
        } else {
          _xifexpression = CollectionLiterals.<ActionService>emptyList();
        }
        this.cache = _xifexpression;
      }
      _xblockexpression = this.cache;
    }
    return _xblockexpression;
  }
}
