/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.persistence.internal;

import java.text.DateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.core.common.registry.RegistryChangeListener;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.ItemRegistryChangeListener;
import org.eclipse.smarthome.core.items.StateChangeListener;
import org.eclipse.smarthome.core.persistence.FilterCriteria;
import org.eclipse.smarthome.core.persistence.HistoricItem;
import org.eclipse.smarthome.core.persistence.PersistenceService;
import org.eclipse.smarthome.core.persistence.QueryablePersistenceService;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;
import org.eclipse.smarthome.model.core.EventType;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.core.ModelRepositoryChangeListener;
import org.eclipse.smarthome.model.persistence.internal.PersistItemsJob;
import org.eclipse.smarthome.model.persistence.persistence.AllConfig;
import org.eclipse.smarthome.model.persistence.persistence.CronStrategy;
import org.eclipse.smarthome.model.persistence.persistence.GroupConfig;
import org.eclipse.smarthome.model.persistence.persistence.ItemConfig;
import org.eclipse.smarthome.model.persistence.persistence.PersistenceConfiguration;
import org.eclipse.smarthome.model.persistence.persistence.PersistenceModel;
import org.eclipse.smarthome.model.persistence.persistence.Strategy;
import org.eclipse.smarthome.model.persistence.scoping.GlobalStrategies;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceManager
implements ModelRepositoryChangeListener,
ItemRegistryChangeListener,
StateChangeListener {
    private final Logger logger = LoggerFactory.getLogger(PersistenceManager.class);
    private static PersistenceManager instance;
    private Scheduler scheduler;
    ModelRepository modelRepository;
    private ItemRegistry itemRegistry;
    Map<String, PersistenceService> persistenceServices = new HashMap<String, PersistenceService>();
    protected Map<String, List<PersistenceConfiguration>> persistenceConfigurations = new ConcurrentHashMap<String, List<PersistenceConfiguration>>();
    protected Map<String, List<Strategy>> defaultStrategies = Collections.synchronizedMap(new HashMap());

    public PersistenceManager() {
        instance = this;
        try {
            this.scheduler = StdSchedulerFactory.getDefaultScheduler();
        }
        catch (SchedulerException e) {
            this.logger.error("initializing scheduler throws exception", (Throwable)e);
        }
    }

    static PersistenceManager getInstance() {
        return instance;
    }

    public void activate() {
    }

    public void deactivate() {
    }

    public void setModelRepository(ModelRepository modelRepository) {
        this.modelRepository = modelRepository;
        modelRepository.addModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        for (String modelName : modelRepository.getAllModelNamesOfType("persist")) {
            String serviceName = modelName.substring(0, modelName.length() - ".persist".length());
            this.stopEventHandling(serviceName);
            this.startEventHandling(serviceName);
        }
    }

    public void unsetModelRepository(ModelRepository modelRepository) {
        modelRepository.removeModelRepositoryChangeListener((ModelRepositoryChangeListener)this);
        for (String modelName : modelRepository.getAllModelNamesOfType("persist")) {
            this.stopEventHandling(modelName);
        }
        this.modelRepository = null;
    }

    public void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
        itemRegistry.addRegistryChangeListener((RegistryChangeListener)this);
        this.allItemsChanged(null);
    }

    public void unsetItemRegistry(ItemRegistry itemRegistry) {
        itemRegistry.removeRegistryChangeListener((RegistryChangeListener)this);
        this.itemRegistry = null;
    }

    public void addPersistenceService(PersistenceService persistenceService) {
        this.logger.debug("Initializing {} persistence service.", (Object)persistenceService.getName());
        this.persistenceServices.put(persistenceService.getName(), persistenceService);
        this.stopEventHandling(persistenceService.getName());
        this.startEventHandling(persistenceService.getName());
    }

    public void removePersistenceService(PersistenceService persistenceService) {
        this.stopEventHandling(persistenceService.getName());
        this.persistenceServices.remove(persistenceService.getName());
    }

    public void modelChanged(String modelName, EventType type) {
        if (modelName.endsWith(".persist")) {
            String serviceName = modelName.substring(0, modelName.length() - ".persist".length());
            if (type == EventType.REMOVED || type == EventType.MODIFIED) {
                this.stopEventHandling(serviceName);
            }
            if ((type == EventType.ADDED || type == EventType.MODIFIED) && this.itemRegistry != null && this.persistenceServices.containsKey(serviceName)) {
                this.startEventHandling(serviceName);
            }
        }
    }

    private void startEventHandling(String modelName) {
        PersistenceModel model;
        if (this.modelRepository != null && (model = (PersistenceModel)this.modelRepository.getModel(String.valueOf(modelName) + ".persist")) != null) {
            this.persistenceConfigurations.put(modelName, (List<PersistenceConfiguration>)model.getConfigs());
            this.defaultStrategies.put(modelName, (List<Strategy>)model.getDefaults());
            if (this.itemRegistry != null) {
                for (PersistenceConfiguration config : model.getConfigs()) {
                    if (!this.hasStrategy(modelName, config, GlobalStrategies.RESTORE)) continue;
                    for (Item item : this.getAllItems(config)) {
                        this.initialize(item);
                    }
                }
            }
            this.createTimers(modelName);
        }
    }

    private void stopEventHandling(String modelName) {
        this.persistenceConfigurations.remove(modelName);
        this.defaultStrategies.remove(modelName);
        this.removeTimers(modelName);
    }

    public void stateChanged(Item item, State oldState, State newState) {
        this.handleStateEvent(item, true);
    }

    public void stateUpdated(Item item, State state) {
        this.handleStateEvent(item, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleStateEvent(Item item, boolean onlyChanges) {
        Map<String, List<PersistenceConfiguration>> map = this.persistenceConfigurations;
        synchronized (map) {
            for (Map.Entry<String, List<PersistenceConfiguration>> entry : this.persistenceConfigurations.entrySet()) {
                String serviceName = entry.getKey();
                if (!this.persistenceServices.containsKey(serviceName)) continue;
                for (PersistenceConfiguration config : entry.getValue()) {
                    if (!this.hasStrategy(serviceName, config, onlyChanges ? GlobalStrategies.CHANGE : GlobalStrategies.UPDATE) || !this.appliesToItem(config, item)) continue;
                    this.persistenceServices.get(serviceName).store(item, config.getAlias());
                }
            }
        }
    }

    protected boolean hasStrategy(String serviceName, PersistenceConfiguration config, Strategy strategy) {
        if (this.defaultStrategies.get(serviceName).contains(strategy) && config.getStrategies().isEmpty()) {
            return true;
        }
        for (Strategy s : config.getStrategies()) {
            if (!s.equals(strategy)) continue;
            return true;
        }
        return false;
    }

    protected boolean appliesToItem(PersistenceConfiguration config, Item item) {
        for (EObject itemCfg : config.getItems()) {
            if (itemCfg instanceof AllConfig) {
                return true;
            }
            if (itemCfg instanceof ItemConfig) {
                ItemConfig singleItemConfig = (ItemConfig)itemCfg;
                if (item.getName().equals(singleItemConfig.getItem())) {
                    return true;
                }
            }
            if (!(itemCfg instanceof GroupConfig)) continue;
            GroupConfig groupItemCfg = (GroupConfig)itemCfg;
            String groupName = groupItemCfg.getGroup();
            try {
                GroupItem groupItem;
                Item gItem = this.itemRegistry.getItem(groupName);
                if (!(gItem instanceof GroupItem) || !(groupItem = (GroupItem)gItem).getAllMembers().contains(item)) continue;
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    protected Iterable<Item> getAllItems(PersistenceConfiguration config) {
        for (EObject itemCfg : config.getItems()) {
            if (!(itemCfg instanceof AllConfig)) continue;
            return this.itemRegistry.getItems();
        }
        HashSet<Item> items = new HashSet<Item>();
        for (EObject itemCfg : config.getItems()) {
            if (itemCfg instanceof ItemConfig) {
                ItemConfig singleItemConfig = (ItemConfig)itemCfg;
                try {
                    Item item = this.itemRegistry.getItem(singleItemConfig.getItem());
                    items.add(item);
                }
                catch (ItemNotFoundException itemNotFoundException) {
                    this.logger.debug("Item '{}' does not exist.", (Object)singleItemConfig.getItem());
                }
            }
            if (!(itemCfg instanceof GroupConfig)) continue;
            GroupConfig groupItemCfg = (GroupConfig)itemCfg;
            String groupName = groupItemCfg.getGroup();
            try {
                Item gItem = this.itemRegistry.getItem(groupName);
                if (!(gItem instanceof GroupItem)) continue;
                GroupItem groupItem = (GroupItem)gItem;
                items.addAll(groupItem.getAllMembers());
            }
            catch (ItemNotFoundException itemNotFoundException) {
                this.logger.debug("Item group '{}' does not exist.", (Object)groupName);
            }
        }
        return items;
    }

    public void allItemsChanged(Collection<String> oldItemNames) {
        for (Item item : this.itemRegistry.getItems()) {
            this.added(item);
        }
    }

    public void added(Item item) {
        this.initialize(item);
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.addStateChangeListener((StateChangeListener)this);
        }
    }

    protected void initialize(Item item) {
        if (item.getState().equals(UnDefType.NULL) && item instanceof GenericItem) {
            for (Map.Entry<String, List<PersistenceConfiguration>> entry : this.persistenceConfigurations.entrySet()) {
                String serviceName = entry.getKey();
                for (PersistenceConfiguration config : entry.getValue()) {
                    if (!this.hasStrategy(serviceName, config, GlobalStrategies.RESTORE) || !this.appliesToItem(config, item)) continue;
                    PersistenceService service = this.persistenceServices.get(serviceName);
                    if (service instanceof QueryablePersistenceService) {
                        QueryablePersistenceService queryService = (QueryablePersistenceService)service;
                        FilterCriteria filter = new FilterCriteria().setItemName(item.getName()).setPageSize(1);
                        Iterable result = queryService.query(filter);
                        Iterator it = result.iterator();
                        if (!it.hasNext()) continue;
                        HistoricItem historicItem = (HistoricItem)it.next();
                        GenericItem genericItem = (GenericItem)item;
                        genericItem.removeStateChangeListener((StateChangeListener)this);
                        genericItem.setState(historicItem.getState());
                        genericItem.addStateChangeListener((StateChangeListener)this);
                        this.logger.debug("Restored item state from '{}' for item '{}' -> '{}'", new Object[]{DateFormat.getDateTimeInstance().format(historicItem.getTimestamp()), item.getName(), historicItem.getState().toString()});
                        return;
                    }
                    if (service == null) continue;
                    this.logger.warn("Failed to restore item states as persistence service '{}' can not be queried.", (Object)serviceName);
                }
            }
        }
    }

    public void removed(Item item) {
        if (item instanceof GenericItem) {
            GenericItem genericItem = (GenericItem)item;
            genericItem.removeStateChangeListener((StateChangeListener)this);
        }
    }

    private void createTimers(String modelName) {
        PersistenceModel persistModel = (PersistenceModel)this.modelRepository.getModel(String.valueOf(modelName) + ".persist");
        if (persistModel != null) {
            for (Strategy strategy : persistModel.getStrategies()) {
                if (!(strategy instanceof CronStrategy)) continue;
                CronStrategy cronStrategy = (CronStrategy)strategy;
                String cronExpression = cronStrategy.getCronExpression();
                JobKey jobKey = new JobKey(strategy.getName(), modelName);
                try {
                    JobDetail job = JobBuilder.newJob(PersistItemsJob.class).usingJobData("model", cronStrategy.eResource().getURI().trimFileExtension().path()).usingJobData("strategy", cronStrategy.getName()).withIdentity(jobKey).build();
                    Trigger quartzTrigger = TriggerBuilder.newTrigger().withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cronExpression)).build();
                    this.scheduler.scheduleJob(job, quartzTrigger);
                    this.logger.debug("Scheduled strategy {} with cron expression {}", new Object[]{jobKey.toString(), cronExpression});
                }
                catch (SchedulerException e) {
                    this.logger.error("Failed to schedule job for strategy {} with cron expression {}", (Object)new String[]{jobKey.toString(), cronExpression}, (Object)e);
                }
            }
        }
    }

    private void removeTimers(String persistModelName) {
        try {
            Set jobKeys = this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)persistModelName));
            for (JobKey jobKey : jobKeys) {
                try {
                    boolean success = this.scheduler.deleteJob(jobKey);
                    if (success) {
                        this.logger.debug("Removed scheduled cron job for strategy '{}'", (Object)jobKey.toString());
                        continue;
                    }
                    this.logger.warn("Failed to delete cron jobs '{}'", (Object)jobKey.getName());
                }
                catch (SchedulerException schedulerException) {
                    this.logger.warn("Failed to delete cron jobs '{}'", (Object)jobKey.getName());
                }
            }
        }
        catch (SchedulerException schedulerException) {
            this.logger.warn("Failed to delete cron jobs of group '{}'", (Object)persistModelName);
        }
    }

    public void updated(Item oldItem, Item item) {
    }
}

