/**
 * Copyright (c) 2014-2015 openHAB UG (haftungsbeschraenkt) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
/*
 * generated by Xtext
 */
package org.eclipse.smarthome.model.script;

import org.eclipse.smarthome.model.script.interpreter.ScriptInterpreter;
import org.eclipse.smarthome.model.script.scoping.ActionClassLoader;
import org.eclipse.smarthome.model.script.scoping.ScriptImplicitlyImportedTypes;
import org.eclipse.smarthome.model.script.scoping.ScriptImportSectionNamespaceScopeProvider;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.reflect.ReflectionTypeProviderFactory;
import org.eclipse.xtext.common.types.access.reflect.ReflectionTypeScopeProvider;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScopeProvider;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.generator.IGenerator.NullGenerator;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.xbase.interpreter.IExpressionInterpreter;
import org.eclipse.xtext.xbase.scoping.batch.ImplicitlyImportedFeatures;

import com.google.inject.Binder;
import com.google.inject.name.Names;

/**
 * Use this class to register components to be used at runtime / without the Equinox extension registry.
 *
 * @author Oliver Libutzki - Initial contribution
 *
 */
@SuppressWarnings("restriction")
public class ScriptRuntimeModule extends org.eclipse.smarthome.model.script.AbstractScriptRuntimeModule {

    public Class<? extends ImplicitlyImportedFeatures> bindImplicitlyImportedTypes() {
        return ScriptImplicitlyImportedTypes.class;
    }

    @Override
    public Class<? extends IExpressionInterpreter> bindIExpressionInterpreter() {
        return ScriptInterpreter.class;
    }

    @Override
    public Class<? extends IGenerator> bindIGenerator() {
        return NullGenerator.class;
    }

    @Override
    public void configureIScopeProviderDelegate(Binder binder) {
        binder.bind(IScopeProvider.class).annotatedWith(Names.named(AbstractDeclarativeScopeProvider.NAMED_DELEGATE))
                .to(ScriptImportSectionNamespaceScopeProvider.class);
    }

    @Override
    public Class<? extends IJvmTypeProvider.Factory> bindIJvmTypeProvider$Factory() {
        return ReflectionTypeProviderFactory.class;
    }

    @Override
    public Class<? extends AbstractTypeScopeProvider> bindAbstractTypeScopeProvider() {
        return ReflectionTypeScopeProvider.class;
    }

    @Override
    public ClassLoader bindClassLoaderToInstance() {
        return new ActionClassLoader(super.bindClassLoaderToInstance());
    }

}
