/**
 * Copyright (c) 2014 openHAB UG (haftungsbeschr??nkt) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.smarthome.model.script.interpreter;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemNotFoundException;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.types.Type;
import org.eclipse.smarthome.model.script.engine.IItemRegistryProvider;
import org.eclipse.smarthome.model.script.lib.NumberExtensions;
import org.eclipse.smarthome.model.script.scoping.StateAndCommandProvider;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.eclipse.xtext.xbase.interpreter.impl.XbaseInterpreter;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * The script interpreter handles ESH specific script components, which are not known
 * to the standard Xbase interpreter.
 * 
 * @author Kai Kreuzer - Initial contribution and API
 * @author Oliver Libutzki - Xtext 2.5.0 migration
 */
@SuppressWarnings("restriction")
public class ScriptInterpreter extends XbaseInterpreter {
  @Inject
  private IItemRegistryProvider itemRegistryProvider;
  
  @Inject
  private StateAndCommandProvider stateAndCommandProvider;
  
  @Inject
  @Extension
  private IJvmModelAssociations _iJvmModelAssociations;
  
  @Override
  protected Object _invokeFeature(final JvmField jvmField, final XAbstractFeatureCall featureCall, final Object receiver, final IEvaluationContext context, final CancelIndicator indicator) {
    Object _xblockexpression = null;
    {
      Set<EObject> _sourceElements = this._iJvmModelAssociations.getSourceElements(jvmField);
      final EObject sourceElement = IterableExtensions.<EObject>head(_sourceElements);
      Object _xifexpression = null;
      boolean _notEquals = (!Objects.equal(sourceElement, null));
      if (_notEquals) {
        Object _xblockexpression_1 = null;
        {
          String _simpleName = jvmField.getSimpleName();
          QualifiedName _create = QualifiedName.create(_simpleName);
          final Object value = context.getValue(_create);
          Object _elvis = null;
          if (value != null) {
            _elvis = value;
          } else {
            Object _xblockexpression_2 = null;
            {
              final String fieldName = jvmField.getSimpleName();
              Object _elvis_1 = null;
              Type _stateOrCommand = this.getStateOrCommand(fieldName);
              if (_stateOrCommand != null) {
                _elvis_1 = _stateOrCommand;
              } else {
                Item _item = this.getItem(fieldName);
                _elvis_1 = _item;
              }
              _xblockexpression_2 = _elvis_1;
            }
            _elvis = _xblockexpression_2;
          }
          _xblockexpression_1 = _elvis;
        }
        _xifexpression = _xblockexpression_1;
      } else {
        _xifexpression = super._invokeFeature(jvmField, featureCall, receiver, context, indicator);
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  @Override
  protected Object invokeFeature(final JvmIdentifiableElement feature, final XAbstractFeatureCall featureCall, final Object receiverObj, final IEvaluationContext context, final CancelIndicator indicator) {
    Object _xblockexpression = null;
    {
      boolean _and = false;
      boolean _notEquals = (!Objects.equal(feature, null));
      if (!_notEquals) {
        _and = false;
      } else {
        boolean _eIsProxy = feature.eIsProxy();
        _and = _eIsProxy;
      }
      if (_and) {
        String _string = featureCall.toString();
        String _plus = ("The name \'" + _string);
        String _plus_1 = (_plus + "\' cannot be resolved to an item or type.");
        throw new RuntimeException(_plus_1);
      }
      _xblockexpression = super.invokeFeature(feature, featureCall, receiverObj, context, indicator);
    }
    return _xblockexpression;
  }
  
  protected Type getStateOrCommand(final String name) {
    Iterable<Type> _allTypes = this.stateAndCommandProvider.getAllTypes();
    for (final Type type : _allTypes) {
      String _string = type.toString();
      boolean _equals = Objects.equal(_string, name);
      if (_equals) {
        return type;
      }
    }
    return null;
  }
  
  protected Item getItem(final String name) {
    final ItemRegistry itemRegistry = this.itemRegistryProvider.get();
    try {
      return itemRegistry.getItem(name);
    } catch (final Throwable _t) {
      if (_t instanceof ItemNotFoundException) {
        final ItemNotFoundException e = (ItemNotFoundException)_t;
        return null;
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
  
  @Override
  protected boolean eq(final Object a, final Object b) {
    boolean _and = false;
    if (!(a instanceof Type)) {
      _and = false;
    } else {
      _and = (b instanceof Number);
    }
    if (_and) {
      return NumberExtensions.operator_equals(((Type) a), ((Number) b));
    } else {
      boolean _and_1 = false;
      if (!(a instanceof Number)) {
        _and_1 = false;
      } else {
        _and_1 = (b instanceof Type);
      }
      if (_and_1) {
        return NumberExtensions.operator_equals(((Type) b), ((Number) a));
      } else {
        return super.eq(a, b);
      }
    }
  }
  
  @Override
  public Object _assignValueTo(final JvmField jvmField, final XAbstractFeatureCall assignment, final Object value, final IEvaluationContext context, final CancelIndicator indicator) {
    Object _xblockexpression = null;
    {
      Set<EObject> _sourceElements = this._iJvmModelAssociations.getSourceElements(jvmField);
      final EObject sourceElement = IterableExtensions.<EObject>head(_sourceElements);
      Object _xifexpression = null;
      boolean _notEquals = (!Objects.equal(sourceElement, null));
      if (_notEquals) {
        Object _xblockexpression_1 = null;
        {
          String _simpleName = jvmField.getSimpleName();
          QualifiedName _create = QualifiedName.create(_simpleName);
          context.assignValue(_create, value);
          _xblockexpression_1 = value;
        }
        _xifexpression = _xblockexpression_1;
      } else {
        _xifexpression = super._assignValueTo(jvmField, assignment, value, context, indicator);
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
}
