/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.basic.internal.render;

import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.smarthome.core.library.types.PointType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.Mapview;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.basic.internal.render.AbstractWidgetRenderer;
import org.eclipse.smarthome.ui.basic.render.RenderException;

public class MapviewRenderer
extends AbstractWidgetRenderer {
    @Override
    public boolean canRender(Widget w) {
        return w instanceof Mapview;
    }

    @Override
    public EList<Widget> renderWidget(Widget w, StringBuilder sb) throws RenderException {
        int height;
        Mapview mapview = (Mapview)w;
        String snippet = this.getSnippet("mapview");
        State state = this.itemUIRegistry.getState((Widget)mapview);
        if (state instanceof PointType) {
            PointType pointState = (PointType)state;
            double latitude = pointState.getLatitude().doubleValue();
            double longitude = pointState.getLongitude().doubleValue();
            snippet = StringUtils.replace((String)snippet, (String)"%lat%", (String)Double.toString(latitude));
            snippet = StringUtils.replace((String)snippet, (String)"%lon%", (String)Double.toString(longitude));
            snippet = StringUtils.replace((String)snippet, (String)"%lonminus%", (String)Double.toString(longitude - 0.01));
            snippet = StringUtils.replace((String)snippet, (String)"%lonplus%", (String)Double.toString(longitude + 0.01));
            snippet = StringUtils.replace((String)snippet, (String)"%latminus%", (String)Double.toString(latitude - 0.01));
            snippet = StringUtils.replace((String)snippet, (String)"%latplus%", (String)Double.toString(latitude + 0.01));
        }
        if ((height = mapview.getHeight()) == 0) {
            height = 4;
        }
        snippet = StringUtils.replace((String)snippet, (String)"%height%", (String)Integer.toString(height *= 36));
        sb.append(snippet);
        return null;
    }
}

