/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.rulesupport.internal;

import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Module;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.handler.BaseModuleHandler;
import org.eclipse.smarthome.automation.handler.BaseModuleHandlerFactory;
import org.eclipse.smarthome.automation.handler.ModuleHandler;
import org.eclipse.smarthome.automation.module.script.rulesupport.internal.delegates.SimpleActionHandlerDelegate;
import org.eclipse.smarthome.automation.module.script.rulesupport.internal.delegates.SimpleConditionHandlerDelegate;
import org.eclipse.smarthome.automation.module.script.rulesupport.internal.delegates.SimpleTriggerHandlerDelegate;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.ScriptedHandler;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.factories.ScriptedActionHandlerFactory;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.factories.ScriptedConditionHandlerFactory;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.factories.ScriptedTriggerHandlerFactory;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.simple.SimpleActionHandler;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.simple.SimpleConditionHandler;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.simple.SimpleTriggerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScriptedModuleHandlerFactory
extends BaseModuleHandlerFactory {
    Logger logger = LoggerFactory.getLogger(AbstractScriptedModuleHandlerFactory.class);

    protected ModuleHandler getModuleHandler(Module module, ScriptedHandler scriptedHandler) {
        BaseModuleHandler moduleHandler = null;
        if (scriptedHandler != null) {
            if (scriptedHandler instanceof SimpleActionHandler) {
                moduleHandler = new SimpleActionHandlerDelegate((Action)module, (SimpleActionHandler)scriptedHandler);
            } else if (scriptedHandler instanceof SimpleConditionHandler) {
                moduleHandler = new SimpleConditionHandlerDelegate((Condition)module, (SimpleConditionHandler)scriptedHandler);
            } else if (scriptedHandler instanceof SimpleTriggerHandler) {
                moduleHandler = new SimpleTriggerHandlerDelegate((Trigger)module, (SimpleTriggerHandler)scriptedHandler);
            } else if (scriptedHandler instanceof ScriptedActionHandlerFactory) {
                moduleHandler = ((ScriptedActionHandlerFactory)scriptedHandler).get((Action)module);
            } else if (scriptedHandler instanceof ScriptedTriggerHandlerFactory) {
                moduleHandler = ((ScriptedTriggerHandlerFactory)scriptedHandler).get((Trigger)module);
            } else if (scriptedHandler instanceof ScriptedConditionHandlerFactory) {
                moduleHandler = ((ScriptedConditionHandlerFactory)scriptedHandler).get((Condition)module);
            } else {
                this.logger.error("Not supported moduleHandler: {}", (Object)module.getTypeUID());
            }
        }
        return moduleHandler;
    }
}

