/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.serialbutton.handler;

import gnu.io.CommPortIdentifier;
import gnu.io.PortInUseException;
import gnu.io.RXTXPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import org.apache.commons.io.IOUtils;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.types.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerialButtonHandler
extends BaseThingHandler
implements SerialPortEventListener {
    private final Logger logger = LoggerFactory.getLogger(SerialButtonHandler.class);
    private CommPortIdentifier portId;
    private RXTXPort serialPort;
    private InputStream inputStream;

    public SerialButtonHandler(Thing thing) {
        super(thing);
    }

    public void initialize() {
        String port = (String)this.getConfig().get("port");
        if (port == null) {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "Port must be set!");
            return;
        }
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        while (portList.hasMoreElements()) {
            CommPortIdentifier id = (CommPortIdentifier)portList.nextElement();
            if (id.getPortType() != 1 || !id.getName().equals(port)) continue;
            this.logger.debug("Serial port '{}' has been found.", (Object)port);
            this.portId = id;
        }
        if (this.portId != null) {
            try {
                this.serialPort = this.portId.open(this.getThing().getUID().toString(), 2000);
                this.serialPort.addEventListener((SerialPortEventListener)this);
                this.serialPort.notifyOnDataAvailable(true);
                this.inputStream = this.serialPort.getInputStream();
                this.updateStatus(ThingStatus.ONLINE);
            }
            catch (PortInUseException portInUseException) {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.COMMUNICATION_ERROR, "Port is in use!");
            }
            catch (TooManyListenersException tooManyListenersException) {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.COMMUNICATION_ERROR, "Cannot attach listener to port!");
            }
        } else {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.OFFLINE.CONFIGURATION_ERROR, "Port is not known!");
        }
    }

    public void dispose() {
        if (this.serialPort != null) {
            this.serialPort.close();
        }
        IOUtils.closeQuietly((InputStream)this.inputStream);
    }

    public void serialEvent(SerialPortEvent event) {
        switch (event.getEventType()) {
            case 1: {
                try {
                    do {
                        byte[] readBuffer = new byte[20];
                        while (this.inputStream.available() > 0) {
                            this.inputStream.read(readBuffer);
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    } while (this.inputStream.available() > 0);
                    this.triggerChannel("button", "PRESSED");
                }
                catch (IOException e1) {
                    this.logger.debug("Error reading from serial port: {}", (Object)e1.getMessage(), (Object)e1);
                }
                break;
            }
        }
    }

    public void handleCommand(@NonNull ChannelUID channelUID, @NonNull Command command) {
    }
}

