/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.internal;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.smarthome.core.events.Event;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.ItemUtil;
import org.eclipse.smarthome.core.items.events.ItemCommandEvent;
import org.eclipse.smarthome.core.items.events.ItemEventFactory;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.voice.text.HumanLanguageInterpreter;
import org.eclipse.smarthome.core.voice.text.InterpretationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleHumanLanguageInterpreter
implements HumanLanguageInterpreter {
    private final Logger logger = LoggerFactory.getLogger(RuleHumanLanguageInterpreter.class);
    private String itemName = "VoiceCommand";
    private EventPublisher eventPublisher;

    protected void activate(Map<String, Object> config) {
        this.modified(config);
    }

    protected void modified(Map<String, Object> config) {
        String configItemName;
        if (config != null && (configItemName = (String)config.get("item")) != null && ItemUtil.isValidItemName((String)configItemName)) {
            this.itemName = configItemName;
            this.logger.debug("Using item '{}' for passing voice commands.", (Object)this.itemName);
        }
    }

    public String getId() {
        return "rulehli";
    }

    public String getLabel(Locale locale) {
        return "Rule-based Interpreter";
    }

    public String interpret(Locale locale, String text) throws InterpretationException {
        ItemCommandEvent event = ItemEventFactory.createCommandEvent((String)this.itemName, (Command)new StringType(text));
        this.eventPublisher.post((Event)event);
        return null;
    }

    public String getGrammar(Locale locale, String format) {
        return null;
    }

    public Set<Locale> getSupportedLocales() {
        return null;
    }

    public Set<String> getSupportedGrammarFormats() {
        return Collections.emptySet();
    }

    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }
}

