/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.xpath.internal;

import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XPathTransformationService
implements TransformationService {
    private final Logger logger = LoggerFactory.getLogger(XPathTransformationService.class);

    public String transform(String xpathExpression, String source) throws TransformationException {
        if (xpathExpression == null || source == null) {
            throw new TransformationException("the given parameters 'xpath' and 'source' must not be null");
        }
        this.logger.debug("about to transform '{}' by the function '{}'", (Object)source, (Object)xpathExpression);
        try (StringReader stringReader = null;){
            DocumentBuilderFactory domFactory = DocumentBuilderFactory.newInstance();
            domFactory.setNamespaceAware(true);
            domFactory.setValidating(false);
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            stringReader = new StringReader(source);
            InputSource inputSource = new InputSource(stringReader);
            inputSource.setEncoding("UTF-8");
            Document doc = builder.parse(inputSource);
            XPath xpath = XPathFactory.newInstance().newXPath();
            XPathExpression expr = xpath.compile(xpathExpression);
            String transformationResult = (String)expr.evaluate(doc, XPathConstants.STRING);
            this.logger.debug("transformation resulted in '{}'", (Object)transformationResult);
            String string = transformationResult;
            return string;
        }
    }
}

