/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lirc.internal.connector;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.io.IOUtils;
import org.eclipse.smarthome.binding.lirc.internal.config.LIRCBridgeConfiguration;
import org.eclipse.smarthome.binding.lirc.internal.connector.LIRCEventListener;
import org.eclipse.smarthome.binding.lirc.internal.connector.LIRCStreamReader;
import org.eclipse.smarthome.binding.lirc.internal.messages.LIRCButtonEvent;
import org.eclipse.smarthome.binding.lirc.internal.messages.LIRCResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LIRCConnector {
    private final Logger logger = LoggerFactory.getLogger(LIRCConnector.class);
    private Set<LIRCEventListener> listeners = new CopyOnWriteArraySet<LIRCEventListener>();
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private PrintWriter outWriter;
    private Thread readerThread;

    public void addEventListener(LIRCEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeEventListener(LIRCEventListener listener) {
        this.listeners.remove(listener);
    }

    public void connect(LIRCBridgeConfiguration config) throws UnknownHostException, IOException {
        this.logger.debug("Connecting");
        this.socket = new Socket(config.getHost(), config.getPortNumber());
        this.out = this.socket.getOutputStream();
        this.in = this.socket.getInputStream();
        this.outWriter = new PrintWriter(this.out, true);
        this.readerThread = new LIRCStreamReader(this, this.in);
        this.readerThread.start();
    }

    public void disconnect() {
        this.logger.debug("Disconnecting");
        if (this.readerThread != null) {
            this.logger.debug("Interrupt stream listener");
            this.readerThread.interrupt();
            this.readerThread = null;
        }
        if (this.outWriter != null) {
            this.logger.debug("Close print writer stream");
            IOUtils.closeQuietly((Writer)this.outWriter);
            this.outWriter = null;
        }
        if (this.out != null) {
            this.logger.debug("Close tcp out stream");
            IOUtils.closeQuietly((OutputStream)this.out);
            this.out = null;
        }
        if (this.in != null) {
            this.logger.debug("Close tcp in stream");
            IOUtils.closeQuietly((InputStream)this.in);
            this.in = null;
        }
        if (this.socket != null) {
            this.logger.debug("Close socket");
            IOUtils.closeQuietly((Socket)this.socket);
            this.socket = null;
        }
        this.logger.debug("Disconnected");
    }

    public void startRemoteDiscovery() {
        this.sendCommand("LIST");
    }

    public void transmit(String remote, String button) {
        String buttonName;
        int timesToSend = 1;
        String[] parts = button.split(" ");
        if (parts.length > 1) {
            buttonName = parts[0];
            timesToSend = Integer.parseInt(parts[1]);
        } else {
            buttonName = button;
        }
        this.transmit(remote, buttonName, timesToSend);
    }

    public void transmit(String remote, String button, int timesToSend) {
        this.sendCommand(String.format("SEND_ONCE %s %s %s", remote, button, timesToSend - 1));
    }

    private synchronized void sendCommand(String command) {
        this.outWriter.println(command);
        this.outWriter.flush();
    }

    public synchronized void sendButtonToListeners(LIRCButtonEvent buttonEvent) {
        try {
            for (LIRCEventListener listener : this.listeners) {
                listener.buttonPressed(buttonEvent);
            }
        }
        catch (Exception e) {
            this.logger.error("Error invoking event listener", (Throwable)e);
        }
    }

    public synchronized void sendErrorToListeners(String error) {
        try {
            for (LIRCEventListener listener : this.listeners) {
                listener.errorOccured(error);
            }
        }
        catch (Exception e) {
            this.logger.error("Error invoking event listener", (Throwable)e);
        }
    }

    public synchronized void sendMessageToListeners(LIRCResponse message) {
        try {
            for (LIRCEventListener listener : this.listeners) {
                listener.messageReceived(message);
            }
        }
        catch (Exception e) {
            this.logger.error("Error invoking event listener", (Throwable)e);
        }
    }
}

