/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.thing.xml.internal;

import com.thoughtworks.xstream.converters.ConversionException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.smarthome.config.core.ConfigDescription;
import org.eclipse.smarthome.config.xml.util.NodeValue;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.type.ChannelDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupDefinition;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.eclipse.smarthome.core.thing.type.ThingType;
import org.eclipse.smarthome.core.thing.type.ThingTypeBuilder;
import org.eclipse.smarthome.core.thing.xml.internal.ChannelXmlResult;

public class ThingTypeXmlResult {
    protected ThingTypeUID thingTypeUID;
    protected List<String> supportedBridgeTypeUIDs;
    protected String label;
    protected String description;
    protected String category;
    protected boolean listed;
    protected List<String> extensibleChannelTypeIds;
    protected String representationProperty;
    protected List<ChannelXmlResult> channelTypeReferences;
    protected List<ChannelXmlResult> channelGroupTypeReferences;
    protected List<NodeValue> properties;
    protected URI configDescriptionURI;
    protected ConfigDescription configDescription;

    public ThingTypeXmlResult(ThingTypeUID thingTypeUID, List<String> supportedBridgeTypeUIDs, String label, String description, String category, boolean listed, List<String> extensibleChannelTypeIds, List<ChannelXmlResult>[] channelTypeReferenceObjects, List<NodeValue> properties, String representationProperty, Object[] configDescriptionObjects) {
        this.thingTypeUID = thingTypeUID;
        this.supportedBridgeTypeUIDs = supportedBridgeTypeUIDs;
        this.label = label;
        this.description = description;
        this.category = category;
        this.listed = listed;
        this.extensibleChannelTypeIds = extensibleChannelTypeIds;
        this.representationProperty = representationProperty;
        this.channelTypeReferences = channelTypeReferenceObjects[0];
        this.channelGroupTypeReferences = channelTypeReferenceObjects[1];
        this.properties = properties;
        this.configDescriptionURI = (URI)configDescriptionObjects[0];
        this.configDescription = (ConfigDescription)configDescriptionObjects[1];
    }

    public ConfigDescription getConfigDescription() {
        return this.configDescription;
    }

    protected List<ChannelDefinition> toChannelDefinitions(List<ChannelXmlResult> channelTypeReferences) throws ConversionException {
        ArrayList<ChannelDefinition> channelTypeDefinitions = null;
        if (channelTypeReferences != null && channelTypeReferences.size() > 0) {
            channelTypeDefinitions = new ArrayList<ChannelDefinition>(channelTypeReferences.size());
            for (ChannelXmlResult channelTypeReference : channelTypeReferences) {
                channelTypeDefinitions.add(channelTypeReference.toChannelDefinition(this.thingTypeUID.getBindingId()));
            }
        }
        return channelTypeDefinitions;
    }

    protected List<ChannelGroupDefinition> toChannelGroupDefinitions(List<ChannelXmlResult> channelGroupTypeReferences) throws ConversionException {
        ArrayList<ChannelGroupDefinition> channelGroupTypeDefinitions = null;
        if (channelGroupTypeReferences != null && channelGroupTypeReferences.size() > 0) {
            channelGroupTypeDefinitions = new ArrayList<ChannelGroupDefinition>(channelGroupTypeReferences.size());
            for (ChannelXmlResult channelGroupTypeReference : channelGroupTypeReferences) {
                String id = channelGroupTypeReference.getId();
                String typeId = channelGroupTypeReference.getTypeId();
                String typeUID = String.format("%s:%s", this.thingTypeUID.getBindingId(), typeId);
                ChannelGroupDefinition channelGroupDefinition = new ChannelGroupDefinition(id, new ChannelGroupTypeUID(typeUID), channelGroupTypeReference.getLabel(), channelGroupTypeReference.getDescription());
                channelGroupTypeDefinitions.add(channelGroupDefinition);
            }
        }
        return channelGroupTypeDefinitions;
    }

    protected Map<String, String> toPropertiesMap() {
        if (this.properties == null) {
            return null;
        }
        HashMap<String, String> propertiesMap = new HashMap<String, String>();
        for (NodeValue property : this.properties) {
            propertiesMap.put((String)property.getAttributes().get("name"), (String)property.getValue());
        }
        return propertiesMap;
    }

    ThingTypeBuilder getBuilder() {
        return ThingTypeBuilder.instance((ThingTypeUID)this.thingTypeUID, (String)this.label).withSupportedBridgeTypeUIDs(this.supportedBridgeTypeUIDs).withDescription(this.description).withCategory(this.category).isListed(this.listed).withRepresentationProperty(this.representationProperty).withChannelDefinitions(this.toChannelDefinitions(this.channelTypeReferences)).withChannelGroupDefinitions(this.toChannelGroupDefinitions(this.channelGroupTypeReferences)).withProperties(this.toPropertiesMap()).withConfigDescriptionURI(this.configDescriptionURI).withExtensibleChannelTypeIds(this.extensibleChannelTypeIds);
    }

    public ThingType toThingType() throws ConversionException {
        return this.getBuilder().build();
    }

    public String toString() {
        return "ThingTypeXmlResult [thingTypeUID=" + this.thingTypeUID + ", supportedBridgeTypeUIDs=" + this.supportedBridgeTypeUIDs + ", label=" + this.label + ", description=" + this.description + ",  category=" + this.category + ", listed=" + this.listed + ", representationProperty=" + this.representationProperty + ", channelTypeReferences=" + this.channelTypeReferences + ", channelGroupTypeReferences=" + this.channelGroupTypeReferences + ", extensibelChannelTypeIds=" + this.extensibleChannelTypeIds + ", properties=" + this.properties + ", configDescriptionURI=" + this.configDescriptionURI + ", configDescription=" + this.configDescription + "]";
    }
}

