/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.common;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueingThreadPoolExecutor
extends ThreadPoolExecutor {
    private final Logger logger = LoggerFactory.getLogger(QueueingThreadPoolExecutor.class);
    static final int CORE_THREAD_POOL_SIZE = 1;
    private final BlockingQueue<Runnable> taskQueue = new LinkedTransferQueue<Runnable>();
    private volatile Thread queueThread;
    private final ReadWriteLock queueThreadLock = new ReentrantReadWriteLock(true);
    private final Object semaphore = new Object();
    private final String threadPoolName;

    protected QueueingThreadPoolExecutor(String name, int threadPoolSize) {
        this(name, new CommonThreadFactory(name), threadPoolSize, new QueueingRejectionHandler());
    }

    private QueueingThreadPoolExecutor(String threadPoolName, ThreadFactory threadFactory, int threadPoolSize, RejectedExecutionHandler rejectionHandler) {
        super(1, threadPoolSize, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory, rejectionHandler);
        if (threadPoolName == null || threadPoolName.trim().isEmpty()) {
            throw new IllegalArgumentException("A thread pool name must be provided!");
        }
        this.threadPoolName = threadPoolName;
        this.allowCoreThreadTimeOut(true);
    }

    public static QueueingThreadPoolExecutor createInstance(String name, int threadPoolSize) {
        return new QueueingThreadPoolExecutor(name, threadPoolSize);
    }

    protected void addToQueue(Runnable runnable) {
        block7: {
            try {
                this.queueThreadLock.readLock().lock();
                this.taskQueue.add(runnable);
                if (this.queueThread != null && this.queueThread.isAlive()) break block7;
                try {
                    this.queueThreadLock.readLock().unlock();
                    this.queueThreadLock.writeLock().lock();
                    if (this.queueThread == null || !this.queueThread.isAlive()) {
                        this.logger.trace("Thread pool '{}' exhausted, queueing tasks now.", (Object)this.threadPoolName);
                        this.queueThread = this.createNewQueueThread();
                        this.queueThread.start();
                    }
                }
                finally {
                    this.queueThreadLock.writeLock().unlock();
                    this.queueThreadLock.readLock().lock();
                }
            }
            finally {
                this.queueThreadLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        Object object = this.semaphore;
        synchronized (object) {
            this.semaphore.notify();
        }
    }

    @Override
    public void setRejectedExecutionHandler(RejectedExecutionHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockingQueue<Runnable> getQueue() {
        return this.taskQueue;
    }

    @Override
    public void execute(Runnable command) {
        if (this.taskQueue.isEmpty()) {
            super.execute(command);
        } else {
            if (command == null) {
                throw new IllegalArgumentException("Command can not be null.");
            }
            if (!this.isShutdown()) {
                this.addToQueue(command);
            }
        }
    }

    private Thread createNewQueueThread() {
        Thread thread = this.getThreadFactory().newThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                QueueingThreadPoolExecutor tpe = QueueingThreadPoolExecutor.this;
                Consumer<Runnable> parentExecute = arg_0 -> QueueingThreadPoolExecutor.access$0(QueueingThreadPoolExecutor.this, arg_0);
                while (true) {
                    if (tpe.getActiveCount() < tpe.getMaximumPoolSize()) {
                        try {
                            Runnable runnable = (Runnable)QueueingThreadPoolExecutor.this.taskQueue.poll(2L, TimeUnit.SECONDS);
                            if (runnable != null) {
                                QueueingThreadPoolExecutor.this.logger.trace("Executing queued task of thread pool '{}'.", (Object)QueueingThreadPoolExecutor.this.threadPoolName);
                                parentExecute.accept(runnable);
                                continue;
                            }
                            try {
                                QueueingThreadPoolExecutor.this.queueThreadLock.writeLock().lock();
                                if (!QueueingThreadPoolExecutor.this.taskQueue.isEmpty()) continue;
                                QueueingThreadPoolExecutor.this.queueThread = null;
                                break;
                            }
                            finally {
                                QueueingThreadPoolExecutor.this.queueThreadLock.writeLock().unlock();
                            }
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    try {
                        Object object = QueueingThreadPoolExecutor.this.semaphore;
                        synchronized (object) {
                            QueueingThreadPoolExecutor.this.semaphore.wait(1000L);
                            continue;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                QueueingThreadPoolExecutor.this.logger.trace("Queue for thread pool '{}' fully processed - terminating queue thread.", (Object)QueueingThreadPoolExecutor.this.threadPoolName);
            }
        });
        thread.setName(String.valueOf(this.threadPoolName) + "-queue");
        return thread;
    }

    static /* synthetic */ void access$0(QueueingThreadPoolExecutor queueingThreadPoolExecutor, Runnable runnable) {
        super.execute(runnable);
    }

    private static class CommonThreadFactory
    implements ThreadFactory {
        protected final ThreadGroup group;
        protected final AtomicInteger threadNumber = new AtomicInteger(1);
        protected final String name;

        public CommonThreadFactory(String name) {
            this.name = name;
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, String.valueOf(this.name) + "-" + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private static class QueueingRejectionHandler
    extends ThreadPoolExecutor.DiscardPolicy {
        private QueueingRejectionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            if (!threadPoolExecutor.isShutdown()) {
                QueueingThreadPoolExecutor queueingThreadPoolExecutor = (QueueingThreadPoolExecutor)threadPoolExecutor;
                queueingThreadPoolExecutor.addToQueue(runnable);
            }
        }
    }
}

