/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.events;

import java.io.Closeable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.core.common.SafeCaller;
import org.eclipse.smarthome.core.events.EventFactory;
import org.eclipse.smarthome.core.events.EventSubscriber;
import org.eclipse.smarthome.core.internal.events.EventHandler;
import org.osgi.service.event.Event;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ThreadedEventHandler
implements Closeable {
    private final Logger logger = LoggerFactory.getLogger(ThreadedEventHandler.class);
    private final Thread thread;
    private final Event notifyEvent = new Event("notify", Collections.emptyMap());
    private final BlockingQueue<Event> queue = new LinkedBlockingQueue<Event>();
    private final AtomicBoolean running = new AtomicBoolean(true);

    ThreadedEventHandler(Map<String, Set<EventSubscriber>> typedEventSubscribers, Map<String, EventFactory> typedEventFactories, SafeCaller safeCaller) {
        this.thread = new Thread(() -> {
            EventHandler worker = new EventHandler(typedEventSubscribers, typedEventFactories, safeCaller);
            while (this.running.get()) {
                try {
                    Event event = this.queue.poll(1L, TimeUnit.HOURS);
                    if (event == null) {
                        this.logger.debug("Hey, you have really very few events.");
                        continue;
                    }
                    if (event == this.notifyEvent) continue;
                    worker.handleEvent(event);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                catch (RuntimeException ex) {
                    this.logger.error("Error on event handling.", (Throwable)ex);
                }
            }
        }, "ESH-OSGiEventManager");
    }

    void open() {
        this.thread.start();
    }

    @Override
    public void close() {
        this.running.set(false);
        this.queue.add(this.notifyEvent);
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    void handleEvent(Event event) {
        this.queue.add(event);
    }
}

