/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.internal.types;

import java.math.BigDecimal;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.types.StateDescription;
import org.eclipse.smarthome.core.types.StateDescriptionFragment;
import org.eclipse.smarthome.core.types.StateOption;

public class StateDescriptionFragmentImpl
implements StateDescriptionFragment {
    private @Nullable BigDecimal minimum;
    private @Nullable BigDecimal maximum;
    private @Nullable BigDecimal step;
    private @Nullable String pattern;
    private @Nullable Boolean readOnly;
    private @Nullable List<StateOption> options;

    public StateDescriptionFragmentImpl() {
    }

    public StateDescriptionFragmentImpl(StateDescription legacy) {
        this.minimum = legacy.getMinimum();
        this.maximum = legacy.getMaximum();
        this.step = legacy.getStep();
        this.pattern = legacy.getPattern();
        this.readOnly = legacy.isReadOnly();
        if (legacy.getOptions() != null && !legacy.getOptions().isEmpty()) {
            this.options = legacy.getOptions();
        }
    }

    public StateDescriptionFragmentImpl(@NonNull StateDescriptionFragmentImpl source) {
        this.minimum = source.getMinimum();
        this.maximum = source.getMaximum();
        this.step = source.getStep();
        this.pattern = source.getPattern();
        this.readOnly = source.isReadOnly();
        this.options = source.getOptions();
    }

    @Override
    public BigDecimal getMinimum() {
        return this.minimum;
    }

    public void setMinimum(BigDecimal minimum) {
        this.minimum = minimum;
    }

    @Override
    public BigDecimal getMaximum() {
        return this.maximum;
    }

    public void setMaximum(BigDecimal maximum) {
        this.maximum = maximum;
    }

    @Override
    public BigDecimal getStep() {
        return this.step;
    }

    public void setStep(BigDecimal step) {
        this.step = step;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public List<StateOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<StateOption> options) {
        this.options = options;
    }

    @Override
    public @Nullable StateDescription toStateDescription() {
        if (this.minimum == null && this.maximum == null && this.step == null && this.readOnly == null && this.pattern == null && this.options == null) {
            return null;
        }
        Boolean ro = this.readOnly;
        return new StateDescription(this.minimum, this.maximum, this.step, this.pattern, ro == null ? false : ro, this.options);
    }

    public StateDescriptionFragment merge(StateDescriptionFragment fragment) {
        if (this.minimum == null) {
            this.minimum = fragment.getMinimum();
        }
        if (this.maximum == null) {
            this.maximum = fragment.getMaximum();
        }
        if (this.step == null) {
            this.step = fragment.getStep();
        }
        if (this.pattern == null) {
            this.pattern = fragment.getPattern();
        }
        if (this.readOnly == null) {
            this.readOnly = fragment.isReadOnly();
        }
        if (this.options == null) {
            this.options = fragment.getOptions();
        }
        return this;
    }
}

