/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.items.dto;

import java.util.ArrayList;
import java.util.List;
import javax.measure.Quantity;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.internal.items.GroupFunctionHelper;
import org.eclipse.smarthome.core.items.GroupFunction;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemBuilder;
import org.eclipse.smarthome.core.items.ItemBuilderFactory;
import org.eclipse.smarthome.core.items.dto.GroupFunctionDTO;
import org.eclipse.smarthome.core.items.dto.GroupItemDTO;
import org.eclipse.smarthome.core.items.dto.ItemDTO;
import org.eclipse.smarthome.core.library.items.NumberItem;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.TypeParser;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class ItemDTOMapper {
    private static final GroupFunctionHelper GROUP_FUNCTION_HELPER = new GroupFunctionHelper();

    public static @Nullable Item map(ItemDTO itemDTO, ItemBuilderFactory itemBuilderFactory) {
        if (itemDTO == null) {
            throw new IllegalArgumentException("The argument 'itemDTO' must no be null.");
        }
        if (itemBuilderFactory == null) {
            throw new IllegalArgumentException("The argument 'itemBuilderFactory' must no be null.");
        }
        if (itemDTO.type != null) {
            ItemBuilder builder = itemBuilderFactory.newItemBuilder(itemDTO.type, itemDTO.name);
            if (itemDTO instanceof GroupItemDTO && "Group".equals(itemDTO.type)) {
                GroupItemDTO groupItemDTO = (GroupItemDTO)itemDTO;
                Item baseItem = null;
                if (!StringUtils.isEmpty((String)groupItemDTO.groupType)) {
                    baseItem = itemBuilderFactory.newItemBuilder(groupItemDTO.groupType, itemDTO.name).build();
                    builder.withBaseItem(baseItem);
                }
                GroupFunction function = new GroupFunction.Equality();
                if (groupItemDTO.function != null) {
                    function = ItemDTOMapper.mapFunction(baseItem, groupItemDTO.function);
                }
                builder.withGroupFunction(function);
            }
            builder.withLabel(itemDTO.label);
            builder.withCategory(itemDTO.category);
            builder.withGroups(itemDTO.groupNames);
            builder.withTags(itemDTO.tags);
            try {
                return builder.build();
            }
            catch (IllegalStateException illegalStateException) {
                return null;
            }
        }
        return null;
    }

    public static GroupFunction mapFunction(@Nullable Item baseItem, GroupFunctionDTO function) {
        List<State> args = ItemDTOMapper.parseStates(baseItem, function.params);
        return GROUP_FUNCTION_HELPER.createGroupFunction(function, args, ItemDTOMapper.getDimension(baseItem));
    }

    private static @Nullable Class<? extends Quantity<?>> getDimension(@Nullable Item baseItem) {
        if (baseItem instanceof NumberItem) {
            return ((NumberItem)baseItem).getDimension();
        }
        return null;
    }

    private static List<State> parseStates(@Nullable Item baseItem, String @Nullable [] params) {
        ArrayList<State> states = new ArrayList<State>();
        if (params == null || baseItem == null) {
            return states;
        }
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            State state = TypeParser.parseState(baseItem.getAcceptedDataTypes(), param);
            if (state == null) {
                LoggerFactory.getLogger(ItemDTOMapper.class).warn("State '{}' is not valid for a group item with base type '{}'", new Object[]{param, baseItem.getType()});
                states.clear();
                break;
            }
            states.add(state);
            ++n2;
        }
        return states;
    }

    public static ItemDTO map(Item item) {
        ItemDTO itemDTO = item instanceof GroupItem ? new GroupItemDTO() : new ItemDTO();
        ItemDTOMapper.fillProperties(itemDTO, item);
        return itemDTO;
    }

    private static void fillProperties(ItemDTO itemDTO, Item item) {
        if (item instanceof GroupItem) {
            GroupItem groupItem = (GroupItem)item;
            GroupItemDTO groupItemDTO = (GroupItemDTO)itemDTO;
            if (groupItem.getBaseItem() != null) {
                groupItemDTO.groupType = groupItem.getBaseItem().getType();
                groupItemDTO.function = ItemDTOMapper.mapFunction(groupItem.getFunction());
            }
        }
        itemDTO.name = item.getName();
        itemDTO.type = item.getType();
        itemDTO.label = item.getLabel();
        itemDTO.tags = item.getTags();
        itemDTO.category = item.getCategory();
        itemDTO.groupNames = item.getGroupNames();
    }

    public static @Nullable GroupFunctionDTO mapFunction(@Nullable GroupFunction function) {
        if (function == null) {
            return null;
        }
        GroupFunctionDTO dto = new GroupFunctionDTO();
        dto.name = function.getClass().getSimpleName().toUpperCase();
        ArrayList<String> params = new ArrayList<String>();
        State[] stateArray = function.getParameters();
        int n = stateArray.length;
        int n2 = 0;
        while (n2 < n) {
            State param = stateArray[n2];
            params.add(param.toString());
            ++n2;
        }
        if (!params.isEmpty()) {
            dto.params = params.toArray(new String[params.size()]);
        }
        return dto;
    }
}

