/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.types;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.ComplexType;
import org.eclipse.smarthome.core.types.PrimitiveType;
import org.eclipse.smarthome.core.types.State;

@NonNullByDefault
public class HSBType
extends PercentType
implements ComplexType,
State,
Command {
    private static final long serialVersionUID = 322902950356613226L;
    public static final String KEY_HUE = "h";
    public static final String KEY_SATURATION = "s";
    public static final String KEY_BRIGHTNESS = "b";
    public static final HSBType BLACK = new HSBType("0,0,0");
    public static final HSBType WHITE = new HSBType("0,0,100");
    public static final HSBType RED = new HSBType("0,100,100");
    public static final HSBType GREEN = new HSBType("120,100,100");
    public static final HSBType BLUE = new HSBType("240,100,100");
    private static float[][] Xy2Rgb = new float[][]{{3.2406f, -1.5372f, -0.4986f}, {-0.9689f, 1.8758f, 0.0415f}, {0.0557f, -0.204f, 1.057f}};
    private static float[][] Rgb2Xy = new float[][]{{0.4124f, 0.3576f, 0.1805f}, {0.2126f, 0.7152f, 0.0722f}, {0.0193f, 0.1192f, 0.9505f}};
    protected BigDecimal hue;
    protected BigDecimal saturation;

    public HSBType() {
        this("0,0,0");
    }

    public HSBType(DecimalType h, PercentType s, PercentType b) {
        this.hue = h.toBigDecimal();
        this.saturation = s.toBigDecimal();
        this.value = b.toBigDecimal();
        this.validateValue(this.hue, this.saturation, this.value);
    }

    public HSBType(String value) {
        List constituents = Arrays.stream(value.split(",")).map(in -> in.trim()).collect(Collectors.toList());
        if (constituents.size() != 3) {
            throw new IllegalArgumentException(String.valueOf(value) + " is not a valid HSBType syntax");
        }
        this.hue = new BigDecimal((String)constituents.get(0));
        this.saturation = new BigDecimal((String)constituents.get(1));
        this.value = new BigDecimal((String)constituents.get(2));
        this.validateValue(this.hue, this.saturation, this.value);
    }

    private void validateValue(BigDecimal hue, BigDecimal saturation, BigDecimal value) {
        if (BigDecimal.ZERO.compareTo(hue) > 0 || BigDecimal.valueOf(360L).compareTo(hue) <= 0) {
            throw new IllegalArgumentException("Hue must be between 0 and 360");
        }
        if (BigDecimal.ZERO.compareTo(saturation) > 0 || BigDecimal.valueOf(100L).compareTo(saturation) < 0) {
            throw new IllegalArgumentException("Saturation must be between 0 and 100");
        }
        if (BigDecimal.ZERO.compareTo(value) > 0 || BigDecimal.valueOf(100L).compareTo(value) < 0) {
            throw new IllegalArgumentException("Brightness must be between 0 and 100");
        }
    }

    public static HSBType valueOf(String value) {
        return new HSBType(value);
    }

    public static HSBType fromRGB(int r, int g, int b) {
        float tmpHue;
        int min;
        int max;
        int n = max = r > g ? r : g;
        if (b > max) {
            max = b;
        }
        int n2 = min = r < g ? r : g;
        if (b < min) {
            min = b;
        }
        float tmpBrightness = (float)max / 2.55f;
        float tmpSaturation = (max != 0 ? (float)(max - min) / (float)max : 0.0f) * 100.0f;
        if (tmpSaturation == 0.0f) {
            tmpHue = 0.0f;
        } else {
            float red = (float)(max - r) / (float)(max - min);
            float green = (float)(max - g) / (float)(max - min);
            float blue = (float)(max - b) / (float)(max - min);
            tmpHue = r == max ? blue - green : (g == max ? 2.0f + red - blue : 4.0f + green - red);
            if ((tmpHue = tmpHue / 6.0f * 360.0f) < 0.0f) {
                tmpHue += 360.0f;
            }
        }
        return new HSBType(new DecimalType((int)tmpHue), new PercentType((int)tmpSaturation), new PercentType((int)tmpBrightness));
    }

    public static HSBType fromXY(float x, float y) {
        float max;
        float Yo = 1.0f;
        float X = Yo / y * x;
        float Z = Yo / y * (1.0f - x - y);
        float r = X * Xy2Rgb[0][0] + Yo * Xy2Rgb[0][1] + Z * Xy2Rgb[0][2];
        float g = X * Xy2Rgb[1][0] + Yo * Xy2Rgb[1][1] + Z * Xy2Rgb[1][2];
        float b = X * Xy2Rgb[2][0] + Yo * Xy2Rgb[2][1] + Z * Xy2Rgb[2][2];
        float f = max = r > g ? r : g;
        if (b > max) {
            max = b;
        }
        r = HSBType.gammaCompress(r / max);
        g = HSBType.gammaCompress(g / max);
        b = HSBType.gammaCompress(b / max);
        return HSBType.fromRGB((int)(r * 255.0f + 0.5f), (int)(g * 255.0f + 0.5f), (int)(b * 255.0f + 0.5f));
    }

    @Override
    public SortedMap<String, PrimitiveType> getConstituents() {
        TreeMap<String, PrimitiveType> map = new TreeMap<String, PrimitiveType>();
        map.put(KEY_HUE, this.getHue());
        map.put(KEY_SATURATION, this.getSaturation());
        map.put(KEY_BRIGHTNESS, this.getBrightness());
        return map;
    }

    public DecimalType getHue() {
        return new DecimalType(this.hue);
    }

    public PercentType getSaturation() {
        return new PercentType(this.saturation);
    }

    public PercentType getBrightness() {
        return new PercentType(this.value);
    }

    public PercentType getRed() {
        return this.toRGB()[0];
    }

    public PercentType getGreen() {
        return this.toRGB()[1];
    }

    public PercentType getBlue() {
        return this.toRGB()[2];
    }

    public int getRGB() {
        PercentType[] rgb = this.toRGB();
        return 0xFF000000 | (this.convertPercentToByte(rgb[0]) & 0xFF) << 16 | (this.convertPercentToByte(rgb[1]) & 0xFF) << 8 | (this.convertPercentToByte(rgb[2]) & 0xFF) << 0;
    }

    @Override
    public String toString() {
        return this.toFullString();
    }

    @Override
    public String toFullString() {
        return this.getHue() + "," + this.getSaturation() + "," + this.getBrightness();
    }

    @Override
    public int hashCode() {
        int tmp = 10000 * this.getHue().hashCode();
        tmp += 100 * this.getSaturation().hashCode();
        return tmp += this.getBrightness().hashCode();
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HSBType)) {
            return false;
        }
        HSBType other = (HSBType)obj;
        return this.getHue().equals(other.getHue()) && this.getSaturation().equals(other.getSaturation()) && this.getBrightness().equals(other.getBrightness());
    }

    public PercentType[] toRGB() {
        PercentType red = null;
        PercentType green = null;
        PercentType blue = null;
        BigDecimal h = this.hue.divide(BigDecimal.valueOf(100L), 10, 4);
        BigDecimal s = this.saturation.divide(BigDecimal.valueOf(100L));
        int hInt = h.multiply(BigDecimal.valueOf(5L)).divide(BigDecimal.valueOf(3L), 10, 4).intValue();
        BigDecimal f = h.multiply(BigDecimal.valueOf(5L)).divide(BigDecimal.valueOf(3L), 10, 4).remainder(BigDecimal.ONE);
        PercentType a = new PercentType(this.value.multiply(BigDecimal.ONE.subtract(s)));
        PercentType b = new PercentType(this.value.multiply(BigDecimal.ONE.subtract(s.multiply(f))));
        PercentType c = new PercentType(this.value.multiply(BigDecimal.ONE.subtract(BigDecimal.ONE.subtract(f).multiply(s))));
        switch (hInt) {
            case 0: 
            case 6: {
                red = this.getBrightness();
                green = c;
                blue = a;
                break;
            }
            case 1: {
                red = b;
                green = this.getBrightness();
                blue = a;
                break;
            }
            case 2: {
                red = a;
                green = this.getBrightness();
                blue = c;
                break;
            }
            case 3: {
                red = a;
                green = b;
                blue = this.getBrightness();
                break;
            }
            case 4: {
                red = c;
                green = a;
                blue = this.getBrightness();
                break;
            }
            case 5: {
                red = this.getBrightness();
                green = a;
                blue = b;
                break;
            }
            default: {
                throw new IllegalArgumentException("Could not convert to RGB.");
            }
        }
        return new PercentType[]{red, green, blue};
    }

    private static float gammaCompress(float c) {
        if (c < 0.0f) {
            c = 0.0f;
        } else if (c > 1.0f) {
            c = 1.0f;
        }
        return c <= 0.0031308f ? 19.92f * c : 1.055f * (float)Math.pow(c, 0.4166666567325592) - 0.055f;
    }

    private static float gammaDecompress(float c) {
        if (c < 0.0f) {
            c = 0.0f;
        } else if (c > 1.0f) {
            c = 1.0f;
        }
        return c <= 0.04045f ? c / 19.92f : (float)Math.pow((c + 0.055f) / 1.055f, 2.4f);
    }

    public PercentType[] toXY() {
        PercentType[] sRGB = new HSBType(this.getHue(), this.getSaturation(), PercentType.HUNDRED).toRGB();
        float r = HSBType.gammaDecompress(sRGB[0].floatValue() / 100.0f);
        float g = HSBType.gammaDecompress(sRGB[1].floatValue() / 100.0f);
        float b = HSBType.gammaDecompress(sRGB[2].floatValue() / 100.0f);
        float X = r * Rgb2Xy[0][0] + g * Rgb2Xy[0][1] + b * Rgb2Xy[0][2];
        float Y = r * Rgb2Xy[1][0] + g * Rgb2Xy[1][1] + b * Rgb2Xy[1][2];
        float Z = r * Rgb2Xy[2][0] + g * Rgb2Xy[2][1] + b * Rgb2Xy[2][2];
        float x = X / (X + Y + Z);
        float y = Y / (X + Y + Z);
        return new PercentType[]{new PercentType(Float.valueOf(x * 100.0f).toString()), new PercentType(Float.valueOf(y * 100.0f).toString()), new PercentType(Float.valueOf(Y * this.getBrightness().floatValue()).toString())};
    }

    private int convertPercentToByte(PercentType percent) {
        return percent.value.multiply(BigDecimal.valueOf(255L)).divide(BigDecimal.valueOf(100L), 2, 4).intValue();
    }

    @Override
    public <T extends State> @Nullable T as(@Nullable Class<T> target) {
        if (target == OnOffType.class) {
            return (T)((State)target.cast(this.getBrightness().equals(PercentType.ZERO) ? OnOffType.OFF : OnOffType.ON));
        }
        if (target == DecimalType.class) {
            return (T)((State)target.cast(new DecimalType(this.getBrightness().toBigDecimal().divide(BigDecimal.valueOf(100L), 8, RoundingMode.UP))));
        }
        if (target == PercentType.class) {
            return (T)((State)target.cast(new PercentType(this.getBrightness().toBigDecimal())));
        }
        return this.defaultConversion(target);
    }
}

