/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.core.library.types;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Set;
import javax.measure.Quantity;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.smarthome.core.items.GroupFunction;
import org.eclipse.smarthome.core.items.GroupItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.library.items.NumberItem;
import org.eclipse.smarthome.core.library.types.QuantityType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.UnDefType;

public interface QuantityTypeArithmeticGroupFunction
extends GroupFunction {

    public static class Avg
    extends DimensionalGroupFunction {
        public Avg(@NonNull Class<? extends Quantity<?>> dimension) {
            super(dimension);
        }

        @Override
        public State calculate(Set<Item> items) {
            if (items == null || items.size() <= 0) {
                return UnDefType.UNDEF;
            }
            QuantityType sum = null;
            int count = 0;
            for (Item item : items) {
                QuantityType itemState;
                if (!this.isSameDimension(item) || (itemState = item.getStateAs(QuantityType.class)) == null) continue;
                if (sum == null) {
                    sum = itemState;
                    ++count;
                    continue;
                }
                sum = sum.add(itemState);
                ++count;
            }
            if (sum != null && count > 0) {
                BigDecimal result = sum.toBigDecimal().divide(BigDecimal.valueOf(count), RoundingMode.HALF_UP);
                return new QuantityType(result, sum.getUnit());
            }
            return UnDefType.UNDEF;
        }
    }

    public static abstract class DimensionalGroupFunction
    implements GroupFunction {
        protected final Class<? extends Quantity<?>> dimension;

        public DimensionalGroupFunction(Class<? extends Quantity<?>> dimension) {
            this.dimension = dimension;
        }

        @Override
        public <T extends State> T getStateAs(Set<Item> items, Class<T> stateClass) {
            State state = this.calculate(items);
            if (stateClass.isInstance(state)) {
                return (T)((State)stateClass.cast(state));
            }
            return null;
        }

        @Override
        public State[] getParameters() {
            return new State[0];
        }

        protected boolean isSameDimension(Item item) {
            if (item instanceof GroupItem) {
                return this.isSameDimension(((GroupItem)item).getBaseItem());
            }
            return item instanceof NumberItem && this.dimension.equals(((NumberItem)item).getDimension());
        }
    }

    public static class Max
    extends DimensionalGroupFunction {
        public Max(@NonNull Class<? extends @NonNull Quantity<?>> dimension) {
            super(dimension);
        }

        @Override
        public State calculate(Set<Item> items) {
            if (items == null || items.size() <= 0) {
                return UnDefType.UNDEF;
            }
            State max = null;
            for (Item item : items) {
                QuantityType itemState;
                if (!this.isSameDimension(item) || (itemState = item.getStateAs(QuantityType.class)) == null || max != null && (!((QuantityType)max).getUnit().isCompatible(itemState.getUnit()) || ((QuantityType)max).compareTo(itemState) >= 0)) continue;
                max = itemState;
            }
            return max != null ? max : UnDefType.UNDEF;
        }
    }

    public static class Min
    extends DimensionalGroupFunction {
        public Min(@NonNull Class<? extends @NonNull Quantity<?>> dimension) {
            super(dimension);
        }

        @Override
        public State calculate(Set<Item> items) {
            if (items == null || items.size() <= 0) {
                return UnDefType.UNDEF;
            }
            State min = null;
            for (Item item : items) {
                QuantityType itemState;
                if (!this.isSameDimension(item) || (itemState = item.getStateAs(QuantityType.class)) == null || min != null && (!((QuantityType)min).getUnit().isCompatible(itemState.getUnit()) || ((QuantityType)min).compareTo(itemState) <= 0)) continue;
                min = itemState;
            }
            return min != null ? min : UnDefType.UNDEF;
        }
    }

    public static class Sum
    extends DimensionalGroupFunction {
        public Sum(@NonNull Class<? extends @NonNull Quantity<?>> dimension) {
            super(dimension);
        }

        @Override
        public State calculate(Set<Item> items) {
            if (items == null || items.size() <= 0) {
                return UnDefType.UNDEF;
            }
            State sum = null;
            for (Item item : items) {
                QuantityType itemState;
                if (!this.isSameDimension(item) || (itemState = item.getStateAs(QuantityType.class)) == null) continue;
                if (sum == null) {
                    sum = itemState;
                    continue;
                }
                if (!((QuantityType)sum).getUnit().isCompatible(itemState.getUnit())) continue;
                sum = ((QuantityType)sum).add(itemState);
            }
            return sum != null ? sum : UnDefType.UNDEF;
        }
    }
}

