/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.actions;

import java.io.IOException;
import java.math.BigDecimal;
import org.eclipse.smarthome.core.audio.AudioException;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.model.script.engine.action.ActionDoc;
import org.eclipse.smarthome.model.script.engine.action.ParamDoc;
import org.eclipse.smarthome.model.script.internal.engine.action.AudioActionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Audio {
    private static final Logger logger = LoggerFactory.getLogger(Audio.class);

    @ActionDoc(text="plays a sound from the sounds folder to the default sink")
    public static void playSound(@ParamDoc(name="filename", text="the filename with extension") String filename) {
        try {
            AudioActionService.audioManager.playFile(filename);
        }
        catch (AudioException e) {
            logger.warn("Failed playing audio file: {}", (Object)e.getMessage());
        }
    }

    @ActionDoc(text="plays a sound with the given volume from the sounds folder to the default sink")
    public static void playSound(@ParamDoc(name="filename", text="the filename with extension") String filename, @ParamDoc(name="volume", text="the volume to be used") PercentType volume) {
        try {
            AudioActionService.audioManager.playFile(filename, volume);
        }
        catch (AudioException e) {
            logger.warn("Failed playing audio file: {}", (Object)e.getMessage());
        }
    }

    @ActionDoc(text="plays a sound from the sounds folder to the given sink(s)")
    public static void playSound(@ParamDoc(name="sink", text="the id of the sink") String sink, @ParamDoc(name="filename", text="the filename with extension") String filename) {
        try {
            AudioActionService.audioManager.playFile(filename, sink);
        }
        catch (AudioException e) {
            logger.warn("Failed playing audio file: {}", (Object)e.getMessage());
        }
    }

    @ActionDoc(text="plays a sound with the given volume from the sounds folder to the given sink(s)")
    public static void playSound(@ParamDoc(name="sink", text="the id of the sink") String sink, @ParamDoc(name="filename", text="the filename with extension") String filename, @ParamDoc(name="volume", text="the volume to be used") PercentType volume) {
        try {
            AudioActionService.audioManager.playFile(filename, sink, volume);
        }
        catch (AudioException e) {
            logger.warn("Failed playing audio file: {}", (Object)e.getMessage());
        }
    }

    @ActionDoc(text="plays an audio stream from an url to the default sink")
    public static synchronized void playStream(@ParamDoc(name="url", text="the url of the audio stream") String url) {
        try {
            AudioActionService.audioManager.stream(url);
        }
        catch (AudioException e) {
            logger.warn("Failed streaming audio url: {}", (Object)e.getMessage());
        }
    }

    @ActionDoc(text="plays an audio stream from an url to the given sink(s)")
    public static synchronized void playStream(@ParamDoc(name="sink", text="the id of the sink") String sink, @ParamDoc(name="url", text="the url of the audio stream") String url) {
        try {
            AudioActionService.audioManager.stream(url, sink);
        }
        catch (AudioException e) {
            logger.warn("Failed streaming audio url: {}", (Object)e.getMessage());
        }
    }

    @ActionDoc(text="gets the master volume", returns="volume as a float in the range [0,1]")
    public static float getMasterVolume() throws IOException {
        return AudioActionService.audioManager.getVolume(null).floatValue() / 100.0f;
    }

    @ActionDoc(text="sets the master volume")
    public static void setMasterVolume(@ParamDoc(name="volume", text="volume in the range [0,1]") float volume) throws IOException {
        if (volume < 0.0f || volume > 1.0f) {
            throw new IllegalArgumentException("Volume value must be in the range [0,1]!");
        }
        Audio.setMasterVolume(new PercentType(new BigDecimal(volume * 100.0f)));
    }

    @ActionDoc(text="sets the master volume")
    public static void setMasterVolume(@ParamDoc(name="percent") PercentType percent) throws IOException {
        AudioActionService.audioManager.setVolume(percent, null);
    }

    @ActionDoc(text="increases the master volume")
    public static void increaseMasterVolume(@ParamDoc(name="percent") float percent) throws IOException {
        float newVolume;
        if (percent <= 0.0f || percent > 100.0f) {
            throw new IllegalArgumentException("Percent must be in the range (0,100]!");
        }
        Float volume = Float.valueOf(Audio.getMasterVolume());
        if (volume.floatValue() == 0.0f) {
            volume = Float.valueOf(0.001f);
        }
        if ((double)((newVolume = volume.floatValue() * (1.0f + percent / 100.0f)) - volume.floatValue()) < 0.01) {
            newVolume = (float)((double)newVolume + 0.01);
        }
        if (newVolume > 1.0f) {
            newVolume = 1.0f;
        }
        Audio.setMasterVolume(newVolume);
    }

    @ActionDoc(text="decreases the master volume")
    public static void decreaseMasterVolume(@ParamDoc(name="percent") float percent) throws IOException {
        if (percent <= 0.0f || percent > 100.0f) {
            throw new IllegalArgumentException("Percent must be in the range (0,100]!");
        }
        float volume = Audio.getMasterVolume();
        float newVolume = volume * (1.0f - percent / 100.0f);
        if (newVolume > 0.0f && (double)(volume - newVolume) < 0.01) {
            newVolume = (float)((double)newVolume - 0.01);
        }
        if (newVolume < 0.0f) {
            newVolume = 0.0f;
        }
        Audio.setMasterVolume(newVolume);
    }
}

