/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.explorer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.explorer.internal.Activator;
import org.eclipse.sphinx.emf.explorer.internal.messages.Messages;
import org.eclipse.sphinx.platform.util.StatusUtil;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;

public class BasicDropAdapterAssistant
extends CommonDropAdapterAssistant {
    public static final int DND_OPERATIONS_DROP_COPY_DROP_MOVE_DROP_LINK = 7;
    public static final float DND_LOCATION_DROP_ON_FIRST = 0.5f;

    public IStatus handleDrop(CommonDropAdapter dropAdapter, DropTargetEvent event, Object target) {
        TransferData transferType = dropAdapter.getCurrentTransfer();
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            switch (dropAdapter.getCurrentOperation()) {
                case 2: {
                    this.handleDropMove(target, dropAdapter, event);
                    break;
                }
                case 1: {
                    this.handleDropCopy(target, dropAdapter, event);
                    break;
                }
            }
            return Status.OK_STATUS;
        }
        return new Status(4, Activator.getPlugin().getBundle().getSymbolicName(), Messages.error_transferTypeNotSupported);
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
            List<EObject> selectedEObjects = this.getSelectedEObjects();
            if (!(target instanceof EObject) && !(target instanceof IWrapperItemProvider)) {
                return StatusUtil.createStatus((int)1, (int)0, (String)Messages.info_targetObjectType, (String)Activator.getPlugin().getSymbolicName(), (Throwable)new RuntimeException());
            }
            TransactionalEditingDomain editingDomain = this.getEditingDomain(target);
            if (editingDomain == null) {
                return StatusUtil.createStatus((int)4, (int)0, (String)Messages.error_targetNoEditingDomain, (String)Activator.getPlugin().getBundle().getSymbolicName(), (Throwable)new RuntimeException());
            }
            Object unwrappedTarget = AdapterFactoryEditingDomain.unwrap((Object)target);
            Command command = DragAndDropCommand.create((EditingDomain)editingDomain, (Object)unwrappedTarget, (float)this.getDefaultDragAndDropLocation(), (int)this.getDefaultDragAndDropOperations(), (int)operation, selectedEObjects);
            if (command.canExecute()) {
                return Status.OK_STATUS;
            }
            if (!command.canExecute() && operation == 0) {
                Command command2 = DragAndDropCommand.create((EditingDomain)editingDomain, (Object)unwrappedTarget, (float)this.getDefaultDragAndDropLocation(), (int)this.getDefaultDragAndDropOperations(), (int)this.getDefaultDragAndDropOperations(), selectedEObjects);
                if (command2.canExecute()) {
                    return Status.OK_STATUS;
                }
            } else {
                return StatusUtil.createStatus((int)1, (int)0, (String)Messages.info_dropCommandCannotExecute, (String)Activator.getPlugin().getBundle().getSymbolicName(), (Throwable)new RuntimeException());
            }
        }
        return StatusUtil.createStatus((int)4, (int)0, (String)Messages.error_transferTypeNotSupported, (String)Activator.getPlugin().getBundle().getSymbolicName(), (Throwable)new RuntimeException());
    }

    protected IStatus handleDropCopy(Object target, CommonDropAdapter dropAdapter, DropTargetEvent event) {
        TransactionalEditingDomain domain = this.getEditingDomain(target);
        if (domain == null) {
            return StatusUtil.createStatus((int)4, (int)0, (String)Messages.error_targetNoEditingDomain, (String)Activator.getPlugin().getBundle().getSymbolicName(), (Throwable)new RuntimeException());
        }
        List<EObject> selectedEObjects = this.getSelectedEObjects();
        Command command = DragAndDropCommand.create((EditingDomain)domain, (Object)target, (float)this.getDefaultDragAndDropLocation(), (int)event.operations, (int)1, selectedEObjects);
        return this.promptAndExecuteDropCopy(domain, target, command, Messages.label_confirmCopy, Messages.label_OKToCopy);
    }

    protected IStatus handleDropMove(Object target, CommonDropAdapter dropAdapter, DropTargetEvent event) {
        TransactionalEditingDomain domain = this.getEditingDomain(target);
        if (domain == null) {
            return StatusUtil.createStatus((int)4, (int)0, (String)Messages.error_targetNoEditingDomain, (String)Activator.getPlugin().getBundle().getSymbolicName(), (Throwable)new RuntimeException());
        }
        List<EObject> selectedEObjects = this.getSelectedEObjects();
        Object unwrappedTarget = AdapterFactoryEditingDomain.unwrap((Object)target);
        Command command = DragAndDropCommand.create((EditingDomain)domain, (Object)unwrappedTarget, (float)this.getDefaultDragAndDropLocation(), (int)event.operations, (int)2, selectedEObjects);
        return this.promptAndExecuteDropMove(domain, target, command, Messages.label_confirmMove, Messages.label_OKToMove);
    }

    protected float getDefaultDragAndDropLocation() {
        return 0.5f;
    }

    protected int getDefaultDragAndDropOperations() {
        return 7;
    }

    protected List<Object> getSelection() {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            return ((IStructuredSelection)selection).toList();
        }
        return Collections.emptyList();
    }

    protected List<EObject> getSelectedEObjects() {
        ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
        if (selection instanceof IStructuredSelection) {
            return this.getSelectedEObjects((IStructuredSelection)selection);
        }
        return Collections.emptyList();
    }

    protected List<EObject> getSelectedEObjects(IStructuredSelection selection) {
        ArrayList<EObject> selectedEObject = new ArrayList<EObject>();
        for (Object o : selection) {
            IAdaptable a;
            EObject eo;
            if (o instanceof EObject) {
                selectedEObject.add((EObject)o);
                continue;
            }
            if (o instanceof IWrapperItemProvider) {
                Object obj = ((IWrapperItemProvider)o).getValue();
                if (!(obj instanceof EObject)) continue;
                selectedEObject.add((EObject)obj);
                continue;
            }
            if (!(o instanceof IAdaptable) || (eo = (EObject)(a = (IAdaptable)o).getAdapter(EObject.class)) == null) continue;
            selectedEObject.add(eo);
        }
        return selectedEObject;
    }

    protected Object getParent(Object object) {
        return this.getEditingDomain(object).getParent(object);
    }

    protected Collection<?> getChildren(Object object) {
        return this.getEditingDomain(object).getChildren(object);
    }

    protected TransactionalEditingDomain getEditingDomain(Object target) {
        return TransactionUtil.getEditingDomain((Object)(target instanceof IWrapperItemProvider ? ((IWrapperItemProvider)target).getValue() : target));
    }

    protected IStatus promptAndExecuteDropCopy(TransactionalEditingDomain domain, Object target, Command command, String title, String msg) {
        return this.promptAndExecute(domain, command, title, msg);
    }

    protected IStatus promptAndExecuteDropMove(TransactionalEditingDomain domain, Object target, Command command, String title, String msg) {
        if (command instanceof DragAndDropCommand) {
            IWrapperItemProvider wrapedTarget;
            Collection<Object> wrapedChildren;
            DragAndDropCommand dndCommand = (DragAndDropCommand)command;
            Object parent = this.getParent(dndCommand.getOwner());
            Collection<?> children = this.getChildren(parent);
            if (children.containsAll(dndCommand.getCollection())) {
                return this.doExecute((EditingDomain)domain, (Command)dndCommand);
            }
            if (target instanceof IWrapperItemProvider && (wrapedChildren = this.getChildren(wrapedTarget = (IWrapperItemProvider)target)).containsAll(this.getSelection())) {
                return this.promptAndExecute(domain, command, Messages.label_confirmDuplicate, Messages.label_OKToHaveDuplicate);
            }
        }
        return this.promptAndExecute(domain, command, title, msg);
    }

    protected IStatus promptAndExecute(TransactionalEditingDomain domain, Command command, String title, String msg) {
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (MessageDialog.openConfirm((Shell)parentShell, (String)title, (String)msg)) {
            return this.doExecute((EditingDomain)domain, command);
        }
        return Status.CANCEL_STATUS;
    }

    protected IStatus doExecute(EditingDomain domain, Command command) {
        if (command.canExecute()) {
            domain.getCommandStack().execute(command);
        } else {
            command.dispose();
        }
        return Status.OK_STATUS;
    }
}

