/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.metamodelgen.operations;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.sphinx.emf.metamodelgen.internal.Activator;
import org.eclipse.sphinx.emf.metamodelgen.operations.IGenerateFromEcoreOperation;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.operations.AbstractWorkspaceOperation;
import org.eclipse.sphinx.platform.util.StatusUtil;

public abstract class AbstractGenerateFromEcoreOperation
extends AbstractWorkspaceOperation
implements IGenerateFromEcoreOperation {
    protected IFile ecoreFile;

    public AbstractGenerateFromEcoreOperation(String label) {
        super(label);
    }

    public AbstractGenerateFromEcoreOperation(String label, IFile ecoreFile) {
        super(label);
        this.ecoreFile = ecoreFile;
    }

    public ISchedulingRule getRule() {
        return this.ecoreFile != null ? this.ecoreFile.getProject() : null;
    }

    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        EPackage ecoreModel = this.loadEcoreModel();
        progress.worked(30);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        this.generate(ecoreModel, (IProgressMonitor)progress.newChild(70));
    }

    @Override
    public abstract void generate(EPackage var1, IProgressMonitor var2) throws CoreException, OperationCanceledException;

    protected EPackage loadEcoreModel() throws CoreException {
        Assert.isNotNull((Object)this.ecoreFile);
        try {
            URI ecoreFileURI = EcorePlatformUtil.createURI((IPath)this.ecoreFile.getFullPath());
            URI ecoreModelURI = ecoreFileURI.appendFragment("/");
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            return (EPackage)resourceSet.getEObject(ecoreModelURI, true);
        }
        catch (RuntimeException ex) {
            IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
            throw new CoreException(status);
        }
    }

    protected void saveEcoreModel(URI ecoreFileURI, EPackage ecoreModel) throws CoreException {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.createResource(ecoreFileURI);
            if (resource == null) {
                throw new IOException("Unable to create resource for '" + ecoreFileURI + "'");
            }
            resource.getContents().add((Object)ecoreModel);
            resource.save(null);
        }
        catch (IOException ex) {
            IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
            throw new CoreException(status);
        }
    }
}

