/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.examples.hummingbird20.editors.nebula.factory;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.xviewer.edit.CellEditDescriptor;
import org.eclipse.nebula.widgets.xviewer.edit.XViewerConverter;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.sphinx.emf.util.WorkspaceTransactionUtil;
import org.eclipse.sphinx.examples.hummingbird20.editors.nebula.internal.Activator;
import org.eclipse.sphinx.examples.hummingbird20.instancemodel.ParameterValue;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class ParameterValuesXViewerConverter
implements XViewerConverter {
    public void setInput(Control c, CellEditDescriptor ced, Object selObject) {
        if (c instanceof Text) {
            Text textField = (Text)c;
            if (selObject instanceof ParameterValue) {
                ParameterValue parameterValue = (ParameterValue)selObject;
                if (ced.getInputField().equals("Name")) {
                    textField.setText(parameterValue.getName() != null ? parameterValue.getName() : "");
                } else if (ced.getInputField().equals("Value")) {
                    textField.setText(parameterValue.getValue() != null ? parameterValue.getValue() : "");
                }
            }
        }
    }

    public void getInput(Control c, CellEditDescriptor ced, Object selObject) {
        if (c instanceof Text) {
            Text textField = (Text)c;
            if (selObject instanceof ParameterValue) {
                ParameterValue parameterValue = (ParameterValue)selObject;
                if (ced.getInputField().equals("Name")) {
                    if (this.isPropertyValueChanged(textField.getText(), parameterValue.getName())) {
                        this.setParameterValueName(parameterValue, textField.getText());
                    }
                } else if (ced.getInputField().equals("Value") && this.isPropertyValueChanged(textField.getText(), parameterValue.getValue())) {
                    this.setParameterValueValue(parameterValue, textField.getText());
                }
            }
        }
    }

    protected boolean isPropertyValueChanged(Object newValue, Object oldValue) {
        return oldValue == null && newValue != null || oldValue != null && !oldValue.equals(newValue);
    }

    private void setParameterValueName(final ParameterValue parameterValue, final String name) {
        Assert.isNotNull((Object)parameterValue);
        try {
            TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)parameterValue);
            if (editingDomain != null) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        parameterValue.setName(name);
                    }
                };
                WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)editingDomain, (Runnable)runnable, (String)"setName");
            }
        }
        catch (ExecutionException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
    }

    private void setParameterValueValue(final ParameterValue parameterValue, final String value) {
        Assert.isNotNull((Object)parameterValue);
        try {
            TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)parameterValue);
            if (editingDomain != null) {
                Runnable runnable = new Runnable(){

                    public void run() {
                        parameterValue.setValue(value);
                    }
                };
                WorkspaceTransactionUtil.executeInWriteTransaction((TransactionalEditingDomain)editingDomain, (Runnable)runnable, (String)"setValue");
            }
        }
        catch (ExecutionException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
    }
}

