/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.wizards.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.workspace.ui.internal.Activator;
import org.eclipse.sphinx.emf.workspace.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.ui.wizards.pages.InitialModelProperties;
import org.eclipse.sphinx.platform.ui.dialogs.AbstractBrowseDialog;
import org.eclipse.sphinx.platform.ui.fields.ComboButtonField;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.fields.IFieldListener;
import org.eclipse.sphinx.platform.ui.fields.adapters.AbstractButtonAdapter;
import org.eclipse.sphinx.platform.ui.fields.adapters.IButtonAdapter;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class InitialModelCreationPage<T extends IMetaModelDescriptor>
extends WizardPage {
    private Composite container;
    private final String LAST_SELECTED_METAMODEL_KEY = String.valueOf(Activator.getPlugin().getSymbolicName()) + "last.selected.metamodel";
    private final String LAST_SELECTED_EPACKAGE_KEY = String.valueOf(Activator.getPlugin().getSymbolicName()) + "last.selected.eproject";
    private final String LAST_SELECTED_ECLASSIFIER_KEY = String.valueOf(Activator.getPlugin().getSymbolicName()) + "last.selected.eproject.eclassifier";
    protected ComboButtonField metaModelCombo;
    protected ComboButtonField ePackageCombo;
    protected ComboButtonField eClassifierCombo;
    protected List<T> supportedMetaModelDescriptors = new ArrayList<T>();
    protected List<EPackage> supportedEPackages = new ArrayList<EPackage>();
    protected List<EClassifier> supportedEClassifiers = new ArrayList<EClassifier>();
    protected InitialModelProperties<T> initialModelProperties;
    protected T baseMetaModelDescriptor;
    protected ISelection selection;

    public InitialModelCreationPage(String pageName, ISelection selection, InitialModelProperties<T> initialModelProperties, T baseMetaModelDescriptor) {
        super(pageName);
        Assert.isNotNull(initialModelProperties);
        Assert.isLegal((baseMetaModelDescriptor != MetaModelDescriptorRegistry.NO_MM ? 1 : 0) != 0);
        this.selection = selection;
        this.initialModelProperties = initialModelProperties;
        this.baseMetaModelDescriptor = baseMetaModelDescriptor;
        if (baseMetaModelDescriptor != null && baseMetaModelDescriptor.getName() != MetaModelDescriptorRegistry.ANY_MM.getName()) {
            this.setTitle(NLS.bind((String)Messages.page_newInitialModelCreation_title, (Object)baseMetaModelDescriptor.getName()));
            this.setDescription(NLS.bind((String)Messages.page_newInitialModelCreation_description, (Object)baseMetaModelDescriptor.getName()));
        } else {
            this.setTitle(Messages.page_newInitialModelCreation_defaultTitle);
            this.setDescription(NLS.bind((String)Messages.page_newInitialModelCreation_description, (Object)Messages.default_metamodelName));
        }
        this.supportedMetaModelDescriptors = this.getSupportedMetaModelDescriptors();
        int index = 0;
        while (index < this.supportedMetaModelDescriptors.size()) {
            Collection ePackages = ((IMetaModelDescriptor)this.supportedMetaModelDescriptors.get(index)).getEPackages();
            this.supportedEPackages.addAll(ePackages);
            ++index;
        }
    }

    protected List<T> getSupportedMetaModelDescriptors() {
        return MetaModelDescriptorRegistry.INSTANCE.getDescriptors(this.baseMetaModelDescriptor, true);
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginRight = 7;
        gridLayout.marginLeft = 7;
        gridLayout.horizontalSpacing = 7;
        gridLayout.verticalSpacing = 7;
        this.container.setLayout((Layout)gridLayout);
        this.createMetaModelComboButtonField(this.container);
        this.createEPackageComboButtonField(this.container);
        this.createEClassifierComboButtonField(this.container);
        this.metaModelCombo.addFieldListener((IFieldListener)new fieldListener());
        this.fillMetaModelCombo();
        this.ePackageCombo.addFieldListener((IFieldListener)new fieldListener());
        this.eClassifierCombo.addFieldListener((IFieldListener)new fieldListener());
        this.setControl((Control)this.container);
        this.setPageComplete(this.validatePage());
        this.setErrorMessage(null);
        this.setMessage(null);
    }

    protected void createMetaModelComboButtonField(Composite container) {
        MetaModelButtonAdapter metaModelAdapter = new MetaModelButtonAdapter();
        this.metaModelCombo = new ComboButtonField((IButtonAdapter)metaModelAdapter);
        this.metaModelCombo.setLabelText(Messages.combo_metaModelDescriptor_label);
        this.metaModelCombo.setButtonLabel(Messages.button_browse_label);
        this.metaModelCombo.fillIntoGrid(container, 3);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.metaModelCombo.getComboControl().setLayoutData((Object)gridData);
    }

    protected void createEPackageComboButtonField(Composite container) {
        EPackageButtonAdapter packageAdapter = new EPackageButtonAdapter();
        this.ePackageCombo = new ComboButtonField((IButtonAdapter)packageAdapter);
        this.ePackageCombo.setLabelText(Messages.combo_ePackage_label);
        this.ePackageCombo.setButtonLabel(Messages.button_browse_label);
        this.ePackageCombo.fillIntoGrid(container, 3);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.ePackageCombo.getComboControl().setLayoutData((Object)gridData);
    }

    protected void createEClassifierComboButtonField(Composite container) {
        EClassifierButtonAdapter classifierAdapter = new EClassifierButtonAdapter();
        this.eClassifierCombo = new ComboButtonField((IButtonAdapter)classifierAdapter);
        this.eClassifierCombo.setLabelText(Messages.combo_eClassifier_label);
        this.eClassifierCombo.setButtonLabel(Messages.button_browse_label);
        this.eClassifierCombo.fillIntoGrid(container, 3);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.eClassifierCombo.getComboControl().setLayoutData((Object)gridData);
    }

    protected void fillMetaModelCombo() {
        String[] items = new String[this.supportedMetaModelDescriptors.size()];
        int index = 0;
        while (index < this.supportedMetaModelDescriptors.size()) {
            items[index] = ((IMetaModelDescriptor)this.supportedMetaModelDescriptors.get(index)).getName();
            ++index;
        }
        this.metaModelCombo.setItems(items);
    }

    protected void fillEPackageCombo() {
        String[] items = new String[this.supportedEPackages.size()];
        int index = 0;
        while (index < this.supportedEPackages.size()) {
            items[index] = this.supportedEPackages.get(index).getName();
            ++index;
        }
        this.ePackageCombo.setItems(items);
    }

    protected void fillEClassifierCombo() {
        String[] items = new String[this.supportedEClassifiers.size()];
        int index = 0;
        while (index < this.supportedEClassifiers.size()) {
            items[index] = this.supportedEClassifiers.get(index).getName();
            ++index;
        }
        this.eClassifierCombo.setItems(items);
    }

    private void storeBrowserSelectionMetaModel(ComboButtonField field, T metaModelDescriptor) {
        Activator.getPlugin().getDialogSettings().put(this.LAST_SELECTED_METAMODEL_KEY, metaModelDescriptor.getIdentifier());
        this.initialModelProperties.setMetaModelDescriptor(metaModelDescriptor);
        int metaModelIndex = this.supportedMetaModelDescriptors.indexOf(metaModelDescriptor);
        Combo control = (Combo)field.getComboControl();
        control.select(metaModelIndex);
        this.setPageComplete(this.validatePage());
    }

    private void storeBrowserSelectionEPackage(ComboButtonField field, EPackage epackage) {
        Activator.getPlugin().getDialogSettings().put(this.LAST_SELECTED_EPACKAGE_KEY, epackage.getName());
        this.initialModelProperties.setRootObjectEPackage(epackage);
        int ePackageIndex = this.supportedEPackages.indexOf(epackage);
        Combo control = (Combo)field.getComboControl();
        control.select(ePackageIndex);
        this.setPageComplete(this.validatePage());
    }

    private void storeBrowserSelectionEClassifier(ComboButtonField field, EClassifier eclassifier) {
        Activator.getPlugin().getDialogSettings().put(this.LAST_SELECTED_ECLASSIFIER_KEY, eclassifier.getName());
        this.initialModelProperties.setRootObjectEClassifier(eclassifier);
        int indexEClassifier = this.supportedEClassifiers.indexOf(eclassifier);
        Combo control = (Combo)field.getComboControl();
        control.select(indexEClassifier);
        this.setPageComplete(this.validatePage());
    }

    private void storeSelectionMetaModel(ComboButtonField field) {
        String descriptor;
        int index = field.getSelectionIndex();
        if (index > -1 && (descriptor = ((IMetaModelDescriptor)this.supportedMetaModelDescriptors.get(index)).getIdentifier()) != null) {
            Activator.getPlugin().getDialogSettings().put(this.LAST_SELECTED_METAMODEL_KEY, descriptor);
            this.initialModelProperties.setMetaModelDescriptor((IMetaModelDescriptor)this.supportedMetaModelDescriptors.get(index));
            this.setPageComplete(this.validatePage());
        }
    }

    private void storeSelectionEPackage(ComboButtonField field) {
        EPackage epackage;
        String packageName;
        int index = field.getSelectionIndex();
        if (index > -1 && (packageName = (epackage = this.supportedEPackages.get(index)).getName()) != null) {
            Activator.getPlugin().getDialogSettings().put(this.LAST_SELECTED_EPACKAGE_KEY, packageName);
            this.initialModelProperties.setRootObjectEPackage(this.supportedEPackages.get(index));
            this.setPageComplete(this.validatePage());
        }
    }

    private void storeSelectionEClassifier(ComboButtonField field) {
        String eclassifier;
        int index = field.getSelectionIndex();
        if (index > -1 && (eclassifier = this.supportedEClassifiers.get(index).getName()) != null) {
            Activator.getPlugin().getDialogSettings().put(this.LAST_SELECTED_ECLASSIFIER_KEY, eclassifier);
            this.initialModelProperties.setRootObjectEClassifier(this.supportedEClassifiers.get(index));
            this.setPageComplete(this.validatePage());
        }
    }

    private boolean isEClassInstantiated(EClass eClass) {
        return !eClass.isAbstract() && !eClass.isInterface();
    }

    private boolean isEPackageInstantiated(EPackage ePackage) {
        for (EClassifier eClassifier : ePackage.getEClassifiers()) {
            EClass eClass;
            if (!(eClassifier instanceof EClass) || !this.isEClassInstantiated(eClass = (EClass)eClassifier)) continue;
            return true;
        }
        return false;
    }

    protected void initSupportedEPackages() {
        T metaModelDescriptor = this.initialModelProperties.getMetaModelDescriptor();
        if (metaModelDescriptor != null) {
            this.supportedEPackages.clear();
            for (EPackage ePackage : metaModelDescriptor.getEPackages()) {
                if (!this.isEPackageInstantiated(ePackage)) continue;
                this.supportedEPackages.add(ePackage);
            }
        }
    }

    protected void initSupportedEClassifiers() {
        EPackage epackage = this.initialModelProperties.getRootObjectEPackage();
        if (epackage != null) {
            this.supportedEClassifiers.clear();
            for (EClassifier eClassifier : epackage.getEClassifiers()) {
                EClass eClass;
                if (!(eClassifier instanceof EClass) || !this.isEClassInstantiated(eClass = (EClass)eClassifier)) continue;
                this.supportedEClassifiers.add((EClassifier)eClass);
            }
        }
    }

    protected boolean validatePage() {
        if (this.initialModelProperties.getMetaModelDescriptor() == null) {
            this.setErrorMessage(Messages.error_noMetaModelDescriptorSelected);
            return false;
        }
        if (this.initialModelProperties.getRootObjectEPackage() == null) {
            this.setErrorMessage(Messages.error_noEPackageSelected);
            return false;
        }
        if (this.initialModelProperties.getRootObjectEClassifier() == null) {
            this.setErrorMessage(Messages.error_noEClassifierSelected);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    private class EClassifierBrowseDialog
    extends AbstractBrowseDialog<EClassifier> {
        public EClassifierBrowseDialog(Shell shell, Collection<EClassifier> eClassifier) {
            super(shell, eClassifier);
        }

        protected EClassifier toObject(String itemAsString) {
            for (EClassifier eclassifier : InitialModelCreationPage.this.supportedEClassifiers) {
                if (eclassifier.getName() != itemAsString) continue;
                return eclassifier;
            }
            return null;
        }

        protected String toString(EClassifier itemAsObject) {
            return itemAsObject.getName();
        }

        public EClassifier getEClassifierResult() {
            Object[] result = super.getResult();
            return (EClassifier)result[0];
        }
    }

    protected class EClassifierButtonAdapter
    extends AbstractButtonAdapter {
        protected EClassifierButtonAdapter() {
        }

        protected Dialog doCreateDialog() {
            Shell parent = ExtendedPlatformUI.getActiveShell();
            EClassifierBrowseDialog dialog = new EClassifierBrowseDialog(parent, InitialModelCreationPage.this.supportedEClassifiers);
            dialog.setTitle(Messages.dialog_eClassifierBrowse_title);
            dialog.setMessage(Messages.dialog_browse_message);
            return dialog;
        }

        protected void performOk(IField field, Dialog dialog) {
            super.performOk(field, dialog);
            EClassifier result = ((EClassifierBrowseDialog)dialog).getEClassifierResult();
            InitialModelCreationPage.this.storeBrowserSelectionEClassifier((ComboButtonField)field, result);
        }
    }

    private class EPackageBrowseDialog
    extends AbstractBrowseDialog<EPackage> {
        public EPackageBrowseDialog(Shell shell, Collection<EPackage> ePackage) {
            super(shell, ePackage);
        }

        protected EPackage toObject(String itemAsString) {
            for (EPackage epackage : InitialModelCreationPage.this.supportedEPackages) {
                if (epackage.getName() != itemAsString) continue;
                return epackage;
            }
            return null;
        }

        protected String toString(EPackage itemAsObject) {
            return itemAsObject.getName();
        }

        public EPackage getEPackageResult() {
            Object[] result = super.getResult();
            return (EPackage)result[0];
        }
    }

    protected class EPackageButtonAdapter
    extends AbstractButtonAdapter {
        protected EPackageButtonAdapter() {
        }

        protected Dialog doCreateDialog() {
            Shell parent = ExtendedPlatformUI.getActiveShell();
            EPackageBrowseDialog dialog = new EPackageBrowseDialog(parent, InitialModelCreationPage.this.supportedEPackages);
            dialog.setTitle(Messages.dialog_ePackageBrowse_title);
            dialog.setMessage(Messages.dialog_browse_message);
            return dialog;
        }

        protected void performOk(IField field, Dialog dialog) {
            super.performOk(field, dialog);
            EPackage result = ((EPackageBrowseDialog)dialog).getEPackageResult();
            InitialModelCreationPage.this.storeBrowserSelectionEPackage((ComboButtonField)field, result);
            InitialModelCreationPage.this.initSupportedEClassifiers();
            InitialModelCreationPage.this.fillEClassifierCombo();
        }
    }

    protected class MetaModelButtonAdapter
    extends AbstractButtonAdapter {
        protected MetaModelButtonAdapter() {
        }

        protected Dialog doCreateDialog() {
            Shell parent = ExtendedPlatformUI.getActiveShell();
            MetaModelDescriptorBrowseDialog dialog = new MetaModelDescriptorBrowseDialog(parent, InitialModelCreationPage.this.supportedMetaModelDescriptors);
            dialog.setTitle(Messages.dialog_metaModelDescriptorBrowse_title);
            dialog.setMessage(Messages.dialog_browse_message);
            return dialog;
        }

        protected void performOk(IField field, Dialog dialog) {
            super.performOk(field, dialog);
            Object result = ((MetaModelDescriptorBrowseDialog)dialog).getMetaModelResult();
            InitialModelCreationPage.this.storeBrowserSelectionMetaModel((ComboButtonField)field, result);
            InitialModelCreationPage.this.initSupportedEPackages();
            InitialModelCreationPage.this.fillEPackageCombo();
        }
    }

    private class MetaModelDescriptorBrowseDialog
    extends AbstractBrowseDialog<T> {
        public MetaModelDescriptorBrowseDialog(Shell shell, Collection<T> metaModelDescriptors) {
            super(shell, metaModelDescriptors);
        }

        protected T toObject(String itemAsString) {
            for (IMetaModelDescriptor descriptor : InitialModelCreationPage.this.supportedMetaModelDescriptors) {
                if (descriptor.getName() != itemAsString) continue;
                return descriptor;
            }
            return null;
        }

        protected String toString(T itemAsObject) {
            return itemAsObject.getName();
        }

        public T getMetaModelResult() {
            Object[] result = super.getResult();
            return (IMetaModelDescriptor)result[0];
        }
    }

    public class fieldListener
    implements IFieldListener,
    SelectionListener {
        public void dialogFieldChanged(IField field) {
            if (field == InitialModelCreationPage.this.metaModelCombo) {
                InitialModelCreationPage.this.storeSelectionMetaModel((ComboButtonField)field);
                InitialModelCreationPage.this.initSupportedEPackages();
                InitialModelCreationPage.this.fillEPackageCombo();
            } else if (field == InitialModelCreationPage.this.ePackageCombo) {
                InitialModelCreationPage.this.storeSelectionEPackage((ComboButtonField)field);
                InitialModelCreationPage.this.initSupportedEClassifiers();
                InitialModelCreationPage.this.fillEClassifierCombo();
            } else if (field == InitialModelCreationPage.this.eClassifierCombo) {
                InitialModelCreationPage.this.storeSelectionEClassifier((ComboButtonField)field);
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            this.widgetDefaultSelected(e);
        }
    }
}

