/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.adapters.color;

import java.util.ConcurrentModificationException;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.graph.DynamicNodeLabel;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.populationmodels.standard.PopulationModel;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.ui.adapters.color.AbstractRelativeValueColorProviderAdapter;
import org.eclipse.stem.ui.adapters.color.AbstractRelativeValueColorProviderAdapterFactory;
import org.eclipse.stem.ui.adapters.color.STEMColor;
import org.eclipse.stem.ui.preferences.VisualizationPreferencePage;

public class IntensityColorsLabelsMappingColorProviderAdapter
extends AbstractRelativeValueColorProviderAdapter
implements AbstractRelativeValueColorProviderAdapterFactory.PropertySelectionListener {
    private final Map<String, STEMColor> colorMap = VisualizationPreferencePage.getColorMapping();
    private ItemPropertyDescriptor selectedProperty;

    public float getRelativeValue() {
        Node node = (Node)this.getTarget();
        try {
            for (NodeLabel label : node.getLabels()) {
                DynamicNodeLabel nodeLabel;
                if (!(label instanceof DynamicNodeLabel) || (nodeLabel = (DynamicNodeLabel)label).getDecorator() != this.selectedDecorator) continue;
                if (this.selectedDecorator instanceof DiseaseModel && nodeLabel instanceof DiseaseModelLabel) {
                    if (!((DiseaseModelLabel)nodeLabel).getPopulationModelLabel().getPopulationIdentifier().equals(this.selectedPopulationIdentifier)) continue;
                    this.setRVPTarget((Notifier)nodeLabel);
                    return (float)this.rvp.getRelativeValue(this.selectedProperty);
                }
                if (!(this.selectedDecorator instanceof PopulationModel)) continue;
                String popId = this.selectedPopulationIdentifier;
                if (!(nodeLabel instanceof PopulationModelLabel) || !((PopulationModelLabel)nodeLabel).getPopulationIdentifier().equals(popId)) continue;
                this.setRVPTarget((Notifier)nodeLabel);
                return (float)this.rvp.getRelativeValue(this.selectedProperty);
            }
        }
        catch (ConcurrentModificationException cme) {
            return this.getRelativeValue();
        }
        return 0.0f;
    }

    public STEMColor getColorForRelativeValue(double relativeValue) {
        this.updateColorsFromPreferences();
        return new STEMColor(this.foregroundFillColor.getRed(), this.foregroundFillColor.getGreen(), this.foregroundFillColor.getBlue(), (float)relativeValue);
    }

    public STEMColor getColor(float gainFactor, boolean useLogScaling) {
        String selectedPropertyName = this.selectedProperty.getDisplayName(null);
        if (this.colorMap.containsKey(selectedPropertyName)) {
            this.foregroundFillColor = this.colorMap.get(selectedPropertyName);
        } else {
            for (String key : this.colorMap.keySet()) {
                if (!selectedPropertyName.startsWith(key) || key.length() < 1) continue;
                String tail = selectedPropertyName.substring(key.length(), selectedPropertyName.length());
                if (tail == null || tail.length() == 0) {
                    STEMColor c = this.colorMap.get(key);
                    this.colorMap.put(selectedPropertyName, c);
                    this.foregroundFillColor = c;
                    break;
                }
                boolean hit = true;
                char[] cArray = tail.toCharArray();
                int n = cArray.length;
                int n2 = 0;
                while (n2 < n) {
                    char c = cArray[n2];
                    if (!Character.isDigit(c)) {
                        hit = false;
                        break;
                    }
                    ++n2;
                }
                if (!hit) continue;
                STEMColor c = this.colorMap.get(key);
                this.colorMap.put(selectedPropertyName, c);
                this.foregroundFillColor = c;
                break;
            }
        }
        if (!(this.getTarget() instanceof Node)) {
            return this.foregroundFillColor;
        }
        Object retValue = null;
        float alpha = this.performGainAndLogScaling(this.getRelativeValue(), gainFactor, useLogScaling);
        if (alpha < 1.0E-9f) {
            alpha = 0.0f;
        }
        return new STEMColor(this.foregroundFillColor.getRed(), this.foregroundFillColor.getGreen(), this.foregroundFillColor.getBlue(), alpha);
    }

    public void propertySelected(ItemPropertyDescriptor selectedProperty) {
        this.selectedProperty = selectedProperty;
    }

    public void setSelectedProperty(ItemPropertyDescriptor selectedProperty) {
        this.selectedProperty = selectedProperty;
    }
}

