/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.junit.wizards;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.junit.Messages;
import org.eclipse.jdt.internal.junit.util.CoreTestSearchEngine;
import org.eclipse.jdt.internal.junit.util.JUnitStatus;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.internal.junit.util.LayoutUtil;
import org.eclipse.jdt.internal.junit.wizards.SuiteClassesContentProvider;
import org.eclipse.jdt.internal.junit.wizards.TestSuiteClassListRange;
import org.eclipse.jdt.internal.junit.wizards.UpdateTestSuite;
import org.eclipse.jdt.internal.junit.wizards.WizardMessages;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NewTestSuiteWizardPage
extends NewTypeWizardPage {
    private static final String ALL_TESTS = "AllTests";
    public static final String NON_COMMENT_END_MARKER = "$JUnit-END$";
    public static final String NON_COMMENT_START_MARKER = "$JUnit-BEGIN$";
    public static final String COMMENT_START = "//";
    public static final String START_MARKER = "//$JUnit-BEGIN$";
    public static final String END_MARKER = "//$JUnit-END$";
    private static final String PAGE_NAME = "NewTestSuiteCreationWizardPage";
    public static final String CLASSES_IN_SUITE = "NewTestSuiteCreationWizardPage.classesinsuite";
    public static final String JUNIT4TOGGLE = "NewTestSuiteCreationWizardPage.junit4toggle";
    private CheckboxTableViewer fClassesInSuiteTable;
    private IStatus fClassesInSuiteStatus;
    private Label fSelectedClassesLabel;
    private boolean fUpdatedExistingClassButton;
    private Button fJUnit4Toggle;
    private Button fJUnit3Toggle;
    private boolean fIsJunit4;
    private boolean fIsJunit4Enabled;

    public NewTestSuiteWizardPage() {
        super(true, PAGE_NAME);
        this.setTitle(WizardMessages.NewTestSuiteWizPage_title);
        this.setDescription(WizardMessages.NewTestSuiteWizPage_description);
        this.fClassesInSuiteStatus = new JUnitStatus();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createJUnit4Controls(composite, nColumns);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createClassesInSuiteControl(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.setControl((Control)composite);
        this.restoreWidgetValues();
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.junit.new_testsuite_wizard_page2_context");
    }

    protected void createMethodStubSelectionControls(Composite composite, int nColumns) {
    }

    public void init(IStructuredSelection selection) {
        IJavaProject project;
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem, true);
        this.initSuitePage(jelem);
        boolean isJunit4 = false;
        if (jelem != null && jelem.getElementType() != 1 && !(isJunit4 = CoreTestSearchEngine.hasJUnit4TestAnnotation((IJavaProject)(project = jelem.getJavaProject()))) && !CoreTestSearchEngine.hasTestCaseType((IJavaProject)project) && JUnitStubUtility.is50OrHigher(project)) {
            isJunit4 = true;
        }
        this.setJUnit4(isJunit4, true);
        this.doStatusUpdate();
    }

    private void initSuitePage(IJavaElement jelem) {
        if (jelem != null) {
            IPackageFragment pack = (IPackageFragment)jelem.getAncestor(4);
            IJavaProject project = jelem.getJavaProject();
            this.setPackageFragment(pack, true);
            this.setAddComments(StubUtility.doAddComments((IJavaProject)project), true);
        }
        this.setTypeName(ALL_TESTS, true);
        this.fTypeNameStatus = this.typeNameChanged();
    }

    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        if (fieldName.equals("NewTypeWizardPage.package") || fieldName.equals("NewContainerWizardPage.container") || fieldName.equals(JUNIT4TOGGLE)) {
            this.updateClassesInSuiteTable();
        } else if (fieldName.equals(CLASSES_IN_SUITE)) {
            this.fClassesInSuiteStatus = this.classesInSuiteChanged();
            this.fTypeNameStatus = this.typeNameChanged();
            this.updateSelectedClassesLabel();
        }
        this.doStatusUpdate();
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus, this.fTypeNameStatus, this.fClassesInSuiteStatus};
        this.updateStatus(status);
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setFocus();
            this.updateClassesInSuiteTable();
            this.handleAllFieldsChanged();
        } else {
            this.saveWidgetValues();
        }
        super.setVisible(visible);
    }

    private void handleAllFieldsChanged() {
        this.handleFieldChanged("NewTypeWizardPage.package");
        this.handleFieldChanged("NewContainerWizardPage.container");
        this.handleFieldChanged(CLASSES_IN_SUITE);
        this.handleFieldChanged("NewTypeWizardPage.typename");
    }

    protected void updateClassesInSuiteTable() {
        if (this.fClassesInSuiteTable != null) {
            IPackageFragment pack = this.getPackageFragment();
            if (pack == null) {
                IPackageFragmentRoot root = this.getPackageFragmentRoot();
                if (root != null) {
                    pack = root.getPackageFragment("");
                } else {
                    return;
                }
            }
            this.fClassesInSuiteTable.setInput((Object)pack);
            this.fClassesInSuiteTable.setAllChecked(true);
            this.updateSelectedClassesLabel();
        }
    }

    protected void createClassesInSuiteControl(Composite parent, int nColumns) {
        if (this.fClassesInSuiteTable == null) {
            Label label = new Label(parent, 16384);
            label.setText(WizardMessages.NewTestSuiteWizPage_classes_in_suite_label);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.horizontalSpan = nColumns;
            label.setLayoutData((Object)gd);
            this.fClassesInSuiteTable = CheckboxTableViewer.newCheckList((Composite)parent, (int)2048);
            gd = new GridData(1808);
            gd.heightHint = 80;
            gd.horizontalSpan = nColumns - 1;
            this.fClassesInSuiteTable.getTable().setLayoutData((Object)gd);
            this.fClassesInSuiteTable.setContentProvider((IContentProvider)new SuiteClassesContentProvider(this.isJUnit4()));
            this.fClassesInSuiteTable.setLabelProvider((IBaseLabelProvider)new JavaElementLabelProvider());
            this.fClassesInSuiteTable.addCheckStateListener(new ICheckStateListener(){

                public void checkStateChanged(CheckStateChangedEvent event) {
                    NewTestSuiteWizardPage.this.handleFieldChanged(NewTestSuiteWizardPage.CLASSES_IN_SUITE);
                }
            });
            Composite buttonContainer = new Composite(parent, 0);
            gd = new GridData(1040);
            buttonContainer.setLayoutData((Object)gd);
            GridLayout buttonLayout = new GridLayout();
            buttonLayout.marginWidth = 0;
            buttonLayout.marginHeight = 0;
            buttonContainer.setLayout((Layout)buttonLayout);
            Button selectAllButton = new Button(buttonContainer, 8);
            selectAllButton.setText(WizardMessages.NewTestSuiteWizPage_selectAll);
            GridData bgd = new GridData(770);
            bgd.widthHint = LayoutUtil.getButtonWidthHint(selectAllButton);
            selectAllButton.setLayoutData((Object)bgd);
            selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewTestSuiteWizardPage.this.fClassesInSuiteTable.setAllChecked(true);
                    NewTestSuiteWizardPage.this.handleFieldChanged(NewTestSuiteWizardPage.CLASSES_IN_SUITE);
                }
            });
            Button deselectAllButton = new Button(buttonContainer, 8);
            deselectAllButton.setText(WizardMessages.NewTestSuiteWizPage_deselectAll);
            bgd = new GridData(770);
            bgd.widthHint = LayoutUtil.getButtonWidthHint(deselectAllButton);
            deselectAllButton.setLayoutData((Object)bgd);
            deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    NewTestSuiteWizardPage.this.fClassesInSuiteTable.setAllChecked(false);
                    NewTestSuiteWizardPage.this.handleFieldChanged(NewTestSuiteWizardPage.CLASSES_IN_SUITE);
                }
            });
            this.fSelectedClassesLabel = new Label(parent, 16448);
            this.fSelectedClassesLabel.setFont(parent.getFont());
            this.updateSelectedClassesLabel();
            gd = new GridData();
            gd.horizontalSpan = 2;
            this.fSelectedClassesLabel.setLayoutData((Object)gd);
        }
    }

    protected void createTypeMembers(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        this.writeImports(imports);
        if (!this.isJUnit4()) {
            type.createMethod(this.getSuiteMethodString(type), null, false, null);
        }
    }

    private String getSuiteMethodString(IType type) {
        String typeName = type.getElementName();
        StringBuffer suite = new StringBuffer("public static Test suite () {TestSuite suite= new TestSuite(" + typeName + ".class.getName());\n");
        suite.append(this.getUpdatableString());
        suite.append("\nreturn suite;}");
        return suite.toString();
    }

    private String getUpdatableString() {
        return UpdateTestSuite.getUpdatableString(this.fClassesInSuiteTable.getCheckedElements());
    }

    public void createType(IProgressMonitor monitor) throws CoreException, InterruptedException {
        IPackageFragment pack = this.getPackageFragment();
        ICompilationUnit cu = pack.getCompilationUnit(String.valueOf(this.getTypeName()) + ".java");
        if (!cu.exists()) {
            super.createType(monitor);
            this.fUpdatedExistingClassButton = false;
        } else {
            this.updateExistingType(cu, monitor);
            this.fUpdatedExistingClassButton = true;
        }
    }

    private void updateExistingType(ICompilationUnit cu, IProgressMonitor monitor) throws JavaModelException {
        block12: {
            if (!UpdateTestSuite.checkValidateEditStatus(cu, this.getShell())) {
                return;
            }
            IType suiteType = cu.getType(this.getTypeName());
            monitor.beginTask(WizardMessages.NewTestSuiteWizPage_createType_beginTask, 10);
            if (this.isJUnit4()) {
                IAnnotation suiteClasses = suiteType.getAnnotation("SuiteClasses");
                if (suiteClasses.exists()) {
                    UpdateTestSuite.updateTestCasesInJunit4Suite((IProgressMonitor)new SubProgressMonitor(monitor, 5), cu, suiteClasses, this.fClassesInSuiteTable.getCheckedElements());
                } else {
                    this.cannotUpdateSuiteError();
                }
            } else {
                IMethod suiteMethod = suiteType.getMethod("suite", new String[0]);
                monitor.worked(1);
                String lineDelimiter = cu.findRecommendedLineSeparator();
                if (suiteMethod.exists()) {
                    ISourceRange range = suiteMethod.getSourceRange();
                    if (range != null) {
                        try {
                            Document fullSource = new Document(cu.getBuffer().getContents());
                            String originalContent = fullSource.get(range.getOffset(), range.getLength());
                            TestSuiteClassListRange classListRange = UpdateTestSuite.getTestSuiteClassListRange(originalContent);
                            if (classListRange != null) {
                                UpdateTestSuite.updateTestCasesInSuite(monitor, cu, suiteMethod, this.fClassesInSuiteTable.getCheckedElements());
                                break block12;
                            }
                            this.cannotUpdateSuiteError();
                        }
                        catch (BadLocationException badLocationException) {
                            Assert.isTrue((boolean)false, (String)"Should never happen");
                        }
                    } else {
                        MessageDialog.openError((Shell)this.getShell(), (String)WizardMessages.NewTestSuiteWizPage_createType_updateErrorDialog_title, (String)WizardMessages.NewTestSuiteWizPage_createType_updateErrorDialog_message);
                    }
                } else {
                    suiteType.createMethod(this.getSuiteMethodString(suiteType), null, true, monitor);
                    String originalContent = cu.getSource();
                    monitor.worked(2);
                    String formattedContent = JUnitStubUtility.formatCompilationUnit(cu.getJavaProject(), originalContent, lineDelimiter);
                    cu.getBuffer().setContents(formattedContent);
                    monitor.worked(1);
                    cu.save((IProgressMonitor)new SubProgressMonitor(monitor, 1), false);
                }
            }
        }
        monitor.done();
    }

    public boolean hasUpdatedExistingClass() {
        return this.fUpdatedExistingClassButton;
    }

    private IStatus classesInSuiteChanged() {
        JUnitStatus status = new JUnitStatus();
        if (this.fClassesInSuiteTable.getCheckedElements().length <= 0) {
            status.setWarning(WizardMessages.NewTestSuiteWizPage_classes_in_suite_error_no_testclasses_selected);
        }
        return status;
    }

    private void updateSelectedClassesLabel() {
        int noOfClassesChecked = this.fClassesInSuiteTable.getCheckedElements().length;
        String key = noOfClassesChecked == 1 ? WizardMessages.NewTestClassWizPage_treeCaption_classSelected : WizardMessages.NewTestClassWizPage_treeCaption_classesSelected;
        this.fSelectedClassesLabel.setText(Messages.format((String)key, (Object)noOfClassesChecked));
    }

    protected IStatus typeNameChanged() {
        IStatus recursiveSuiteInclusionStatus;
        IStatus val;
        super.typeNameChanged();
        JUnitStatus status = new JUnitStatus();
        String typeName = this.getTypeName();
        if (typeName.length() == 0) {
            status.setError(WizardMessages.NewTestSuiteWizPage_typeName_error_name_empty);
            return status;
        }
        if (typeName.indexOf(46) != -1) {
            status.setError(WizardMessages.NewTestSuiteWizPage_typeName_error_name_qualified);
            return status;
        }
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            ICompilationUnit cu = pack.getCompilationUnit(String.valueOf(typeName) + ".java");
            if (cu.exists()) {
                IType type = cu.findPrimaryType();
                if (type != null) {
                    this.setJUnit4(type.getAnnotation("RunWith").exists(), false);
                }
            } else {
                this.setJUnit4(this.isJUnit4(), true);
            }
        }
        if ((val = JavaConventionsUtil.validateJavaTypeName((String)typeName, (IJavaElement)this.getJavaProject())).getSeverity() == 4) {
            status.setError(String.valueOf(WizardMessages.NewTestSuiteWizPage_typeName_error_name_not_valid) + val.getMessage());
            return status;
        }
        if (val.getSeverity() == 2) {
            status.setWarning(String.valueOf(WizardMessages.NewTestSuiteWizPage_typeName_error_name_name_discouraged) + val.getMessage());
        }
        if (!(recursiveSuiteInclusionStatus = this.checkRecursiveTestSuiteInclusion()).isOK()) {
            return recursiveSuiteInclusionStatus;
        }
        if (pack != null) {
            ICompilationUnit cu = pack.getCompilationUnit(String.valueOf(typeName) + ".java");
            if (cu.exists()) {
                status.setWarning(this.isJUnit4() ? WizardMessages.NewTestSuiteWizPage_typeName_warning_already_exists_junit4 : WizardMessages.NewTestSuiteWizPage_typeName_warning_already_exists);
                return status;
            }
            IResource resource = cu.getResource();
            if (resource != null && !ResourcesPlugin.getWorkspace().validateFiltered(resource).isOK()) {
                status.setError(WizardMessages.NewTestSuiteWizPage_typeName_error_filtered);
                return status;
            }
        }
        return status;
    }

    private IStatus checkRecursiveTestSuiteInclusion() {
        if (this.fClassesInSuiteTable == null) {
            return new JUnitStatus();
        }
        String typeName = this.getTypeName();
        JUnitStatus status = new JUnitStatus();
        Object[] checkedClasses = this.fClassesInSuiteTable.getCheckedElements();
        int i = 0;
        while (i < checkedClasses.length) {
            IType checkedClass = (IType)checkedClasses[i];
            if (checkedClass.getElementName().equals(typeName)) {
                status.setWarning(WizardMessages.NewTestSuiteCreationWizardPage_infinite_recursion);
                return status;
            }
            ++i;
        }
        return new JUnitStatus();
    }

    private void cannotUpdateSuiteError() {
        MessageDialog.openError((Shell)this.getShell(), (String)WizardMessages.NewTestSuiteWizPage_cannotUpdateDialog_title, (String)Messages.format((String)WizardMessages.NewTestSuiteWizPage_cannotUpdateDialog_message, (Object[])new String[]{START_MARKER, END_MARKER}));
    }

    private void writeImports(NewTypeWizardPage.ImportsManager imports) {
        if (this.isJUnit4()) {
            imports.addImport("org.junit.runner.RunWith");
            imports.addImport("org.junit.runners.Suite");
            imports.addImport("org.junit.runners.Suite.SuiteClasses");
        } else {
            imports.addImport("junit.framework.Test");
            imports.addImport("junit.framework.TestSuite");
        }
    }

    private void restoreWidgetValues() {
    }

    private void saveWidgetValues() {
    }

    protected void createJUnit4Controls(Composite composite, int nColumns) {
        Composite inner = new Composite(composite, 0);
        inner.setLayoutData((Object)new GridData(4, 0x1000000, false, false, nColumns, 1));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = ((Button)e.widget).getSelection();
                NewTestSuiteWizardPage.this.internalSetJUnit4(isSelected);
            }
        };
        this.fJUnit3Toggle = new Button(inner, 16);
        this.fJUnit3Toggle.setText(WizardMessages.NewTestClassWizPage_junit3_radio_label);
        this.fJUnit3Toggle.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.fJUnit3Toggle.setSelection(!this.fIsJunit4);
        this.fJUnit3Toggle.setEnabled(this.fIsJunit4Enabled);
        this.fJUnit4Toggle = new Button(inner, 16);
        this.fJUnit4Toggle.setText(WizardMessages.NewTestClassWizPage_junit4_radio_label);
        this.fJUnit4Toggle.setSelection(this.fIsJunit4);
        this.fJUnit4Toggle.setEnabled(this.fIsJunit4Enabled);
        this.fJUnit4Toggle.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        this.fJUnit4Toggle.addSelectionListener((SelectionListener)listener);
    }

    public void setJUnit4(boolean isJUnit4, boolean isEnabled) {
        this.fIsJunit4Enabled = isEnabled;
        if (this.fJUnit4Toggle != null && !this.fJUnit4Toggle.isDisposed()) {
            this.fJUnit4Toggle.setSelection(isJUnit4);
            this.fJUnit3Toggle.setSelection(!isJUnit4);
            this.fJUnit4Toggle.setEnabled(isEnabled || isJUnit4);
            this.fJUnit3Toggle.setEnabled(isEnabled || !isJUnit4);
        }
        this.internalSetJUnit4(isJUnit4);
    }

    public boolean isJUnit4() {
        return this.fIsJunit4;
    }

    private void internalSetJUnit4(boolean isJUnit4) {
        if (this.fIsJunit4 == isJUnit4) {
            return;
        }
        this.fIsJunit4 = isJUnit4;
        if (this.fClassesInSuiteTable != null && this.fClassesInSuiteTable.getContentProvider() instanceof SuiteClassesContentProvider) {
            SuiteClassesContentProvider provider = (SuiteClassesContentProvider)this.fClassesInSuiteTable.getContentProvider();
            provider.setIncludeJunit4Tests(isJUnit4);
        }
        if (this.fIsJunit4) {
            this.setSuperClass("java.lang.Object", false);
        } else {
            this.setSuperClass("junit.framework.TestCase", true);
        }
        this.handleFieldChanged(JUNIT4TOGGLE);
    }

    protected String constructCUContent(ICompilationUnit cu, String typeContent, String lineDelimiter) throws CoreException {
        if (this.isJUnit4()) {
            typeContent = this.appendAnnotations(typeContent, lineDelimiter);
        }
        return super.constructCUContent(cu, typeContent, lineDelimiter);
    }

    private String appendAnnotations(String typeContent, String lineDelimiter) {
        Object[] checkedElements = this.fClassesInSuiteTable.getCheckedElements();
        StringBuffer buffer = new StringBuffer("@RunWith(Suite.class)");
        buffer.append(lineDelimiter);
        buffer.append("@SuiteClasses({");
        int i = 0;
        while (i < checkedElements.length) {
            if (checkedElements[i] instanceof IType) {
                IType testType = (IType)checkedElements[i];
                buffer.append(testType.getElementName());
                buffer.append(".class");
                if (i < checkedElements.length - 1) {
                    buffer.append(',');
                }
            }
            ++i;
        }
        buffer.append("})");
        buffer.append(lineDelimiter);
        buffer.append(typeContent);
        return buffer.toString();
    }
}

