/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.mwe.utils.DirectoryCleaner;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xtext.generator.IGuiceAwareGeneratorComponent;
import org.eclipse.xtext.xtext.generator.model.IXtextGeneratorFileSystemAccess;
import org.eclipse.xtext.xtext.generator.model.project.IXtextProjectConfig;

public class XtextDirectoryCleaner
implements IGuiceAwareGeneratorComponent {
    @Inject
    private IXtextProjectConfig config;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean enabled = true;
    @Accessors(value={AccessorType.PUBLIC_SETTER})
    private boolean useDefaultExcludes = true;
    private List<String> excludes = CollectionLiterals.newArrayList();
    private List<String> extraDirectories = CollectionLiterals.newArrayList();

    public void addExtraDirectory(String directory) {
        this.extraDirectories.add(directory);
    }

    public void addExclude(String exclude) {
        this.excludes.add(exclude);
    }

    public void clean() {
        if (!this.enabled) {
            return;
        }
        ArrayList directories = CollectionLiterals.newArrayList();
        Functions.Function1 _function = it -> it.getSrcGen();
        List _map = ListExtensions.map(this.config.getEnabledProjects(), (Functions.Function1)_function);
        IXtextGeneratorFileSystemAccess _ecoreModel = this.config.getRuntime().getEcoreModel();
        Functions.Function1 _function_1 = it -> it.getPath();
        Functions.Function1 _function_2 = it -> new File((String)it).isDirectory();
        Iterable _filter = IterableExtensions.filter((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filterNull((Iterable)Iterables.concat((Iterable)_map, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new IXtextGeneratorFileSystemAccess[]{_ecoreModel})))), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
        Iterables.addAll((Collection)directories, (Iterable)_filter);
        Iterables.addAll((Collection)directories, this.extraDirectories);
        DirectoryCleaner delegate = new DirectoryCleaner();
        delegate.setUseDefaultExcludes(this.useDefaultExcludes);
        Consumer<String> _function_3 = it -> delegate.addExclude(it);
        this.excludes.forEach(_function_3);
        Consumer<String> _function_4 = it -> {
            try {
                delegate.cleanFolder(it);
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        directories.forEach(_function_4);
    }

    @Override
    public void initialize(Injector injector) {
        injector.injectMembers((Object)this);
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setUseDefaultExcludes(boolean useDefaultExcludes) {
        this.useDefaultExcludes = useDefaultExcludes;
    }
}

