/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.codegen;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.codegen.ecore.CodeGenEcorePlugin;
import org.eclipse.emf.codegen.ecore.generator.AbstractGeneratorAdapter;
import org.eclipse.emf.codegen.ecore.genmodel.GenBase;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.codegen.jet.JETEmitter;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.util.GIFEmitter;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stem.model.codegen.Activator;
import org.eclipse.stem.model.codegen.STEMGenClass;
import org.eclipse.stem.model.codegen.STEMGenPackage;

public class ModelGeneratorAdapter
extends AbstractGeneratorAdapter {
    private static List<String> WARNING_LIST = new LinkedList<String>();
    public static final int PropertyStringProviderAdapterFactory = 0;
    public static final int PropertyEditorAdapter = 1;
    public static final int PropertyEditor = 2;
    public static final int PropertyEditorAdapterFactory = 3;
    public static final int WizardMessages = 4;
    public static final int WizardMessagesProperties = 5;
    public static final int RelativeValueProviderAdapterFactory = 6;
    AbstractGeneratorAdapter.JETEmitterDescriptor[] descriptors = new AbstractGeneratorAdapter.JETEmitterDescriptor[]{new AbstractGeneratorAdapter.JETEmitterDescriptor("editor/PropertyStringProviderAdapterFactory.javajet", "org.eclipse.emf.codegen.ecore.templates.editor.PropertyStringProviderAdapterFactory"), new AbstractGeneratorAdapter.JETEmitterDescriptor("editor/PropertyEditorAdapter.javajet", "org.eclipse.emf.codegen.ecore.templates.editor.PropertyEditorAdapter"), new AbstractGeneratorAdapter.JETEmitterDescriptor("editor/PropertyEditor.javajet", "org.eclipse.emf.codegen.ecore.templates.editor.PropertyEditor"), new AbstractGeneratorAdapter.JETEmitterDescriptor("editor/PropertyEditorAdapterFactory.javajet", "org.eclipse.emf.codegen.ecore.templates.editor.PropertyEditorAdapterFactory"), new AbstractGeneratorAdapter.JETEmitterDescriptor("editor/WizardMessages.javajet", "org.eclipse.emf.codegen.ecore.templates.editor.WizardMessages"), new AbstractGeneratorAdapter.JETEmitterDescriptor("editor/WizardMessages.propertiesjet", "org.eclipse.emf.codegen.ecore.templates.editor.WizardMessagesProperties"), new AbstractGeneratorAdapter.JETEmitterDescriptor("editor/RelativeValueProviderAdapterFactory.javajet", "org.eclipse.emf.codegen.ecore.templates.editor.RelativeValueProviderAdapterFactory")};
    public static final String EDIT_PROJECT_TYPE = "org.eclipse.emf.codegen.ecore.genmodel.generator.EditProject";
    public static final String EDITOR_PROJECT_TYPE = "org.eclipse.emf.codegen.ecore.genmodel.generator.EditorProject";

    public boolean canGenerate(Object object, Object projectType) {
        if (EDITOR_PROJECT_TYPE.equals(projectType) && object instanceof GenPackage) {
            STEMGenPackage pkg = STEMGenPackage.get((GenPackage)object);
            return pkg.hasComputationalModel();
        }
        if (EDIT_PROJECT_TYPE.equals(projectType) && object instanceof GenClass) {
            return STEMGenClass.get((GenClass)object).isComputationalModel();
        }
        return false;
    }

    protected List<String> getUserTemplatePath() {
        ArrayList<String> templatePath = new ArrayList<String>();
        templatePath.add(Activator.getContext().getBundle().getResource("templates").toString());
        String templateLocation = ((GenBase)this.generatingObject).getGenModel().getTemplateDirectory();
        if (templateLocation != null && templateLocation.length() != 0) {
            if (templateLocation.indexOf(58) == -1) {
                templateLocation = URI.createPlatformResourceURI((String)templateLocation, (boolean)true).toString();
            }
            templatePath.add(templateLocation);
        }
        return templatePath;
    }

    protected void addClasspathEntries(JETEmitter jetEmitter) throws JETException {
        jetEmitter.addVariable("EMF_CODEGEN", "org.eclipse.emf.codegen");
        jetEmitter.addVariable("EMF_CODEGEN_ECORE", "org.eclipse.emf.codegen.ecore");
        jetEmitter.addVariable("EMF_COMMON", "org.eclipse.emf.common");
        jetEmitter.addVariable("EMF_ECORE", "org.eclipse.emf.ecore");
        jetEmitter.addVariable("STEM_CODEGEN", "org.eclipse.stem.model.codegen");
        super.addClasspathEntries(jetEmitter);
    }

    protected void generateWizardMessageProperties(STEMGenPackage stemGenerator, Monitor monitor) {
        GenPackage genPackage = stemGenerator.getGenPackage();
        URI targetDirectory = this.toURI(genPackage.getGenModel().getEditorDirectory()).appendSegments(genPackage.getPresentationPackageName().split("\\."));
        this.message = "Generating Wizard Message Properties";
        monitor.subTask(this.message);
        this.generateProperties(String.valueOf(targetDirectory.toString()) + "/messages.properties", this.getJETEmitter(this.descriptors, 5), new Object[]{new Object[]{stemGenerator}}, this.createMonitor(monitor, 1));
    }

    protected void generatePropertyStringProvider(STEMGenPackage stemGenerator, Monitor monitor) {
        GenPackage genPackage = stemGenerator.getGenPackage();
        this.message = "Generating Property String Provider";
        monitor.subTask(this.message);
        this.generateJava(genPackage.getGenModel().getEditorDirectory(), genPackage.getPresentationPackageName(), String.valueOf(genPackage.getPrefix()) + "PropertyStringProviderAdapterFactory", this.getJETEmitter(this.descriptors, 0), new Object[]{new Object[]{stemGenerator}}, this.createMonitor(monitor, 1));
    }

    protected void generateRelativeValueProviders(STEMGenPackage stemGenerator, Monitor monitor) {
        GenPackage genPackage = stemGenerator.getGenPackage();
        this.message = "Generating Relative Value Providers";
        monitor.subTask(this.message);
        this.generateJava(genPackage.getGenModel().getEditorDirectory(), genPackage.getPresentationPackageName(), String.valueOf(genPackage.getPrefix()) + "RelativeValueProviderAdapterFactory", this.getJETEmitter(this.descriptors, 6), new Object[]{new Object[]{stemGenerator}}, this.createMonitor(monitor, 1));
    }

    protected void generatePropertyEditorAdapter(STEMGenClass stemGenerator, Monitor monitor) {
        GenClass genClass = stemGenerator.getGenClass();
        GenPackage genPackage = genClass.getGenPackage();
        STEMGenClass adapterGenerator = STEMGenClass.get(genClass);
        this.message = "Generating Model Adapter";
        monitor.subTask(this.message);
        this.generateJava(genPackage.getGenModel().getEditorDirectory(), genPackage.getPresentationPackageName(), String.valueOf(genClass.getName()) + "PropertyEditorAdapter", this.getJETEmitter(this.descriptors, 1), new Object[]{new Object[]{adapterGenerator}}, this.createMonitor(monitor, 1));
    }

    protected void generateModelPropertyEditor(STEMGenClass stemGenerator, Monitor monitor) {
        GenClass genClass = stemGenerator.getGenClass();
        GenPackage genPackage = genClass.getGenPackage();
        this.message = "Generating Property Editor for " + genClass.getName();
        monitor.subTask(this.message);
        this.generateJava(genPackage.getGenModel().getEditorDirectory(), genPackage.getPresentationPackageName(), String.valueOf(genClass.getName()) + "PropertyEditor", this.getJETEmitter(this.descriptors, 2), new Object[]{new Object[]{stemGenerator}}, this.createMonitor(monitor, 1));
    }

    protected void generateModelPropertyEditorAdapterFactory(STEMGenPackage stemGenerator, Monitor monitor) {
        GenPackage genPackage = stemGenerator.getGenPackage();
        this.message = "Generating Model Property Editor Adapter Factory";
        monitor.subTask(this.message);
        this.generateJava(genPackage.getGenModel().getEditorDirectory(), genPackage.getPresentationPackageName(), String.valueOf(genPackage.getPrefix()) + "PropertyEditorAdapterFactory", this.getJETEmitter(this.descriptors, 3), new Object[]{new Object[]{stemGenerator}}, this.createMonitor(monitor, 1));
    }

    protected void generateModelWizardMessages(STEMGenPackage stemGenerator, Monitor monitor) {
        GenPackage genPackage = stemGenerator.getGenPackage();
        this.message = "Generating Model Wizard Messages";
        monitor.subTask(this.message);
        this.generateJava(genPackage.getGenModel().getEditorDirectory(), genPackage.getPresentationPackageName(), String.valueOf(genPackage.getPrefix()) + "WizardMessages", this.getJETEmitter(this.descriptors, 4), new Object[]{new Object[]{stemGenerator}}, this.createMonitor(monitor, 1));
    }

    protected void generateModelIcon(final STEMGenClass stemGenClass, Monitor monitor) {
        final GenClass genClass = stemGenClass.getGenClass();
        this.message = CodeGenEcorePlugin.INSTANCE.getString("_UI_GeneratingItemIcon_message", new Object[]{genClass.getItemIconFileName()});
        monitor.subTask(this.message);
        this.generateGIF(genClass.getItemIconFileName(), new GIFEmitter(""){

            public byte[] generateGIF(String key1, String key2) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InputStream is = null;
                try {
                    int bytes;
                    URL u = new URL(stemGenClass.getIcon().toString());
                    is = u.openStream();
                    byte[] data = new byte[1024];
                    while ((bytes = is.read(data, 0, data.length)) != -1) {
                        baos.write(data, 0, bytes);
                    }
                    baos.flush();
                    byte[] byArray = baos.toByteArray();
                    return byArray;
                }
                catch (Exception e) {
                    ModelGeneratorAdapter.addWarning("Error loading icon for " + genClass.getName());
                    e.printStackTrace();
                }
                finally {
                    try {
                        is.close();
                        baos.close();
                    }
                    catch (Exception exception) {}
                }
                return new byte[0];
            }
        }, genClass.getName(), null, false, this.createMonitor(monitor, 1));
    }

    protected Diagnostic doGenerate(Object object, Object projectType, Monitor monitor) throws Exception {
        GenModel genModel;
        if (EDITOR_PROJECT_TYPE.equals(projectType)) {
            genModel = ((GenBase)object).getGenModel();
            this.ensureProjectExists(genModel.getEditorDirectory(), object, EDITOR_PROJECT_TYPE, genModel.isUpdateClasspath(), this.createMonitor(monitor, 1));
            if (object instanceof GenPackage) {
                GenPackage genPackage = (GenPackage)object;
                STEMGenPackage stemGenerator = STEMGenPackage.get(genPackage);
                this.generatePropertyStringProvider(stemGenerator, monitor);
                this.generateWizardMessageProperties(stemGenerator, monitor);
                this.generateModelPropertyEditorAdapterFactory(stemGenerator, monitor);
                this.generateModelWizardMessages(stemGenerator, monitor);
                this.generateRelativeValueProviders(stemGenerator, monitor);
                for (STEMGenClass genClass : stemGenerator.getComputationalModelClasses()) {
                    this.generatePropertyEditorAdapter(genClass, monitor);
                    this.generateModelPropertyEditor(genClass, monitor);
                }
            }
        }
        if (EDIT_PROJECT_TYPE.equals(projectType)) {
            GenClass genClass;
            STEMGenClass stemGenClass;
            genModel = ((GenBase)object).getGenModel();
            this.ensureProjectExists(genModel.getEditDirectory(), object, EDIT_PROJECT_TYPE, genModel.isUpdateClasspath(), this.createMonitor(monitor, 1));
            if (object instanceof GenClass && (stemGenClass = STEMGenClass.get(genClass = (GenClass)object)).isComputationalModel()) {
                this.generateModelIcon(stemGenClass, monitor);
            }
        }
        return Diagnostic.OK_INSTANCE;
    }

    protected void createImportManager(String packageName, String className) {
        super.createImportManager(packageName, className);
        this.updateImportManager();
    }

    protected void clearImportManager() {
        super.clearImportManager();
        this.updateImportManager();
    }

    private void updateImportManager() {
        if (this.generatingObject != null) {
            ((GenBase)this.generatingObject).getGenModel().setImportManager(this.importManager);
        }
    }

    public static void addWarning(String warningText) {
        System.err.println("[WARNING] " + warningText);
        WARNING_LIST.add(warningText);
    }

    public static void pringWarnings() {
        if (WARNING_LIST.size() > 0) {
            System.out.println("Warnings from code generation:");
            for (String warning : WARNING_LIST) {
                System.out.println(" - " + warning);
            }
        }
    }
}

