/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.analysis.automaticexperiment.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.stem.analysis.ErrorResult;
import org.eclipse.stem.analysis.automaticexperiment.ALGORITHM_STATUS;
import org.eclipse.stem.analysis.automaticexperiment.AutomaticExperimentManager;
import org.eclipse.stem.analysis.automaticexperiment.AutomaticExperimentManagerEvent;
import org.eclipse.stem.analysis.automaticexperiment.AutomaticExperimentManagerListener;
import org.eclipse.stem.analysis.automaticexperiment.ErrorAnalysisAlgorithm;
import org.eclipse.stem.analysis.automaticexperiment.ErrorAnalysisAlgorithmEvent;
import org.eclipse.stem.analysis.automaticexperiment.ErrorAnalysisAlgorithmListener;
import org.eclipse.stem.analysis.automaticexperiment.MANAGER_STATUS;
import org.eclipse.stem.analysis.automaticexperiment.views.AggregateTimeSeriesCanvas;
import org.eclipse.stem.analysis.automaticexperiment.views.AnalysisControl;
import org.eclipse.stem.analysis.automaticexperiment.views.ErrorTimeSeriesCanvas;
import org.eclipse.stem.analysis.automaticexperiment.views.Messages;
import org.eclipse.stem.analysis.automaticexperiment.views.RunHistoryCanvas;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.ui.Activator;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class AutoExpControl
extends AnalysisControl {
    private static Display display = null;
    private ImageRegistry imageRegistry = null;
    private static AutomaticExperimentManager manager = null;
    static CTabFolder tabFolder;
    static boolean pauseTrigger;
    static double[] referenceIncidence;
    static double[] modelIncidence;
    Button stopButton = null;
    Button restartButton = null;
    static final ColorDefinition foreGround;
    static final ColorDefinition backgroundGround;
    static final ColorDefinition frameColor;
    private static Color cyan;
    private static Color cyanDark;
    private static Color darkRed;
    private static Color white;
    private static Color lightGreen;
    private static Color lightBlue;
    protected static RunHistoryCanvas errorConvergenceByRun;
    static final int ERROR_CONVERGENCE_BY_RUN_ID = 0;
    protected static ErrorTimeSeriesCanvas currentErrorByTime;
    static final int CURRENT_ERROR_BY_TIME_ID = 1;
    protected static AggregateTimeSeriesCanvas aggregateErrorByTime;
    static final int AGGREGATE_BY_TIME_ID = 2;
    private static final int NUMROWS = 10;
    protected static Composite errorTimeSeriesComposite;
    protected static Composite aggregateTimeSeriesComposite;
    protected static Composite runHistoryComposite;
    protected static Composite valuesComposite;
    protected static Composite controlsComposite;
    protected static Composite controlsActionComposite;
    protected static Composite controlsValuesComposite;
    protected static Composite settingsComposite;
    private static List<Double> errorHistoryList;
    private static double[] errorHistory;
    private static double[] bestSeries;
    private static double bestError;
    private static double bestVError;
    private static double[] newErrorTimeSeries;
    protected static String[] runParamNames;
    protected static double[] bestParamValues;
    protected static double[][] recentParamValues;
    protected static double[] restartParamValues;
    protected static double[] recentErrors;
    protected static double[] recentVErrors;
    protected static CLabel[] attributeLabels;
    protected static CLabel[] controlLabels;
    protected static Text[] bestValueLabels;
    protected static Text[][] recentValueLabels;
    protected static Text[] restartValues;
    protected static short row;
    protected static short numColumns;
    protected static boolean restartWithLatest;
    static boolean valuesInitialized;

    static {
        pauseTrigger = false;
        foreGround = ColorDefinitionImpl.create((int)180, (int)0, (int)0);
        backgroundGround = ColorDefinitionImpl.create((int)255, (int)255, (int)225);
        frameColor = ColorDefinitionImpl.WHITE();
        errorConvergenceByRun = null;
        currentErrorByTime = null;
        aggregateErrorByTime = null;
        errorHistoryList = new ArrayList<Double>();
        bestError = Double.MAX_VALUE;
        bestVError = Double.MAX_VALUE;
        row = 0;
        numColumns = 0;
        restartWithLatest = true;
        valuesInitialized = false;
    }

    public AutoExpControl(Composite parent) {
        super(parent, 0);
        this.createContents();
    }

    void createContents() {
        if (this.imageRegistry == null) {
            Activator activator = Activator.getDefault();
            this.imageRegistry = activator.getImageRegistry();
        }
        this.setLayout((Layout)new FormLayout());
        if (display == null) {
            display = this.getDisplay();
        }
        cyan = display.getSystemColor(13);
        cyanDark = new Color((Device)display, 60, 220, 220);
        darkRed = display.getSystemColor(4);
        white = display.getSystemColor(1);
        lightGreen = new Color((Device)display, 128, 255, 128);
        lightBlue = new Color((Device)display, 128, 128, 255);
        this.identifiableTitle = new Label((Composite)this, 0);
        this.identifiableTitle.setText(Messages.getString("AUTO.TITLELABEL"));
        int bottom = 5;
        FormData titleFormData = new FormData();
        this.identifiableTitle.setLayoutData((Object)titleFormData);
        titleFormData.top = new FormAttachment(0, 0);
        titleFormData.bottom = new FormAttachment(bottom, 0);
        titleFormData.left = new FormAttachment(0, 0);
        titleFormData.right = new FormAttachment(100, 0);
        tabFolder = new CTabFolder((Composite)this, 2048);
        valuesComposite = new Composite((Composite)tabFolder, 2048);
        FormData tabFormData = new FormData();
        tabFormData.top = new FormAttachment(++bottom, 0);
        tabFormData.bottom = new FormAttachment(100, 0);
        tabFormData.left = new FormAttachment(0, 0);
        tabFormData.right = new FormAttachment(100, 0);
        tabFolder.setLayoutData((Object)tabFormData);
        tabFolder.setSimple(false);
        tabFolder.setSelectionBackground(new Color[]{cyan, white, lightBlue, lightBlue}, new int[]{25, 50, 100});
        tabFolder.setSelectionForeground(display.getSystemColor(2));
        tabFolder.setBackground(cyanDark);
        tabFolder.setForeground(darkRed);
        tabFolder.setBorderVisible(true);
        CTabItem item0 = new CTabItem(tabFolder, 2048);
        item0.setText("  " + Messages.getString("AUTO.HISTORY") + " ");
        runHistoryComposite = new Composite((Composite)tabFolder, 2048);
        runHistoryComposite.setLayout((Layout)new FormLayout());
        item0.setControl((Control)runHistoryComposite);
        this.getRunHistoryChart(runHistoryComposite);
        CTabItem item1 = new CTabItem(tabFolder, 2048);
        item1.setText("  " + Messages.getString("AUTO.AGGREGATESERIES") + " ");
        aggregateTimeSeriesComposite = new Composite((Composite)tabFolder, 2048);
        aggregateTimeSeriesComposite.setLayout((Layout)new FormLayout());
        item1.setControl((Control)aggregateTimeSeriesComposite);
        this.getAggregateTimeSeriesChart(aggregateTimeSeriesComposite);
        CTabItem item2 = new CTabItem(tabFolder, 2048);
        item2.setText("  " + Messages.getString("AUTO.ERRORSERIES") + " ");
        errorTimeSeriesComposite = new Composite((Composite)tabFolder, 2048);
        errorTimeSeriesComposite.setLayout((Layout)new FormLayout());
        item2.setControl((Control)errorTimeSeriesComposite);
        this.getErrorTimeSeriesChart(errorTimeSeriesComposite);
        CTabItem item3 = new CTabItem(tabFolder, 2048);
        item3.setText(Messages.getString("AUTO.VALUES"));
        item3.setControl((Control)valuesComposite);
        controlsComposite = new Composite((Composite)tabFolder, 2048);
        this.getControls();
        CTabItem item4 = new CTabItem(tabFolder, 2048);
        item4.setText(Messages.getString("AUTO.CONTROLS"));
        item4.setControl((Control)controlsComposite);
        tabFolder.setSelection(item0);
        if (manager == null) {
            manager = AutomaticExperimentManager.getInstance();
            manager.addListener(new AutomaticExperimentManagerListener(){

                @Override
                public void eventReceived(AutomaticExperimentManagerEvent evt) {
                    if (evt.status == MANAGER_STATUS.SCHEDULED) {
                        ErrorAnalysisAlgorithm alg = evt.algorithm;
                        display.syncExec(new Runnable(){

                            @Override
                            public void run() {
                                AutoExpControl.this.reset();
                                (this).AutoExpControl.this.stopButton.setEnabled(true);
                                (this).AutoExpControl.this.restartButton.setEnabled(false);
                            }
                        });
                        alg.addListener(new ErrorAnalysisAlgorithmListener(){

                            @Override
                            public void eventReceived(ErrorAnalysisAlgorithmEvent evt) {
                                if (evt.status == ALGORITHM_STATUS.STARTING_SIMULATION) {
                                    int i;
                                    runParamNames = evt.parameterNames;
                                    if (recentParamValues == null) {
                                        numColumns = (short)runParamNames.length;
                                        recentParamValues = new double[10][runParamNames.length + 1];
                                        restartParamValues = new double[runParamNames.length];
                                        recentErrors = new double[10];
                                        recentVErrors = new double[10];
                                    }
                                    if (row < 10) {
                                        AutoExpControl.recentParamValues[AutoExpControl.row] = AutoExpControl.copyDoubleArray(evt.parameterValues);
                                        AutoExpControl.recentErrors[AutoExpControl.row] = -1.0;
                                        short s = row;
                                        row = (short)(s + 1);
                                        AutoExpControl.recentVErrors[s] = -1.0;
                                    } else {
                                        i = 0;
                                        while (i < 9) {
                                            int j = 0;
                                            while (j < runParamNames.length) {
                                                AutoExpControl.recentParamValues[i][j] = recentParamValues[i + 1][j];
                                                ++j;
                                            }
                                            AutoExpControl.recentErrors[i] = recentErrors[i + 1];
                                            AutoExpControl.recentVErrors[i] = recentVErrors[i + 1];
                                            ++i;
                                        }
                                        AutoExpControl.recentParamValues[AutoExpControl.row - 1] = AutoExpControl.copyDoubleArray(evt.parameterValues);
                                        AutoExpControl.recentErrors[AutoExpControl.row - 1] = -1.0;
                                        AutoExpControl.recentVErrors[AutoExpControl.row - 1] = -1.0;
                                    }
                                    i = 0;
                                    while (i < restartParamValues.length) {
                                        if (restartWithLatest) {
                                            if (recentParamValues != null) {
                                                AutoExpControl.restartParamValues[i] = recentParamValues[row - 1][i];
                                            }
                                        } else if (bestParamValues != null) {
                                            AutoExpControl.restartParamValues[i] = bestParamValues[i];
                                        }
                                        ++i;
                                    }
                                    Display display = Display.getDefault();
                                    if (!display.isDisposed()) {
                                        try {
                                            display.asyncExec(new Runnable(){

                                                @Override
                                                public void run() {
                                                    if (!valuesInitialized) {
                                                        AutoExpControl.initializeValueLabels(runParamNames);
                                                        AutoExpControl.initializeControlLabels(runParamNames);
                                                    }
                                                    AutoExpControl.updateValueLabels();
                                                }
                                            });
                                        }
                                        catch (Exception j) {}
                                    }
                                } else if (evt.status == ALGORITHM_STATUS.FINISHED_ALGORITHM) {
                                    display.asyncExec(new Runnable(){

                                        @Override
                                        public void run() {
                                            ((this).this).AutoExpControl.this.restartButton.setEnabled(true);
                                            ((this).this).AutoExpControl.this.stopButton.setEnabled(false);
                                        }
                                    });
                                } else if (evt.status == ALGORITHM_STATUS.FINISHED_SIMULATION) {
                                    ErrorResult result = evt.result;
                                    double plottableError = AutoExpControl.plottableError(result.getError());
                                    AutoExpControl.recentErrors[AutoExpControl.row - 1] = evt.result.getError();
                                    AutoExpControl.recentVErrors[AutoExpControl.row - 1] = evt.result.getValidationError();
                                    if (result != null) {
                                        Display display;
                                        AutoExpControl.appendLatestErrorData(plottableError);
                                        AutoExpControl.setRecentTimeSeries(result.getError(), result.getValidationError(), (EList<Double>)result.getErrorByTimeStep(), (EList<Double>)result.getReferenceByTime(), (EList<Double>)result.getModelByTime());
                                        if (bestParamValues == null) {
                                            bestParamValues = AutoExpControl.copyDoubleArray(recentParamValues[row - 1]);
                                            bestError = result.getError();
                                            bestVError = result.getValidationError();
                                        }
                                        if (!(display = Display.getDefault()).isDisposed()) {
                                            try {
                                                display.asyncExec(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        AutoExpControl.updateCharts();
                                                        AutoExpControl.updateValueLabels();
                                                    }
                                                });
                                            }
                                            catch (Exception exception) {}
                                        }
                                    }
                                } else {
                                    ALGORITHM_STATUS cfr_ignored_0 = evt.status;
                                }
                            }
                        });
                    }
                }
            });
        }
        AutoExpControl.updateCharts();
    }

    static double plottableError(double error) {
        if (error == Double.POSITIVE_INFINITY || error == Double.NEGATIVE_INFINITY || Double.isNaN(error) || error == Double.MAX_VALUE) {
            return 100.0;
        }
        return error;
    }

    private void reset() {
        int n;
        int n2;
        CLabel[] cLabelArray;
        int i;
        errorHistory = new double[1];
        AutoExpControl.errorHistory[0] = 0.0;
        newErrorTimeSeries = new double[1];
        AutoExpControl.newErrorTimeSeries[0] = 0.0;
        referenceIncidence = new double[1];
        AutoExpControl.referenceIncidence[0] = 0.0;
        modelIncidence = new double[1];
        AutoExpControl.modelIncidence[0] = 0.0;
        errorConvergenceByRun.resetData();
        currentErrorByTime.resetData();
        aggregateErrorByTime.resetData();
        errorHistoryList = new ArrayList<Double>();
        bestSeries = null;
        bestError = Double.MAX_VALUE;
        bestVError = Double.MAX_VALUE;
        runParamNames = null;
        bestParamValues = null;
        restartParamValues = null;
        recentParamValues = null;
        recentErrors = null;
        recentVErrors = null;
        if (attributeLabels != null) {
            i = 0;
            while (i < attributeLabels.length) {
                attributeLabels[i].dispose();
                AutoExpControl.attributeLabels[i] = null;
                ++i;
            }
        }
        attributeLabels = null;
        if (bestValueLabels != null) {
            i = 0;
            while (i < bestValueLabels.length) {
                bestValueLabels[i].dispose();
                AutoExpControl.bestValueLabels[i] = null;
                ++i;
            }
        }
        bestValueLabels = null;
        if (recentValueLabels != null) {
            i = 0;
            while (i < recentValueLabels.length) {
                int j = 0;
                while (j < recentValueLabels[i].length) {
                    recentValueLabels[i][j].dispose();
                    AutoExpControl.recentValueLabels[i][j] = null;
                    ++j;
                }
                ++i;
            }
        }
        recentValueLabels = null;
        if (controlLabels != null) {
            cLabelArray = controlLabels;
            n2 = controlLabels.length;
            n = 0;
            while (n < n2) {
                CLabel lab = cLabelArray[n];
                lab.dispose();
                ++n;
            }
        }
        controlLabels = null;
        if (restartValues != null) {
            cLabelArray = restartValues;
            n2 = restartValues.length;
            n = 0;
            while (n < n2) {
                CLabel t = cLabelArray[n];
                t.dispose();
                ++n;
            }
        }
        row = 0;
        numColumns = 0;
        valuesInitialized = false;
    }

    public static void updateCharts() {
        errorConvergenceByRun.draw();
        currentErrorByTime.draw();
        aggregateErrorByTime.draw();
    }

    public static void redrawCharts() {
        errorConvergenceByRun.redraw();
        currentErrorByTime.redraw();
        aggregateErrorByTime.redraw();
    }

    private void getErrorTimeSeriesChart(Composite dataComposite) {
        currentErrorByTime = new ErrorTimeSeriesCanvas(this, dataComposite, Messages.getString("AUTO.TITLE2"), Messages.getString("AUTO.ERROR"), Messages.getString("AUTO.TIME"), Messages.getString("AUTO.TITLE2"), foreGround, backgroundGround, frameColor, 1, true);
        FormData timeSeriesFormData = new FormData();
        currentErrorByTime.setLayoutData(timeSeriesFormData);
        timeSeriesFormData.top = new FormAttachment((Control)dataComposite, 0);
        timeSeriesFormData.bottom = new FormAttachment(100, 0);
        timeSeriesFormData.left = new FormAttachment(0, 0);
        timeSeriesFormData.right = new FormAttachment(100, 0);
        currentErrorByTime.redraw();
    }

    private void getAggregateTimeSeriesChart(Composite dataComposite) {
        aggregateErrorByTime = new AggregateTimeSeriesCanvas(this, dataComposite, Messages.getString("AUTO.TITLE4"), Messages.getString("AUTO.INCIDENCE"), Messages.getString("AUTO.TIME"), Messages.getString("AUTO.TITLE4"), foreGround, backgroundGround, frameColor, 2, true);
        FormData timeSeriesFormData = new FormData();
        aggregateErrorByTime.setLayoutData(timeSeriesFormData);
        timeSeriesFormData.top = new FormAttachment((Control)dataComposite, 0);
        timeSeriesFormData.bottom = new FormAttachment(100, 0);
        timeSeriesFormData.left = new FormAttachment(0, 0);
        timeSeriesFormData.right = new FormAttachment(100, 0);
        aggregateErrorByTime.redraw();
    }

    private void getRunHistoryChart(Composite dataComposite) {
        errorConvergenceByRun = new RunHistoryCanvas(this, dataComposite, Messages.getString("AUTO.TITLE1"), Messages.getString("AUTO.ERROR"), Messages.getString("AUTO.RUN"), Messages.getString("AUTO.TITLE1"), foreGround, backgroundGround, frameColor, 0, true);
        FormData TimeSeries1FormData = new FormData();
        errorConvergenceByRun.setLayoutData(TimeSeries1FormData);
        TimeSeries1FormData.top = new FormAttachment((Control)dataComposite, 0);
        TimeSeries1FormData.bottom = new FormAttachment(100, 0);
        TimeSeries1FormData.left = new FormAttachment(0, 0);
        TimeSeries1FormData.right = new FormAttachment(100, 0);
        errorConvergenceByRun.redraw();
    }

    private void getControls() {
        controlsComposite.setLayout((Layout)new FormLayout());
        FormData controlTopFormData = new FormData();
        controlsActionComposite = new Composite(controlsComposite, 2048);
        controlsActionComposite.setLayoutData((Object)controlTopFormData);
        controlTopFormData.top = new FormAttachment(0, 0);
        controlTopFormData.bottom = new FormAttachment(20, 0);
        controlTopFormData.left = new FormAttachment(0, 0);
        controlTopFormData.right = new FormAttachment(100, 0);
        FormData controlBottomFormData = new FormData();
        controlsValuesComposite = new Composite(controlsComposite, 2048);
        controlsValuesComposite.setLayoutData((Object)controlBottomFormData);
        controlBottomFormData.top = new FormAttachment((Control)controlsActionComposite, 0);
        controlBottomFormData.bottom = new FormAttachment(100, 0);
        controlBottomFormData.left = new FormAttachment(0, 0);
        controlBottomFormData.right = new FormAttachment(100, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 5;
        gridLayout.makeColumnsEqualWidth = true;
        controlsActionComposite.setLayout((Layout)gridLayout);
        CLabel stopLabel = new CLabel(controlsActionComposite, 0);
        stopLabel.setText(Messages.getString("AUTO.STOP"));
        this.stopButton = new Button(controlsActionComposite, 8);
        this.stopButton.setImage(this.imageRegistry.get("stop.image"));
        this.stopButton.setEnabled(false);
        CLabel noLabel1 = new CLabel(controlsActionComposite, 0);
        noLabel1.setText("");
        Button[] radios = new Button[2];
        radios[0] = new Button(controlsActionComposite, 16);
        radios[0].setSelection(true);
        radios[0].setText(Messages.getString("AUTO.LATEST"));
        radios[0].setBounds(10, 5, 75, 30);
        radios[1] = new Button(controlsActionComposite, 16);
        radios[1].setText(Messages.getString("AUTO.BEST"));
        radios[1].setBounds(10, 30, 75, 30);
        radios[0].setSelection(true);
        CLabel restartLabel = new CLabel(controlsActionComposite, 0);
        restartLabel.setText(Messages.getString("AUTO.RESTART"));
        this.restartButton = new Button(controlsActionComposite, 8);
        this.restartButton.setImage(this.imageRegistry.get("restart.image"));
        this.restartButton.setEnabled(false);
        CLabel paramsLabel = new CLabel(controlsActionComposite, 0);
        paramsLabel.setText(Messages.getString("AUTO.RESTART_HEADER"));
        CLabel noLabel2 = new CLabel(controlsActionComposite, 0);
        noLabel2.setText("");
        CLabel noLabel3 = new CLabel(controlsActionComposite, 0);
        noLabel3.setText("");
        this.stopButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        AutoExpControl.this.stopButton.setEnabled(false);
                        AutomaticExperimentManager.getInstance().quitNow();
                        AutoExpControl.this.restartButton.setEnabled(true);
                    }
                }
            }
        });
        this.restartButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        AutomaticExperimentManager.getInstance().restartNow(restartParamValues);
                    }
                }
            }
        });
        radios[0].addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        AutoExpControl.selectLatestAction();
                    }
                }
            }
        });
        radios[1].addListener(13, new Listener(){

            public void handleEvent(Event e) {
                switch (e.type) {
                    case 13: {
                        AutoExpControl.selectBestAction();
                    }
                }
            }
        });
        controlsComposite.pack();
        controlsComposite.layout();
        controlsComposite.setVisible(true);
    }

    private void getSettings() {
        settingsComposite.setLayout((Layout)new FormLayout());
        settingsComposite.pack();
        settingsComposite.layout();
        settingsComposite.setVisible(true);
    }

    private static void selectLatestAction() {
        restartWithLatest = true;
        if (bestParamValues != null) {
            int i = 0;
            while (i < bestParamValues.length - 1) {
                if (recentParamValues != null) {
                    AutoExpControl.restartParamValues[i] = recentParamValues[row - 1][i];
                }
                ++i;
            }
        }
        AutoExpControl.updateRestartLabels(white);
    }

    private static void selectBestAction() {
        restartWithLatest = false;
        if (bestParamValues != null) {
            int i = 0;
            while (i < bestParamValues.length - 1) {
                AutoExpControl.restartParamValues[i] = bestParamValues[i];
                ++i;
            }
        }
        AutoExpControl.updateRestartLabels(lightGreen);
    }

    protected static void updateValueLabels() {
        int i;
        if (bestParamValues != null) {
            i = 0;
            while (i < numColumns) {
                bestValueLabels[i].setText(String.valueOf(bestParamValues[i]));
                ++i;
            }
            bestValueLabels[numColumns].setText(String.valueOf(bestError));
            bestValueLabels[numColumns + 1].setText(String.valueOf(bestVError));
        }
        i = 0;
        while (i < 10) {
            int j = 0;
            while (j < numColumns + 1) {
                if (j < numColumns) {
                    recentValueLabels[i][j].setText(String.valueOf(recentParamValues[i][j]));
                } else if (recentErrors[i] != -1.0) {
                    recentValueLabels[i][j].setText(String.valueOf(recentErrors[i]));
                    recentValueLabels[i][j + 1].setText(String.valueOf(recentVErrors[i]));
                } else {
                    recentValueLabels[i][j].setText("...");
                    recentValueLabels[i][j + 1].setText("...");
                }
                ++j;
            }
            ++i;
        }
        valuesComposite.redraw();
        valuesComposite.update();
        if (restartParamValues != null) {
            int j = 0;
            while (j < numColumns) {
                restartValues[j].setText(String.valueOf(restartParamValues[j]));
                ++j;
            }
            controlsValuesComposite.redraw();
            controlsValuesComposite.update();
        }
    }

    protected static void updateRestartLabels(final Color bg) {
        try {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (restartParamValues != null) {
                        int j = 0;
                        while (j < numColumns) {
                            restartValues[j].setText(String.valueOf(restartParamValues[j]));
                            restartValues[j].setBackground(bg);
                            ++j;
                        }
                        controlsValuesComposite.redraw();
                        controlsValuesComposite.update();
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected static void initializeValueLabels(String[] attributes) {
        int numAttrEntries;
        int numColumns = numAttrEntries = attributes.length;
        GridLayout gl = new GridLayout();
        gl.numColumns = numColumns + 2;
        valuesComposite.setLayout((Layout)gl);
        controlsValuesComposite.setLayout((Layout)gl);
        int width = 800 / numColumns;
        attributeLabels = new CLabel[numColumns + 2];
        bestValueLabels = new Text[numColumns + 2];
        recentValueLabels = new Text[10][numColumns + 2];
        int i = 0;
        while (i < numColumns) {
            AutoExpControl.attributeLabels[i] = new CLabel(valuesComposite, 2048);
            attributeLabels[i].setText(attributes[i]);
            attributeLabels[i].setBackground(cyan);
            GridData titleGridData = new GridData();
            attributeLabels[i].setLayoutData((Object)titleGridData);
            titleGridData.grabExcessHorizontalSpace = true;
            titleGridData.minimumWidth = width;
            titleGridData.horizontalAlignment = 4;
            ++i;
        }
        AutoExpControl.attributeLabels[numColumns] = new CLabel(valuesComposite, 2048);
        attributeLabels[numColumns].setText("Error");
        attributeLabels[numColumns].setBackground(cyan);
        AutoExpControl.attributeLabels[numColumns + 1] = new CLabel(valuesComposite, 2048);
        attributeLabels[numColumns + 1].setText("VError");
        attributeLabels[numColumns + 1].setBackground(cyan);
        GridData titleGridData = new GridData();
        attributeLabels[numColumns].setLayoutData((Object)titleGridData);
        titleGridData.grabExcessHorizontalSpace = true;
        titleGridData.minimumWidth = width;
        titleGridData.horizontalAlignment = 4;
        GridData titleGridData2 = new GridData();
        attributeLabels[numColumns + 1].setLayoutData((Object)titleGridData2);
        titleGridData2.grabExcessHorizontalSpace = true;
        titleGridData2.minimumWidth = width;
        titleGridData2.horizontalAlignment = 4;
        int i2 = 0;
        while (i2 < numColumns + 2) {
            AutoExpControl.bestValueLabels[i2] = new Text(valuesComposite, 2048);
            bestValueLabels[i2].setText("");
            bestValueLabels[i2].setBackground(lightGreen);
            GridData textGridData = new GridData();
            bestValueLabels[i2].setLayoutData((Object)textGridData);
            textGridData.grabExcessHorizontalSpace = true;
            textGridData.minimumWidth = width;
            textGridData.horizontalAlignment = 4;
            ++i2;
        }
        i2 = 0;
        while (i2 < 10) {
            int j = 0;
            while (j < numColumns + 2) {
                AutoExpControl.recentValueLabels[i2][j] = new Text(valuesComposite, 2048);
                recentValueLabels[i2][j].setText("");
                recentValueLabels[i2][j].setBackground(white);
                GridData textGridData = new GridData();
                recentValueLabels[i2][j].setLayoutData((Object)textGridData);
                textGridData.grabExcessHorizontalSpace = true;
                textGridData.minimumWidth = width;
                textGridData.horizontalAlignment = 4;
                ++j;
            }
            ++i2;
        }
        valuesComposite.layout();
        valuesComposite.redraw();
        valuesInitialized = true;
    }

    protected static void initializeControlLabels(String[] attributes) {
        int numAttrEntries;
        int numColumns = numAttrEntries = attributes.length;
        GridLayout gl = new GridLayout();
        gl.numColumns = numColumns;
        controlsValuesComposite.setLayout((Layout)gl);
        int width = 800 / numColumns;
        controlLabels = new CLabel[numColumns];
        restartValues = new Text[numColumns];
        int i = 0;
        while (i < numColumns) {
            AutoExpControl.controlLabels[i] = new CLabel(controlsValuesComposite, 2048);
            controlLabels[i].setText(attributes[i]);
            controlLabels[i].setBackground(cyan);
            GridData titleGridData = new GridData();
            controlLabels[i].setLayoutData((Object)titleGridData);
            titleGridData.grabExcessHorizontalSpace = true;
            titleGridData.minimumWidth = width;
            titleGridData.horizontalAlignment = 4;
            ++i;
        }
        GridData titleGridData = new GridData();
        titleGridData.grabExcessHorizontalSpace = true;
        titleGridData.minimumWidth = width;
        titleGridData.horizontalAlignment = 4;
        int j = 0;
        while (j < numColumns) {
            AutoExpControl.restartValues[j] = new Text(controlsValuesComposite, 2048);
            restartValues[j].setText("");
            restartValues[j].setBackground(white);
            GridData textGridData = new GridData();
            restartValues[j].setLayoutData((Object)textGridData);
            textGridData.grabExcessHorizontalSpace = true;
            textGridData.minimumWidth = width;
            textGridData.horizontalAlignment = 4;
            final int ind = j;
            restartValues[j].addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    try {
                        String text = ((Text)e.getSource()).getText();
                        AutoExpControl.restartParamValues[ind] = Double.parseDouble(text);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            ++j;
        }
        controlsValuesComposite.layout();
        controlsValuesComposite.redraw();
        valuesInitialized = true;
    }

    public void dispose() {
        super.dispose();
    }

    public Identifiable getIdentifiable() {
        return null;
    }

    @Override
    public double[] getValues(int chartIndex, int state) {
        if (chartIndex == 0) {
            return errorHistory;
        }
        if (chartIndex == 1) {
            if (state == 0) {
                return newErrorTimeSeries;
            }
            if (state == 1) {
                return bestSeries;
            }
        }
        if (chartIndex == 2) {
            if (state == 0) {
                return referenceIncidence;
            }
            if (state == 1) {
                return modelIncidence;
            }
        }
        return null;
    }

    @Override
    public String getProperty(int chartIndex, int state) {
        if (chartIndex == 0) {
            return Messages.getString("AUTO.TITLE1");
        }
        if (chartIndex == 1) {
            if (state == 0) {
                return Messages.getString("AUTO.TITLE2");
            }
            if (state == 1) {
                return Messages.getString("AUTO.TITLE3");
            }
        }
        if (chartIndex == 2) {
            if (state == 0) {
                return Messages.getString("AUTO.TITLE4");
            }
            if (state == 1) {
                return Messages.getString("AUTO.TITLE5");
            }
        }
        return Messages.getString("AUTO.NOTFOUNDERROR");
    }

    @Override
    public int getNumProperties(int chartIndex) {
        if (chartIndex == 0) {
            return 1;
        }
        if (chartIndex == 1) {
            return 2;
        }
        if (chartIndex == 2) {
            return 2;
        }
        return 0;
    }

    public static void appendLatestErrorData(double error) {
        errorHistoryList.add(new Double(error));
        errorHistory = new double[errorHistoryList.size()];
        int i = 0;
        while (i < errorHistoryList.size()) {
            AutoExpControl.errorHistory[i] = errorHistoryList.get(i);
            ++i;
        }
    }

    public static void setRecentTimeSeries(double error, double verror, EList<Double> errorByTimeStep, EList<Double> refIncidence, EList<Double> incidence) {
        newErrorTimeSeries = new double[errorByTimeStep.size()];
        referenceIncidence = new double[refIncidence.size()];
        modelIncidence = new double[incidence.size()];
        int i = 0;
        while (i < errorByTimeStep.size()) {
            AutoExpControl.newErrorTimeSeries[i] = (Double)errorByTimeStep.get(i);
            AutoExpControl.referenceIncidence[i] = (Double)refIncidence.get(i);
            AutoExpControl.modelIncidence[i] = (Double)incidence.get(i);
            ++i;
        }
        if (bestSeries == null) {
            bestSeries = newErrorTimeSeries;
        }
        if (error <= bestError) {
            bestError = error;
            bestVError = verror;
            bestSeries = newErrorTimeSeries;
            bestParamValues = AutoExpControl.copyDoubleArray(recentParamValues[row - 1]);
        }
    }

    @Override
    protected void initializeHeader(String folderName) {
    }

    @Override
    public void remove() {
    }

    protected static double[] copyDoubleArray(double[] s) {
        double[] t = new double[s.length];
        int i = 0;
        double[] dArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            t[i++] = d;
            ++n2;
        }
        return t;
    }
}

