/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.model.ApiModelCache;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;

public abstract class AbstractApiTypeContainer
extends ApiElement
implements IApiTypeContainer {
    private List<IApiTypeContainer> fApiTypeContainers = null;

    protected AbstractApiTypeContainer(IApiElement parent, int type, String name) {
        super(parent, type, name);
    }

    @Override
    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        IApiTypeContainer[] containers;
        IApiTypeContainer[] iApiTypeContainerArray = containers = this.getApiTypeContainers();
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IApiTypeContainer container = iApiTypeContainerArray[n2];
            container.accept(visitor);
            ++n2;
        }
    }

    @Override
    public synchronized void close() throws CoreException {
        IApiTypeContainer[] containers;
        if (this.fApiTypeContainers == null) {
            return;
        }
        ApiModelCache.getCache().removeElementInfo(this);
        MultiStatus multi = null;
        IStatus single = null;
        IApiTypeContainer[] iApiTypeContainerArray = containers = this.getApiTypeContainers();
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IApiTypeContainer container = iApiTypeContainerArray[n2];
            try {
                container.close();
            }
            catch (CoreException e) {
                if (single == null) {
                    single = e.getStatus();
                }
                if (multi == null) {
                    multi = new MultiStatus("org.eclipse.pde.api.tools", single.getCode(), single.getMessage(), single.getException());
                }
                multi.add(e.getStatus());
            }
            ++n2;
        }
        if (multi != null) {
            throw new CoreException(multi);
        }
        if (single != null) {
            throw new CoreException(single);
        }
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName) throws CoreException {
        IApiTypeContainer[] containers;
        IApiTypeContainer[] iApiTypeContainerArray = containers = this.getApiTypeContainers();
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IApiTypeContainer container = iApiTypeContainerArray[n2];
            IApiTypeRoot file = container.findTypeRoot(qualifiedName);
            if (file != null) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public IApiTypeRoot findTypeRoot(String qualifiedName, String id) throws CoreException {
        IApiTypeContainer[] containers = this.getApiTypeContainers();
        String origin = null;
        IApiComponent comp = null;
        IApiTypeContainer[] iApiTypeContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IApiTypeRoot file;
            IApiTypeContainer container = iApiTypeContainerArray[n2];
            comp = (IApiComponent)container.getAncestor(1);
            if (comp != null && (origin = comp.getSymbolicName()) != null && !origin.equals(id) && comp.isFragment()) {
                IApiComponent rootComp = comp;
                while (rootComp != null && rootComp.isFragment()) {
                    rootComp = rootComp.getHost();
                }
                if (rootComp != null) {
                    origin = rootComp.getSymbolicName();
                }
            }
            if (origin == null ? (file = container.findTypeRoot(qualifiedName)) != null : origin.equals(id) && (file = container.findTypeRoot(qualifiedName, id)) != null) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public String[] getPackageNames() throws CoreException {
        IApiTypeContainer[] containers;
        ArrayList<String> names = new ArrayList<String>();
        IApiTypeContainer[] iApiTypeContainerArray = containers = this.getApiTypeContainers();
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            String[] packageNames;
            IApiTypeContainer container = iApiTypeContainerArray[n2];
            String[] stringArray = packageNames = container.getPackageNames();
            int n3 = packageNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String packageName = stringArray[n4];
                names.add(packageName);
                ++n4;
            }
            ++n2;
        }
        Object[] result = new String[names.size()];
        names.toArray(result);
        Arrays.sort(result);
        return result;
    }

    protected synchronized IApiTypeContainer[] getApiTypeContainers() throws CoreException {
        if (this.fApiTypeContainers == null) {
            this.fApiTypeContainers = this.createApiTypeContainers();
        }
        return this.fApiTypeContainers.toArray(new IApiTypeContainer[this.fApiTypeContainers.size()]);
    }

    protected synchronized IApiTypeContainer[] getApiTypeContainers(String id) throws CoreException {
        if (this.fApiTypeContainers == null) {
            this.fApiTypeContainers = this.createApiTypeContainers();
        }
        ArrayList<IApiTypeContainer> containers = new ArrayList<IApiTypeContainer>();
        String origin = null;
        IApiTypeContainer container2 = null;
        for (IApiTypeContainer container2 : this.fApiTypeContainers) {
            origin = ((IApiComponent)container2.getAncestor(1)).getSymbolicName();
            if (origin == null || !origin.equals(id)) continue;
            containers.add(container2);
        }
        return containers.toArray(new IApiTypeContainer[containers.size()]);
    }

    protected abstract List<IApiTypeContainer> createApiTypeContainers() throws CoreException;

    protected synchronized void setApiTypeContainers(IApiTypeContainer[] containers) {
        if (this.fApiTypeContainers != null) {
            try {
                this.close();
            }
            catch (CoreException coreException) {}
            this.fApiTypeContainers.clear();
        } else {
            this.fApiTypeContainers = new ArrayList<IApiTypeContainer>(containers.length);
        }
        IApiTypeContainer[] iApiTypeContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IApiTypeContainer container = iApiTypeContainerArray[n2];
            this.fApiTypeContainers.add(container);
            ++n2;
        }
    }

    @Override
    public int getContainerType() {
        return 0;
    }
}

