/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.util.loggers.htmlgeneration;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stem.core.common.DublinCore;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.model.Model;
import org.eclipse.stem.core.scenario.Scenario;
import org.eclipse.stem.core.sequencer.Sequencer;
import org.eclipse.stem.core.solver.Solver;
import org.eclipse.stem.util.loggers.Activator;
import org.eclipse.stem.util.loggers.htmlgeneration.A;
import org.eclipse.stem.util.loggers.htmlgeneration.Body;
import org.eclipse.stem.util.loggers.htmlgeneration.HTMLdocument;
import org.eclipse.stem.util.loggers.htmlgeneration.Head;
import org.eclipse.stem.util.loggers.htmlgeneration.Script;
import org.eclipse.stem.util.loggers.htmlgeneration.Span;
import org.eclipse.stem.util.loggers.htmlgeneration.Style;
import org.eclipse.stem.util.loggers.htmlgeneration.TD;
import org.eclipse.stem.util.loggers.htmlgeneration.TR;
import org.eclipse.stem.util.loggers.htmlgeneration.Table;
import org.eclipse.stem.util.loggers.htmlgeneration.Tbody;
import org.eclipse.stem.util.loggers.htmlgeneration.Title;

public class HtmlScenarioPage
extends HTMLdocument {
    private static final String DECORATOR_STRING = "Decorator";
    private static final String DUBLIN_CORE_STRING = "Dublin Core";
    private static final String MODEL_STRING = "Model";
    private static final String MODEL_GRAPH_STRING = "Graph";
    private static final String SCENARIO_STRING = "Scenario";
    private static final String SEQUENCER_STRING = "Sequencer";
    private static final String SOLVER_STRING = "Solver";
    private static final String STEM_SCENARIO_STRING = "STEM Scenario";
    private static final String DATA_ROW_ID_PREFIX = "DATA_ROW_";
    private static final String DUBLINCORE_ROW_ID_PREFIX = "DUBLINCORE_ROW_";
    private static final String TITLE_ROW_ID_PREFIX = "TITLE_ROW_";
    private static final String COLOR_WHITE = "rgb(255, 255, 255)";
    private static final String COLOR_TITLE0 = "rgb(200, 200, 255)";
    private static final String FILENAME = "ScenarioLog.html";
    private int indent = 0;
    private static final String COLLAPSE = "-";
    private static final String EXPAND = "+";
    private static final String[] CELL_WIDTH = new String[]{"100px", "100px", "200px"};
    private static final String INDENT_WIDTH = "80px";

    public HtmlScenarioPage(Scenario scenario, String directoryName) {
        this.createDocument(scenario);
        String fileName = String.valueOf(directoryName) + FILENAME;
        this.writeDocument(fileName, this.getContents());
    }

    private void createDocument(Scenario scenario) {
        Head head = new Head();
        this.add(head);
        String jsContent = this.readJsFromFile();
        String cssContent = this.readCssFromFile();
        if (!"".equals(jsContent)) {
            Script jsContainer = new Script("type", "text/javascript");
            jsContainer.setData(jsContent);
            head.add(jsContainer);
        }
        if (!"".equals(cssContent)) {
            Style cssContainer = new Style("type", "text/css");
            cssContainer.setData(cssContent);
            head.add(cssContainer);
        }
        Model parentModel = scenario.getModel();
        EList decoratorList = scenario.getScenarioDecorators();
        Sequencer sequencer = scenario.getSequencer();
        Solver solver = scenario.getSolver();
        String scenarioURI = scenario.getURI().toString();
        String scenarioTitle = HtmlScenarioPage.getShortName(scenarioURI);
        Title title = new Title(scenarioTitle);
        head.add(title);
        Body body = new Body();
        body.addAttribute("onload", "collapseDublinCores();");
        this.add(body);
        Table table = new Table("style", "text-align: left; width: 100%;");
        table.addAttribute("border", "4");
        table.addAttribute("cellpadding", "2");
        table.addAttribute("cellspacing", "5");
        body.add(table);
        Tbody tbody = new Tbody();
        table.add(tbody);
        table.setTbody(tbody);
        TR tr = new TR("id", TITLE_ROW_ID_PREFIX + scenarioTitle);
        tr.addAttribute("align", "left");
        tbody.add(tr);
        TD td = new TD("style", "background-color: rgb(200, 200, 255);");
        tr.add(td);
        Span span2 = new Span("style", "font-weight: bold;");
        span2.setData("-STEM Scenario: " + scenarioTitle);
        td.add(span2);
        Table scenarioTable = this.getNewTable(tbody);
        this.populateTablefromObject(scenarioTable.getTbody(), (EObject)scenario, SCENARIO_STRING, null, true);
        this.addSectionList(scenarioTable.getTbody(), decoratorList, DECORATOR_STRING, true);
        this.populateTablefromObject(scenarioTable.getTbody(), (EObject)sequencer, SEQUENCER_STRING, null, true);
        this.populateTablefromObject(scenarioTable.getTbody(), (EObject)solver, SOLVER_STRING, null, true);
        this.addModelContents(tbody, parentModel, true);
        this.writeDocument("/test.html", this.getContents());
    }

    public void addModelContents(Tbody tbody, Model model, boolean top) {
        if (model != null) {
            EList modelList;
            EList graphList;
            EList graphDecoratorList;
            EList edgeDecoratorList;
            ++this.indent;
            Table modelTable = this.getNewTable(tbody);
            this.populateTablefromObject(modelTable.getTbody(), (EObject)model, MODEL_STRING, null, true);
            Tbody modelTableBody = modelTable.getTbody();
            EList nodeDecoratorList = model.getNodeDecorators();
            if (nodeDecoratorList != null && nodeDecoratorList.size() >= 1) {
                this.addSectionList(modelTableBody, nodeDecoratorList, DECORATOR_STRING, true);
            }
            if ((edgeDecoratorList = model.getEdgeDecorators()) != null && edgeDecoratorList.size() >= 1) {
                this.addSectionList(modelTableBody, edgeDecoratorList, DECORATOR_STRING, true);
            }
            if ((graphDecoratorList = model.getGraphDecorators()) != null && graphDecoratorList.size() >= 1) {
                this.addSectionList(modelTableBody, graphDecoratorList, DECORATOR_STRING, true);
            }
            if ((graphList = model.getGraphs()) != null && graphList.size() >= 1) {
                this.addSectionList(modelTableBody, graphList, MODEL_GRAPH_STRING, true);
            }
            if ((modelList = model.getModels()) != null && modelList.size() >= 1 && modelTableBody != null) {
                int i = 0;
                while (i < modelList.size()) {
                    Model innerModel = (Model)modelList.get(i);
                    this.addModelContents(tbody, innerModel, false);
                    ++i;
                }
            }
        }
    }

    public void addSectionList(Tbody tbody, EList<?> eList, String type, boolean addDublinCore) {
        if (eList != null) {
            int i = 0;
            while (i < eList.size()) {
                Object object = eList.get(i);
                if (object instanceof EObject) {
                    this.populateTablefromObject(tbody, (EObject)object, type, null, addDublinCore);
                }
                ++i;
            }
        }
    }

    private void populateTablefromObject(Tbody tbody, EObject eObject, String description, String name, boolean addDublinCore) {
        if (eObject != null) {
            if (eObject instanceof Identifiable && (name == null || name.length() == 0)) {
                Identifiable ident = (Identifiable)eObject;
                name = HtmlScenarioPage.getShortName(ident.getURI().toString());
            }
            String eClass = eObject.eClass().getName();
            TR trSpacer = new TR();
            tbody.add(trSpacer);
            this.indentTableRow(trSpacer);
            String rowId = TITLE_ROW_ID_PREFIX + name;
            TR tr = new TR("id", rowId);
            tr.addAttribute("class", "idHeader");
            this.indentTableRow(tr);
            tbody.add(tr);
            int i = 0;
            while (i < 3) {
                TD td = new TD();
                tr.add(td);
                if (i == 0) {
                    A anchor = new A(null, null);
                    anchor.addAttribute("href", "#");
                    anchor.addAttribute("onclick", "toggle(this);return false;");
                    anchor.addAttribute("id", String.valueOf(rowId) + "_toggle");
                    anchor.setData(COLLAPSE + description);
                    td.add(anchor);
                }
                if (name == null || name.length() == 0) {
                    name = "name not set";
                }
                if (i == 1) {
                    td.setData(name);
                }
                if (i == 2) {
                    td.setData(eClass);
                }
                ++i;
            }
            EList attrList = eObject.eClass().getEAllAttributes();
            if (attrList != null) {
                int i2 = 0;
                while (i2 < attrList.size()) {
                    EAttribute feature = (EAttribute)attrList.get(i2);
                    if (!feature.isTransient()) {
                        String val;
                        String attribute = feature.getName();
                        Object target = eObject.eGet((EStructuralFeature)feature);
                        if (target != null && (val = target.toString()).length() >= 1) {
                            String idSuffix = null;
                            if (eObject instanceof Identifiable) {
                                Identifiable ident = (Identifiable)eObject;
                                idSuffix = ident.getURI().toString();
                            } else {
                                double r = Math.random();
                                idSuffix = "id" + (int)(r *= 1.0E8);
                            }
                            idSuffix = String.valueOf(idSuffix) + "_" + attribute;
                            TR tr2 = new TR("id", DATA_ROW_ID_PREFIX + i2 + "_" + idSuffix);
                            tr2.addAttribute("class", "idBody");
                            this.indentTableRow(tr2);
                            tbody.add(tr2);
                            TD td1 = new TD("align", "left");
                            tr2.add(td1);
                            TD td2 = new TD("align", "right");
                            tr2.add(td2);
                            td2.setData(String.valueOf(attribute) + ":   ");
                            TD td3 = new TD("align", "left");
                            tr2.add(td3);
                            td3.setData(val);
                        }
                    }
                    ++i2;
                }
            }
            if (addDublinCore) {
                Identifiable ident = (Identifiable)eObject;
                DublinCore dc = ident.getDublinCore();
                if (ident != null) {
                    this.addDCtoTable(dc, tbody);
                }
            }
        }
    }

    private void addDCtoTable(DublinCore dublinCore, Tbody tbody) {
        TR tr = new TR("align", "center");
        tbody.add(tr);
        EList attrList = dublinCore.eClass().getEStructuralFeatures();
        if (attrList != null) {
            int i = 0;
            while (i < attrList.size()) {
                String val;
                EAttribute attr = (EAttribute)attrList.get(i);
                Object obj = dublinCore.eGet((EStructuralFeature)attr);
                if (obj != null && (val = obj.toString()).length() >= 0) {
                    String idSuffix = dublinCore.getIdentifier();
                    if (idSuffix == null || idSuffix.length() == 0) {
                        double r = Math.random();
                        idSuffix = "id" + (int)(r *= 1.0E8);
                    }
                    String rowId = DUBLINCORE_ROW_ID_PREFIX + i + "_" + idSuffix;
                    TR tr2 = new TR("id", rowId);
                    tbody.add(tr2);
                    this.indentTableRow(tr2);
                    TD td1 = new TD();
                    td1.addAttribute("style", "width: " + CELL_WIDTH[0] + ";");
                    td1.addAttribute("class", "dcHeader");
                    if (i == 0) {
                        A anchor = new A("href", "#");
                        anchor.addAttribute("onclick", "toggle(this);return false;");
                        anchor.setData("+Dublin Core");
                        td1.add(anchor);
                    }
                    tr2.add(td1);
                    TD td2 = new TD("align", "right");
                    td2.addAttribute("style", "width: " + CELL_WIDTH[1] + ";");
                    td2.addAttribute("class", "dcBody");
                    td2.setData(String.valueOf(attr.getName()) + ":   ");
                    tr2.add(td2);
                    TD td3 = new TD();
                    td3.addAttribute("style", "width: " + CELL_WIDTH[2] + ";");
                    td3.addAttribute("class", "dcBody");
                    td3.setData(val);
                    tr2.add(td3);
                }
                ++i;
            }
        }
    }

    public Table getNewTable(Tbody parentTableBody) {
        Table newTable = new Table("style", "text-align: left;");
        newTable.addAttribute("width", "100%");
        newTable.addAttribute("border", "0");
        newTable.addAttribute("frame", "box");
        newTable.addAttribute("cellpadding", "2");
        newTable.addAttribute("cellspacing", "2");
        Tbody newTbody = new Tbody();
        newTable.add(newTbody);
        newTable.setTbody(newTbody);
        TR trParent = new TR();
        parentTableBody.add(trParent);
        TD tdParent = new TD();
        trParent.add(tdParent);
        tdParent.add(newTable);
        TR trSpacer = new TR();
        newTbody.add(trSpacer);
        this.indentTableRow(trSpacer);
        int i = 0;
        while (i < 3) {
            TD td = new TD("style", "background-color: rgb(255, 255, 255);");
            td.addAttribute("style", "width: " + CELL_WIDTH[i] + ";");
            trSpacer.add(td);
            ++i;
        }
        TD td2 = new TD("style", "background-color: rgb(255, 255, 255);");
        trSpacer.add(td2);
        return newTable;
    }

    public void indentTableRow(TR trSpacer) {
        int i = 0;
        while (i < this.indent) {
            TD td = new TD();
            td.addAttribute("style", "width: 80px;");
            td.addAttribute("class", "blank");
            trSpacer.add(td);
            ++i;
        }
    }

    public static String getShortName(String longName) {
        int idx = longName.lastIndexOf("/");
        String name = longName.substring(idx + 1, longName.length());
        if ((idx = name.indexOf(".")) >= 3) {
            name = name.substring(0, idx);
        }
        if (name == null || name.length() == 0) {
            name = "Name not set";
        }
        return name;
    }

    private String readJsFromFile() {
        return this.readFromFile("resources/source.js");
    }

    private String readCssFromFile() {
        return this.readFromFile("resources/source.css");
    }

    private String readFromFile(String fileName) {
        StringBuilder data;
        block13: {
            data = new StringBuilder();
            URL jsData = Activator.getDefault().getBundle().getResource(fileName);
            if (jsData != null) {
                BufferedReader reader = null;
                try {
                    try {
                        reader = new BufferedReader(new InputStreamReader(jsData.openStream()));
                        char[] buf = new char[1024];
                        int bytesRead = 0;
                        while ((bytesRead = reader.read(buf)) != -1) {
                            data.append(buf, 0, bytesRead);
                        }
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                        try {
                            reader.close();
                        }
                        catch (Exception exception) {}
                        break block13;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        reader.close();
                    }
                    catch (Exception exception) {}
                    throw throwable;
                }
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
        return data.toString();
    }
}

